/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.latex;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.mode.Controller;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class TeXText {
    private static final String LATEX_MACROS = "latex_macros";
    private static final String LATEX_INTERLINE_SPACING = "latex_interline_spacing";
    String rawText;

    public TeXText(String t) {
        this.rawText = t;
    }

    public TeXIcon createTeXIcon(Color fgColor, int style, int size, int align, int maxWidth) {
        String predefinedMacros;
        StringBuffer sb = new StringBuffer();
        if (Controller.getCurrentController() != null && ResourceController.getResourceController() != null && (predefinedMacros = ResourceController.getResourceController().getProperty(LATEX_MACROS)) != null) {
            sb.append(predefinedMacros + "\n\n");
        }
        sb.append("\n\n").append("\\text{").append(this.rawText).append("}");
        TeXFormula tf = new TeXFormula(sb.toString());
        Quantity latexInterlineSpacingQuantity = ResourceController.getResourceController().getLengthQuantityProperty(LATEX_INTERLINE_SPACING);
        int latexInterlineSpacingUnit = -1;
        float latexInterlineSpacingValue = (float)latexInterlineSpacingQuantity.value;
        if (latexInterlineSpacingQuantity.unit == LengthUnit.px) {
            latexInterlineSpacingUnit = 2;
        } else if (latexInterlineSpacingQuantity.unit == LengthUnit.in) {
            latexInterlineSpacingUnit = 8;
        } else if (latexInterlineSpacingQuantity.unit == LengthUnit.mm) {
            latexInterlineSpacingUnit = 7;
        } else if (latexInterlineSpacingQuantity.unit == LengthUnit.cm) {
            latexInterlineSpacingUnit = 6;
        } else if (latexInterlineSpacingQuantity.unit == LengthUnit.pt) {
            latexInterlineSpacingUnit = 10;
        }
        return new TeXFormula.TeXIconBuilder(tf).setFGColor(fgColor).setStyle(style).setSize((float)size).setWidth(2, (float)maxWidth, align).setIsMaxWidth(true).setInterLineSpacing(latexInterlineSpacingUnit, latexInterlineSpacingValue).build();
    }

    public static void main(String[] argv) {
        StringBuffer latex = new StringBuffer();
        latex.append("Sei $A$ ein Vektorraum und $f:A \\rightarrow \\mathcal{R}$ sei linear.\n");
        latex.append("Wir wissen dass $u=\\pi$, und damit haben wir:");
        latex.append("\\begin{align}");
        latex.append("f(\\lambda u) = \\lambda f(u) = 0.");
        latex.append("\\end{align}");
        TeXText tf = new TeXText("my formula: $x_2=3$hello world hello world hello world hello world hello world hello world hello world hello world hello world ");
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(3);
        JLabel jl = new JLabel();
        jl.setIcon((Icon)tf.createTeXIcon(Color.BLACK, 0, 16, 0, 400));
        Container cp = jf.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)jl, "Center");
        jf.pack();
        jf.setVisible(true);
    }
}

