/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { Config } from '@google/gemini-cli-core';
import type React from 'react';
export declare const PASTE_MODE_START = "\u001B[200~";
export declare const PASTE_MODE_END = "\u001B[201~";
export declare const DRAG_COMPLETION_TIMEOUT_MS = 100;
export declare const KITTY_SEQUENCE_TIMEOUT_MS = 50;
export declare const PASTE_CODE_TIMEOUT_MS = 50;
export declare const SINGLE_QUOTE = "'";
export declare const DOUBLE_QUOTE = "\"";
export interface Key {
    name: string;
    ctrl: boolean;
    meta: boolean;
    shift: boolean;
    paste: boolean;
    sequence: string;
    kittyProtocol?: boolean;
}
export type KeypressHandler = (key: Key) => void;
interface KeypressContextValue {
    subscribe: (handler: KeypressHandler) => void;
    unsubscribe: (handler: KeypressHandler) => void;
}
export declare function useKeypressContext(): KeypressContextValue;
export declare function KeypressProvider({ children, kittyProtocolEnabled, config, debugKeystrokeLogging, }: {
    children: React.ReactNode;
    kittyProtocolEnabled: boolean;
    config?: Config;
    debugKeystrokeLogging?: boolean;
}): import("react/jsx-runtime").JSX.Element;
export {};
