/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Locale;
import java.util.Set;

class GenericShorthandBuilder
extends ShorthandBuilder {
    final String initialvalue;

    GenericShorthandBuilder(String string, BaseCSSStyleDeclaration baseCSSStyleDeclaration, String string2) {
        super(string, baseCSSStyleDeclaration);
        this.initialvalue = string2;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        String[] stringArray;
        if (this.hasPropertiesToExclude(set)) {
            return 1;
        }
        stringBuilder.append(this.getShorthandName()).append(':');
        byte by = this.checkValuesForInherit(set);
        if (by == 1) {
            stringBuilder.append("inherit");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        if (this.isInheritedProperty()) {
            by = this.checkValuesForType(CSSValue.Type.UNSET, set);
            if (by == 1) {
                stringBuilder.append("unset");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            if (by == 2) {
                return 1;
            }
        }
        if ((by = this.checkValuesForType(CSSValue.Type.REVERT, set)) == 1) {
            stringBuilder.append("revert");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, set) != 0) {
            return 1;
        }
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
        DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
        boolean bl2 = false;
        for (String string : stringArray = this.getLonghandProperties()) {
            if (!set.contains(string) || this.isResetProperty(string)) continue;
            StyleValue styleValue = this.getCSSValue(string);
            if (styleValue.getCssValueType() == CSSValue.CssType.LIST && ((ValueList)styleValue).isCommaSeparated() || this.invalidValueClash(set, string, styleValue)) {
                return 1;
            }
            bl2 = this.appendValueText(bufferSimpleWriter, declarationFormattingContext, string, bl2);
        }
        if (!bl2) {
            stringBuilder.append(this.initialvalue);
        }
        this.appendPriority(stringBuilder, bl);
        this.endShorthandSerialization(bufferSimpleWriter, declarationFormattingContext, bl);
        return 0;
    }

    boolean isResetProperty(String string) {
        return false;
    }

    boolean invalidValueClash(Set<String> set, String string, StyleValue styleValue) {
        if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            int n = valueList.getLength();
            for (int i = 0; i < n; ++i) {
                if (!this.invalidValueClash(set, string, valueList.item(i))) continue;
                return true;
            }
        } else {
            if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                return this.invalidPrimitiveValueClash(set, string, (TypedValue)styleValue);
            }
            if (styleValue.getCssValueType() != CSSValue.CssType.KEYWORD) {
                return true;
            }
        }
        return false;
    }

    boolean invalidPrimitiveValueClash(Set<String> set, String string, TypedValue typedValue) {
        if (typedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            return this.invalidIdentValueClash(set, string, typedValue);
        }
        return false;
    }

    boolean invalidIdentValueClash(Set<String> set, String string, TypedValue typedValue) {
        String string2 = typedValue.getStringValue().toLowerCase(Locale.ROOT);
        if (!GenericShorthandBuilder.getShorthandDatabase().isIdentifierValue(string, string2) && !string2.equals(this.initialvalue)) {
            if (this.identifierValuesAreKnown(string) || GenericShorthandBuilder.containsControl(string2)) {
                return true;
            }
            for (String string3 : set) {
                if (!GenericShorthandBuilder.getShorthandDatabase().hasKnownIdentifierValues(string3) || !GenericShorthandBuilder.getShorthandDatabase().isIdentifierValue(string3, string2)) continue;
                return true;
            }
        }
        return false;
    }

    boolean identifierValuesAreKnown(String string) {
        return GenericShorthandBuilder.getShorthandDatabase().hasKnownIdentifierValues(string);
    }

    boolean appendValueText(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, String string, boolean bl) {
        return this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, string, bl);
    }

    @Override
    boolean isInheritedProperty() {
        String string = this.getLonghandProperties()[0];
        return PropertyDatabase.getInstance().isInherited(string);
    }

    void endShorthandSerialization(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, boolean bl) {
    }
}

