/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.WeakHashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public class NativeWeakMap
extends IdScriptableObject {
    private static final long serialVersionUID = 8670434366883930453L;
    private static final Object MAP_TAG = "WeakMap";
    private boolean instanceOfWeakMap = false;
    private transient WeakHashMap<Scriptable, Object> map = new WeakHashMap();
    private static final Object NULL_VALUE = new Object();
    private static final int Id_constructor = 1;
    private static final int Id_delete = 2;
    private static final int Id_get = 3;
    private static final int Id_has = 4;
    private static final int Id_set = 5;
    private static final int SymbolId_toStringTag = 6;
    private static final int MAX_PROTOTYPE_ID = 6;

    static void init(Scriptable scriptable, boolean bl) {
        NativeWeakMap nativeWeakMap = new NativeWeakMap();
        nativeWeakMap.exportAsJSClass(6, scriptable, bl);
    }

    @Override
    public String getClassName() {
        return "WeakMap";
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(MAP_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 == null) {
                    NativeWeakMap nativeWeakMap = new NativeWeakMap();
                    nativeWeakMap.instanceOfWeakMap = true;
                    if (objectArray.length > 0) {
                        NativeMap.loadFromIterable(context, scriptable, nativeWeakMap, NativeMap.key(objectArray));
                    }
                    return nativeWeakMap;
                }
                throw ScriptRuntime.typeErrorById("msg.no.new", "WeakMap");
            }
            case 2: {
                return NativeWeakMap.realThis(scriptable2, idFunctionObject).js_delete(NativeMap.key(objectArray));
            }
            case 3: {
                return NativeWeakMap.realThis(scriptable2, idFunctionObject).js_get(NativeMap.key(objectArray));
            }
            case 4: {
                return NativeWeakMap.realThis(scriptable2, idFunctionObject).js_has(NativeMap.key(objectArray));
            }
            case 5: {
                return NativeWeakMap.realThis(scriptable2, idFunctionObject).js_set(NativeMap.key(objectArray), objectArray.length > 1 ? objectArray[1] : Undefined.instance);
            }
        }
        throw new IllegalArgumentException("WeakMap.prototype has no method: " + idFunctionObject.getFunctionName());
    }

    private Object js_delete(Object object) {
        if (!ScriptRuntime.isObject(object)) {
            return Boolean.FALSE;
        }
        return this.map.remove(object) != null;
    }

    private Object js_get(Object object) {
        if (!ScriptRuntime.isObject(object)) {
            return Undefined.instance;
        }
        Object object2 = this.map.get(object);
        if (object2 == null) {
            return Undefined.instance;
        }
        if (object2 == NULL_VALUE) {
            return null;
        }
        return object2;
    }

    private Object js_has(Object object) {
        if (!ScriptRuntime.isObject(object)) {
            return Boolean.FALSE;
        }
        return this.map.containsKey(object);
    }

    private Object js_set(Object object, Object object2) {
        if (!ScriptRuntime.isObject(object)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(object));
        }
        Object object3 = object2 == null ? NULL_VALUE : object2;
        this.map.put((Scriptable)object, object3);
        return this;
    }

    private static NativeWeakMap realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        NativeWeakMap nativeWeakMap = NativeWeakMap.ensureType(scriptable, NativeWeakMap.class, idFunctionObject);
        if (!nativeWeakMap.instanceOfWeakMap) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", idFunctionObject.getFunctionName());
        }
        return nativeWeakMap;
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n == 6) {
            this.initPrototypeValue(6, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
            return;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                n2 = 0;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "delete";
                break;
            }
            case 3: {
                n2 = 1;
                string = "get";
                break;
            }
            case 4: {
                n2 = 1;
                string = "has";
                break;
            }
            case 5: {
                n2 = 2;
                string = "set";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(MAP_TAG, n, string, string2, n2);
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 6;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "delete": {
                n = 2;
                break;
            }
            case "get": {
                n = 3;
                break;
            }
            case "has": {
                n = 4;
                break;
            }
            case "set": {
                n = 5;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.map = new WeakHashMap();
    }
}

