/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.Node;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.Scope;

public class Symbol {
    private int declType;
    private int index = -1;
    private String name;
    private Node node;
    private Scope containingTable;

    public Symbol() {
    }

    public Symbol(int n, String string) {
        this.setName(string);
        this.setDeclType(n);
    }

    public int getDeclType() {
        return this.declType;
    }

    public void setDeclType(int n) {
        if (n != 113 && n != 90 && n != 126 && n != 157 && n != 158) {
            throw new IllegalArgumentException("Invalid declType: " + n);
        }
        this.declType = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Node getNode() {
        return this.node;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Scope getContainingTable() {
        return this.containingTable;
    }

    public void setContainingTable(Scope scope) {
        this.containingTable = scope;
    }

    public String getDeclTypeName() {
        return Token.typeToName(this.declType);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Symbol (");
        stringBuilder.append(this.getDeclTypeName());
        stringBuilder.append(") name=");
        stringBuilder.append(this.name);
        if (this.node != null) {
            stringBuilder.append(" line=");
            stringBuilder.append(this.node.getLineno());
        }
        return stringBuilder.toString();
    }
}

