/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.SecurityProxy;

public class JavaPolicySecurity
extends SecurityProxy {
    @Override
    public Class<?> getStaticSecurityDomainClassInternal() {
        return ProtectionDomain.class;
    }

    public JavaPolicySecurity() {
        new CodeSource(null, (Certificate[])null);
    }

    @Override
    protected void callProcessFileSecure(final Context context, final Scriptable scriptable, final String string) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                URL uRL = JavaPolicySecurity.this.getUrlObj(string);
                ProtectionDomain protectionDomain = JavaPolicySecurity.this.getUrlDomain(uRL);
                try {
                    Main.processFileSecure(context, scriptable, uRL.toExternalForm(), protectionDomain);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                return null;
            }
        });
    }

    private URL getUrlObj(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = System.getProperty("user.dir");
            string2 = string2.replace('\\', '/');
            if (!string2.endsWith("/")) {
                string2 = string2 + '/';
            }
            try {
                URL uRL2 = new URL("file:" + string2);
                uRL = new URL(uRL2, string);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new RuntimeException("Can not construct file URL for '" + string + "':" + malformedURLException2.getMessage());
            }
        }
        return uRL;
    }

    private ProtectionDomain getUrlDomain(URL uRL) {
        CodeSource codeSource = new CodeSource(uRL, (Certificate[])null);
        PermissionCollection permissionCollection = Policy.getPolicy().getPermissions(codeSource);
        return new ProtectionDomain(codeSource, permissionCollection);
    }

    @Override
    public GeneratedClassLoader createClassLoader(final ClassLoader classLoader, Object object) {
        final ProtectionDomain protectionDomain = (ProtectionDomain)object;
        return AccessController.doPrivileged(new PrivilegedAction<Loader>(){

            @Override
            public Loader run() {
                return new Loader(classLoader, protectionDomain);
            }
        });
    }

    @Override
    public Object getDynamicSecurityDomain(Object object) {
        ProtectionDomain protectionDomain = (ProtectionDomain)object;
        return this.getDynamicDomain(protectionDomain);
    }

    private ProtectionDomain getDynamicDomain(ProtectionDomain protectionDomain) {
        ContextPermissions contextPermissions = new ContextPermissions(protectionDomain);
        ProtectionDomain protectionDomain2 = new ProtectionDomain(null, contextPermissions);
        return protectionDomain2;
    }

    @Override
    public Object callWithDomain(Object object, final Context context, final Callable callable, final Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
        ProtectionDomain protectionDomain = (ProtectionDomain)object;
        ProtectionDomain protectionDomain2 = this.getDynamicDomain(protectionDomain);
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{protectionDomain2};
        AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
        PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        };
        return AccessController.doPrivileged(privilegedAction, accessControlContext);
    }

    private static class ContextPermissions
    extends PermissionCollection {
        static final long serialVersionUID = -1721494496320750721L;
        AccessControlContext _context = AccessController.getContext();
        PermissionCollection _statisPermissions;

        ContextPermissions(ProtectionDomain protectionDomain) {
            if (protectionDomain != null) {
                this._statisPermissions = protectionDomain.getPermissions();
            }
            this.setReadOnly();
        }

        @Override
        public void add(Permission permission) {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        @Override
        public boolean implies(Permission permission) {
            if (this._statisPermissions != null && !this._statisPermissions.implies(permission)) {
                return false;
            }
            try {
                this._context.checkPermission(permission);
                return true;
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }

        @Override
        public Enumeration<Permission> elements() {
            return new Enumeration<Permission>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public Permission nextElement() {
                    return null;
                }
            };
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
            stringBuilder.append(" (context=");
            stringBuilder.append(this._context);
            stringBuilder.append(", static_permitions=");
            stringBuilder.append(this._statisPermissions);
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    private static class Loader
    extends ClassLoader
    implements GeneratedClassLoader {
        private ProtectionDomain domain;

        Loader(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            super(classLoader != null ? classLoader : Loader.getSystemClassLoader());
            this.domain = protectionDomain;
        }

        @Override
        public Class<?> defineClass(String string, byte[] byArray) {
            return super.defineClass(string, byArray, 0, byArray.length, this.domain);
        }

        @Override
        public void linkClass(Class<?> clazz) {
            this.resolveClass(clazz);
        }
    }
}

