/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.FilterPrimitiveBridge;
import io.sf.carte.echosvg.bridge.PaintServer;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.FilterAlphaRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.FilterColorInterpolation;
import io.sf.carte.echosvg.ext.awt.image.renderable.FloodRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.PadRable8Bit;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.filter.BackgroundRable8Bit;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class AbstractSVGFilterPrimitiveElementBridge
extends AnimatableGenericSVGBridge
implements FilterPrimitiveBridge,
ErrorConstants {
    static final Rectangle2D INFINITE_FILTER_REGION = new Rectangle2D.Float(-1.7014117E38f, -1.7014117E38f, Float.MAX_VALUE, Float.MAX_VALUE);

    protected AbstractSVGFilterPrimitiveElementBridge() {
    }

    protected static Filter getIn(Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Map<String, Filter> map, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "in");
        if (string.length() == 0) {
            return filter;
        }
        return AbstractSVGFilterPrimitiveElementBridge.getFilterSource(element, string, element2, graphicsNode, map, bridgeContext);
    }

    protected static Filter getIn2(Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Map<String, Filter> map, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "in2");
        if (string.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"in2"});
        }
        return AbstractSVGFilterPrimitiveElementBridge.getFilterSource(element, string, element2, graphicsNode, map, bridgeContext);
    }

    protected static void updateFilterMap(Element element, Filter filter, Map<String, Filter> map) {
        String string = element.getAttributeNS(null, "result");
        if (string.length() != 0 && string.trim().length() != 0) {
            map.put(string, filter);
        }
    }

    protected static void handleColorInterpolationFilters(Filter filter, Element element) {
        if (filter instanceof FilterColorInterpolation) {
            boolean bl = CSSUtilities.convertColorInterpolationFilters(element);
            ((FilterColorInterpolation)filter).setColorSpaceLinear(bl);
        }
    }

    static Filter getFilterSource(Element element, String string, Element element2, GraphicsNode graphicsNode, Map<String, Filter> map, BridgeContext bridgeContext) {
        Filter filter = map.get("SourceGraphic");
        Rectangle2D rectangle2D = filter.getBounds2D();
        int n = string.length();
        Filter filter2 = null;
        switch (n) {
            case 13: {
                if (!"SourceGraphic".equals(string)) break;
                filter2 = filter;
                break;
            }
            case 11: {
                if (string.charAt(1) == "SourceAlpha".charAt(1)) {
                    if (!"SourceAlpha".equals(string)) break;
                    filter2 = filter;
                    filter2 = new FilterAlphaRable(filter2);
                    break;
                }
                if (!"StrokePaint".equals(string)) break;
                Paint paint = PaintServer.convertStrokePaint(element2, graphicsNode, bridgeContext);
                filter2 = new FloodRable8Bit(rectangle2D, paint);
                break;
            }
            case 15: {
                if (string.charAt(10) == "BackgroundImage".charAt(10)) {
                    if (!"BackgroundImage".equals(string)) break;
                    filter2 = new BackgroundRable8Bit(graphicsNode);
                    filter2 = new PadRable8Bit(filter2, rectangle2D, PadMode.ZERO_PAD);
                    break;
                }
                if (!"BackgroundAlpha".equals(string)) break;
                filter2 = new BackgroundRable8Bit(graphicsNode);
                filter2 = new FilterAlphaRable(filter2);
                filter2 = new PadRable8Bit(filter2, rectangle2D, PadMode.ZERO_PAD);
                break;
            }
            case 9: {
                if (!"FillPaint".equals(string)) break;
                Paint paint = PaintServer.convertFillPaint(element2, graphicsNode, bridgeContext);
                if (paint == null) {
                    paint = new Color(0, 0, 0, 0);
                }
                filter2 = new FloodRable8Bit(rectangle2D, paint);
            }
        }
        if (filter2 == null) {
            filter2 = map.get(string);
        }
        return filter2;
    }

    protected static int convertInteger(Element element, String string, int n, BridgeContext bridgeContext) {
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return n;
        }
        try {
            return SVGUtilities.convertSVGInteger(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{string, string2});
        }
    }

    protected static float convertNumber(Element element, String string, float f, BridgeContext bridgeContext) {
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return f;
        }
        try {
            return SVGUtilities.convertSVGNumber(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{string, string2, numberFormatException});
        }
    }
}

