/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.AbstractCounterValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

class CounterValue
extends AbstractCounterValue {
    private static final long serialVersionUID = 1L;

    public CounterValue() {
        super(CSSValue.Type.COUNTER);
    }

    protected CounterValue(CounterValue counterValue) {
        super(counterValue);
    }

    @Override
    public CounterValue clone() {
        return new CounterValue(this);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Category category = cSSValueSyntax.getCategory();
        if (category == CSSValueSyntax.Category.universal || category == CSSValueSyntax.Category.counter) {
            return CSSValueSyntax.Match.TRUE;
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("counter(").append(this.getName());
        PrimitiveValue primitiveValue = this.getCounterStyle();
        if (primitiveValue != null && !"decimal".equalsIgnoreCase(string = primitiveValue.getCssText())) {
            stringBuilder.append(',').append(' ').append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("counter(").append(this.getName());
        PrimitiveValue primitiveValue = this.getCounterStyle();
        if (primitiveValue != null && !"decimal".equalsIgnoreCase(string2 = primitiveValue.getCssText())) {
            stringBuilder.append(',').append(string2);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"counter(");
        simpleWriter.write((CharSequence)this.getName());
        PrimitiveValue primitiveValue = this.getCounterStyle();
        if (primitiveValue != null && !CounterValue.isCSSIdentifier(primitiveValue, "decimal")) {
            simpleWriter.write((CharSequence)", ");
            primitiveValue.writeCssText(simpleWriter);
        }
        simpleWriter.write(')');
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(CounterValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                this.checkProxyValue(lexicalUnit2);
                throw new DOMException(17, "Invalid counter() name.");
            }
            CounterValue.this.setName(lexicalUnit2.getStringValue());
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 != null) {
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    LexicalUnit.LexicalType lexicalType;
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                        this.badSyntax(lexicalUnit);
                    }
                    if ((lexicalType = lexicalUnit2.getLexicalUnitType()) == LexicalUnit.LexicalType.IDENT || lexicalType == LexicalUnit.LexicalType.FUNCTION && "symbols".equalsIgnoreCase(lexicalUnit2.getFunctionName())) {
                        ValueFactory valueFactory = new ValueFactory();
                        PrimitiveValue.LexicalSetter lexicalSetter = valueFactory.createCSSPrimitiveValueItem(lexicalUnit2, false, false);
                        CounterValue.this.setCounterStyle(lexicalSetter.getCSSValue());
                        if (lexicalSetter.getNextLexicalUnit() != null) {
                            this.badSyntax(lexicalUnit);
                        }
                    } else {
                        this.checkProxyValue(lexicalUnit2);
                        this.badSyntax(lexicalUnit);
                    }
                } else {
                    this.checkProxyValue(lexicalUnit2);
                    this.badSyntax(lexicalUnit);
                }
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void badSyntax(LexicalUnit lexicalUnit) {
            throw new DOMException(12, "Bad counter syntax: " + lexicalUnit.toString());
        }
    }
}

