/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.ast.ErrorCollector;

public class CompilerEnvirons {
    private ErrorReporter errorReporter = DefaultErrorReporter.instance;
    private int languageVersion = 0;
    private boolean generateDebugInfo = true;
    private boolean reservedKeywordAsIdentifier = true;
    private boolean allowMemberExprAsFunctionName = false;
    private boolean xmlAvailable = true;
    private int optimizationLevel = 0;
    private boolean generatingSource = true;
    private boolean strictMode = false;
    private boolean warningAsError = false;
    private boolean generateObserverCount = false;
    private boolean recordingComments;
    private boolean recordingLocalJsDocComments;
    private boolean recoverFromErrors;
    private boolean warnTrailingComma;
    private boolean ideMode;
    private boolean allowSharpComments = false;
    Set<String> activationNames;

    public void initFromContext(Context context) {
        this.setErrorReporter(context.getErrorReporter());
        this.languageVersion = context.getLanguageVersion();
        this.generateDebugInfo = !context.isGeneratingDebugChanged() || context.isGeneratingDebug();
        this.reservedKeywordAsIdentifier = context.hasFeature(3);
        this.allowMemberExprAsFunctionName = context.hasFeature(2);
        this.strictMode = context.hasFeature(11);
        this.warningAsError = context.hasFeature(12);
        this.xmlAvailable = context.hasFeature(6);
        this.optimizationLevel = context.getOptimizationLevel();
        this.generatingSource = context.isGeneratingSource();
        this.activationNames = context.activationNames;
        this.generateObserverCount = context.generateObserverCount;
    }

    public final ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }

    public final int getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(int n) {
        Context.checkLanguageVersion(n);
        this.languageVersion = n;
    }

    public final boolean isGenerateDebugInfo() {
        return this.generateDebugInfo;
    }

    public void setGenerateDebugInfo(boolean bl) {
        this.generateDebugInfo = bl;
    }

    public final boolean isReservedKeywordAsIdentifier() {
        return this.reservedKeywordAsIdentifier;
    }

    public void setReservedKeywordAsIdentifier(boolean bl) {
        this.reservedKeywordAsIdentifier = bl;
    }

    public final boolean isAllowMemberExprAsFunctionName() {
        return this.allowMemberExprAsFunctionName;
    }

    public void setAllowMemberExprAsFunctionName(boolean bl) {
        this.allowMemberExprAsFunctionName = bl;
    }

    public final boolean isXmlAvailable() {
        return this.xmlAvailable;
    }

    public void setXmlAvailable(boolean bl) {
        this.xmlAvailable = bl;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int n) {
        Context.checkOptimizationLevel(n);
        this.optimizationLevel = n;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public boolean getWarnTrailingComma() {
        return this.warnTrailingComma;
    }

    public void setWarnTrailingComma(boolean bl) {
        this.warnTrailingComma = bl;
    }

    public final boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean bl) {
        this.strictMode = bl;
    }

    public final boolean reportWarningAsError() {
        return this.warningAsError;
    }

    public void setGeneratingSource(boolean bl) {
        this.generatingSource = bl;
    }

    public boolean isGenerateObserverCount() {
        return this.generateObserverCount;
    }

    public void setGenerateObserverCount(boolean bl) {
        this.generateObserverCount = bl;
    }

    public boolean isRecordingComments() {
        return this.recordingComments;
    }

    public void setRecordingComments(boolean bl) {
        this.recordingComments = bl;
    }

    public boolean isRecordingLocalJsDocComments() {
        return this.recordingLocalJsDocComments;
    }

    public void setRecordingLocalJsDocComments(boolean bl) {
        this.recordingLocalJsDocComments = bl;
    }

    public void setRecoverFromErrors(boolean bl) {
        this.recoverFromErrors = bl;
    }

    public boolean recoverFromErrors() {
        return this.recoverFromErrors;
    }

    public void setIdeMode(boolean bl) {
        this.ideMode = bl;
    }

    public boolean isIdeMode() {
        return this.ideMode;
    }

    public Set<String> getActivationNames() {
        return this.activationNames;
    }

    public void setActivationNames(Set<String> set) {
        this.activationNames = set;
    }

    public void setAllowSharpComments(boolean bl) {
        this.allowSharpComments = bl;
    }

    public boolean getAllowSharpComments() {
        return this.allowSharpComments;
    }

    public static CompilerEnvirons ideEnvirons() {
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.setRecoverFromErrors(true);
        compilerEnvirons.setRecordingComments(true);
        compilerEnvirons.setStrictMode(true);
        compilerEnvirons.setWarnTrailingComma(true);
        compilerEnvirons.setLanguageVersion(170);
        compilerEnvirons.setReservedKeywordAsIdentifier(true);
        compilerEnvirons.setIdeMode(true);
        compilerEnvirons.setErrorReporter(new ErrorCollector());
        return compilerEnvirons;
    }
}

