/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedPathData;
import io.sf.carte.echosvg.anim.dom.SVGOMPathElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGAnimatedPathDataSupport;
import io.sf.carte.echosvg.dom.svg.SVGPathContext;
import io.sf.carte.echosvg.ext.awt.geom.PathLength;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.parser.AWTPathProducer;
import io.sf.carte.echosvg.parser.PathHandler;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPathSegList;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge
implements SVGPathContext {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();
    protected Shape pathLengthShape;
    protected PathLength pathLength;

    @Override
    public String getLocalName() {
        return "path";
    }

    @Override
    public Bridge getInstance() {
        return new SVGPathElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        SVGOMPathElement pe = (SVGOMPathElement)e;
        AWTPathProducer app = new AWTPathProducer();
        SVGOMAnimatedPathData _d = pe.getAnimatedPathData();
        short check = _d.check();
        if (check >= 0) {
            if (check == 0) {
                shapeNode.setShape(EMPTY_SHAPE);
                shapeNode.setVisible(false);
                return;
            }
            LiveAttributeException lex = new LiveAttributeException(e, e.getLocalName(), check, _d.getPathSegList().toString());
            BridgeException be = new BridgeException(ctx, lex);
            SVGPathElementBridge.displayErrorOrThrow(ctx, be);
        }
        if (_d.getPathSegList().getNumberOfItems() == 0) {
            shapeNode.setShape(EMPTY_SHAPE);
            shapeNode.setVisible(false);
            return;
        }
        SVGPathSegList p = _d.getAnimatedPathSegList();
        try {
            app.setWindingRule(CSSUtilities.convertFillRule(e));
            shapeNode.setVisible(CSSUtilities.convertVisibility(e));
            SVGAnimatedPathDataSupport.handlePathSegList((SVGPathSegList)p, (PathHandler)app);
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
        finally {
            shapeNode.setShape(app.getShape());
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        if (alav.getNamespaceURI() == null && alav.getLocalName().equals("d")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleAnimatedAttributeChanged(alav);
        }
    }

    @Override
    protected void handleCSSPropertyChanged(int property) {
        switch (property) {
            case 16: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property);
            }
        }
    }

    protected PathLength getPathLengthObj() {
        Shape s = ((ShapeNode)this.node).getShape();
        if (this.pathLengthShape != s) {
            this.pathLength = new PathLength(s);
            this.pathLengthShape = s;
        }
        return this.pathLength;
    }

    public float getTotalLength() {
        PathLength pl = this.getPathLengthObj();
        return pl.lengthOfPath();
    }

    public Point2D getPointAtLength(float distance) {
        PathLength pl = this.getPathLengthObj();
        return pl.pointAtLength(distance);
    }

    public int getPathSegAtLength(float distance) {
        PathLength pl = this.getPathLengthObj();
        return pl.segmentAtLength(distance);
    }
}

