#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-5RYpWlMaGNlJbjNA7DjJx8
key:                  gitit-0.15.1.2-5RYpWlMaGNlJbjNA7DjJx8
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  be6b1b2f4d3f9225c2911daa24b4222b
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-5RYpWlMaGNlJbjNA7DjJx8
depends:
    HStringTemplate-0.8.8-4et4tTfVIxHC5dO8Q0K9ks
    HTTP-4000.4.1-AlxJrh8RSQCFQJop57pPCp
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-2383fjET7FWJSHJW4VQuW base-4.17.2.1
    base64-bytestring-1.2.1.0-G53UOvB3pKB2mwL6yBWItW
    blaze-html-0.9.2.0-JcISFZyc75x1w6gURdo9IX bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-IqIgpL8dz3g7bhM7IMbYVG
    feed-1.3.2.1-J6c20Wv1ilL7Br6P7bMtH0 filepath-1.4.2.2
    filestore-0.6.5.1-Exfs31Xq84L2GKyUgzdC1p ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-CawqisuCjWW8z7DEqXi3Se
    hoauth2-2.10.0-3Ex3UGqM9J63ttWeemVoA4
    hslogger-1.3.1.2-GWyfkrdf1679z6CueDHYd8
    http-client-tls-0.3.6.4-GPXWf86JjcLLjWRBBwYJzj
    http-conduit-2.3.9.1-ELIzfrfN67xHYB6OkkMeVz
    json-0.10-FDPGsXzpLW1HTCsmwVxFpW mtl-2.2.2
    network-3.1.4.0-AsoxBmMP1pfJSzv0IgKvnl
    network-bsd-2.8.1.0-2a2Z1NIvUQTJSw1kboo6xN
    network-uri-2.6.4.2-JT5mjmfFxkg6DEC2jAgmZ6
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-4IWzoCJX3tD1QXXzKkPXqs
    pandoc-types-1.23.1-8ey3S1zLWYZ6MpBkNqPsfN parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-9I8x2ZdyyN6LUBxcAUCXuW
    recaptcha-0.1.0.4-FrnR1oMp0xZ9SMjkDXIKda
    safe-0.3.21-BDeWrSgar9b2azUh8fJqoI
    skylighting-0.14.1.2-KgtDOiiZ3keKwtaqkznPkN
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-3MUyG3p3euQLeyQ65NE0AP
    tagsoup-0.14.8-Eeox7yOdvxKD5vjT7TqZ3o
    temporary-1.3-PDEW3NiP5RF98HJ5wXFiq text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-4QvlqNxx7ULL7F6pNTFPuN
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-BNeEWSu9Bm82ai0kQPqNg1 xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-LMnRoAZmYtt6EcsvzwbEtr
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-LNJ0og4RjCXK0R4wBbg36l
    zlib-0.7.0.0-Cp5NrmIK6SOKeEUrlvcsoq

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

