#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-CxtCzlNhP0aLScg7hmDaLe
key:                  gitit-0.15.1.2-CxtCzlNhP0aLScg7hmDaLe
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  587b1f3029f1042a6b7a2c6a8b7e9c69
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-CxtCzlNhP0aLScg7hmDaLe
depends:
    HStringTemplate-0.8.8-866rHLojS4ABn2QG07HFcQ
    HTTP-4000.4.1-8FfNLm2ZwrO6ImYKxGq8XQ
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    blaze-html-0.9.2.0-4nZEIuSQm5uJHuPTchkOVN bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-Hr1m5B6ouYu9FCvBdWSuP1
    feed-1.3.2.1-DsX6r5x6zoY4b0TT0hup5j filepath-1.4.2.2
    filestore-0.6.5.1-GtRmc0OZ9og8AZzFWrOOzK ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-65IkshBnA825ab9UPb18uG
    hoauth2-2.11.0-GqWdfnG6TJtHyhuqeJu0tm
    hslogger-1.3.2.0-IaqInjquV2Q3QNYRzw3USP
    http-client-tls-0.3.6.4-2UCAQd74svUAKy6rR9fBGJ
    http-conduit-2.3.9.1-CHv81o5pwtXBQf5qQhZ9fb
    json-0.10-DUKq0d4SVZ35xAQzfOgN2U mtl-2.2.2
    network-3.1.4.0-18zdZgmnDKE1J4Hp557YCB
    network-bsd-2.8.1.0-8xL3mumE6mO7EM42k7pSDh
    network-uri-2.6.4.2-95fWnkSq4twGVejB9ewxKe
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-Fc24JwC5AA9BmFJh2Ka7ZW
    pandoc-types-1.23.1-3CNRolnghLrGrKUxTKh94B parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-7z4mPLTBPidE9rbVioKqnW
    recaptcha-0.1.0.4-9fN14jPSxAf6Eyuat6ULA9
    safe-0.3.21-8UNW4gIoNRmKgGFufdPOla
    skylighting-0.14.2-5SEby1WuwX14Wl989wMJEU
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV syb-0.7.3-BQUcn35RmaZ45KQPDd3rN
    tagsoup-0.14.8-GVtsPXOGcnkEcwEFDhng0m
    temporary-1.3-3NOXbZBNm6jw25HF8dLG0 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-KGyUXgIdlBuKVrH6uGgadB
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-L4oZK2xz30658Gk2kqaZh xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-KElFGaHf96E1O2VwBID5qq
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-8V04J7OYhSiC0SnHoGZH0D
    zlib-0.7.0.0-3VB0JcHQ0YdEzhd22eQVSI

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

