#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-h6IPgSijcXCgeYorAzlwu
key:                  gitit-0.15.1.2-h6IPgSijcXCgeYorAzlwu
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  6fdbb2bdd022748ae80731255d44228f
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-h6IPgSijcXCgeYorAzlwu
depends:
    HStringTemplate-0.8.8-3CkaeU0kR8iQXtlFD47rL
    HTTP-4000.4.1-6tuFZGlHu3bAsxRVsLe69b
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp base-4.17.2.1
    base64-bytestring-1.2.1.0-9yKKMU9vx4T3mbm91B7Hi9
    blaze-html-0.9.2.0-9WgJSHLeSKZHZJZeAqHdGu bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-A3ndqbAqVF155ni4rIvSx8
    feed-1.3.2.1-7Fl3ppLKIUT1BJqyHKsVyE filepath-1.4.2.2
    filestore-0.6.5.1-9nkc68cV7Up3aGYdHCTxI6 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-LFrFdun4imh66wfZGbmfkG
    hoauth2-2.11.0-JrMUAPuFX1V7owUzFkMsIw
    hslogger-1.3.2.0-JYdPvNkqaDsIAYgW8Yirac
    http-client-tls-0.3.6.4-8TCMitZJevE8PRVlviJUoX
    http-conduit-2.3.9.1-7Oc6YAxQlM34vEzwEGx8Ed
    json-0.10-12GqGJxyea7KvEBUFlezs0 mtl-2.2.2
    network-3.1.4.0-L9DLhdoHw8O9GdA4IbhXs2
    network-bsd-2.8.1.0-ATrDsz44IRK3iixmeXG8Wy
    network-uri-2.6.4.2-E8aEaRQxCxy3qJUPBltH5o
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-2au3Pfn6jV3DuOY321pBev
    pandoc-types-1.23.1-CzLgG4t3MpMFqUCbP8gljy parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-BJci0ZIHWY7JJvOpU5NHzK
    recaptcha-0.1.0.4-LBOa6dGdB1r8Y7dzxFloAm
    safe-0.3.21-29OHNU5kqwB6czdAzMhG9H
    skylighting-0.14.2-JVuDrARiw4kHS9sLy1RHRJ
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV syb-0.7.3-2eqzyzFtMWK8QFmS6IKpDr
    tagsoup-0.14.8-4BHip7yR9rS3FOzjERVhSn
    temporary-1.3-BUD9rQS749x5bLVTfwQ4gp text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-2MNtdb5vfB5pXL0yuDHRK
    url-2.1.3-57xbRAOVZuxB8io07HhO9w
    utf8-string-1.0.2-JoSH3X8qo5Q4jcipebjMdu
    uuid-1.3.16-Jc2WSMIN71EG9lK7bB1JO4 xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-WdiHh6eI6cLQXQ9Zt6bLQ
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-KkJXWzdQIRO27m8WrIGJr3
    zlib-0.7.0.0-JYiwRH5KGQWE9ztCWge5SX

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

