#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-FFa9MsntucO3ItfPYQ0ylj
key:                  gitit-0.15.1.2-FFa9MsntucO3ItfPYQ0ylj
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  3e345305acbba6bf0386300b922225c4
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-FFa9MsntucO3ItfPYQ0ylj
depends:
    HStringTemplate-0.8.8-3E4WUbwkXruyX0tbeeExy
    HTTP-4000.4.1-JEPFWMqLalC6Rc28TYbaSb
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-U8Qicry0zF1f9E1tHxOto base-4.17.2.1
    base64-bytestring-1.2.1.0-KTcFt1JBtqE6XrF8UIUkhn
    blaze-html-0.9.2.0-148ZoU8BzetFm1jSAQ9JQP bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-JSS9jKAf5dk4jlDQ6VnbYV
    feed-1.3.2.1-7qogBgdB7AHHDmYTHiJYlv filepath-1.4.2.2
    filestore-0.6.5.1-JplAnMPUrH57Ht6s8Bn8Xk ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-EqIcCKtJakf9V5qYJ7fRJN
    hoauth2-2.12.0-CSau0WraYlZEpsN8MYDlyT
    hslogger-1.3.2.0-Fce3xh4A72q1quRymDtrYj
    http-client-tls-0.3.6.4-CWf1zUvMsiN34DRbq0lWlt
    http-conduit-2.3.9.1-J292KvN886fE8zWfrCuHoH
    json-0.10-ICk868n1SXdKM5JpyLWexi mtl-2.2.2
    network-3.1.4.0-7Sk2RzgIXBW6VjX8wm0Jln
    network-bsd-2.8.1.0-7c7TW83KcSc3vLoY2iUePP
    network-uri-2.6.4.2-54CTgPtYe4zITDsYIFYufz
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-8TQBRvkocdh1AEqmpSxbGe
    pandoc-types-1.23.1-8eoy8jCfcxaA66s4z36BXR parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-BS01zQf871D7daMTFQ0UbO
    recaptcha-0.1.0.4-1r3rZ8QOYZOIe8SuA2YVgY
    safe-0.3.21-7gkAsJZkXd98KDZOjDkxED
    skylighting-0.14.2-38XaGCGzSMsDRVeB3o8dgD
    split-0.2.5-LouByQg2aGcJvOHmCntrU0 syb-0.7.3-8GhIGJRTl8LHsLkHRBNJ0N
    tagsoup-0.14.8-IrfRao6Oo591JT7K0a8UA8
    temporary-1.3-21QsMwE9nNF6lJAUe6UOiS text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-6R30sWMxWxm3MFWin3vThM
    url-2.1.3-J007m484ir07DNLbJboS4l
    utf8-string-1.0.2-3k9iW3aOua82FWJzfAeOkO
    uuid-1.3.16-5Kuws66Wo0uLXaOU08Kxd6 xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-4JFbX9v0lEkAT6XJS2OdAN
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-JV6EzDkqbj0KAeHo0NgZx1
    zlib-0.7.0.0-2FkZGfzwBUc7WS0yLbO8rr

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

