#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-Ffxl8RS0VPNKtM1I4CaCMx
key:                  gitit-0.15.1.2-Ffxl8RS0VPNKtM1I4CaCMx
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  7ef5cef067411cbf825bf1ae6cf6d8ea
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-Ffxl8RS0VPNKtM1I4CaCMx
depends:
    HStringTemplate-0.8.8-2AhfT1rCaBk7hr9zd7rVXv
    HTTP-4000.4.1-1FFMZEMNJyrFBpbnP6nXRV
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x base-4.17.2.1
    base64-bytestring-1.2.1.0-BuaE7coGml7AORbY2RxXh2
    blaze-html-0.9.2.0-Hmx0qDwpXdTINSADNpvYjl bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-LJeKt8dWrMCFIXQ2UuieU7
    feed-1.3.2.1-tyF0YEU9zr5AXbmwLhgR3 filepath-1.4.2.2
    filestore-0.6.5.1-kyBjd1qx2Y6iEcuPI9e8A ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-3lLxmtI5dPyHA386iNMXpy
    hoauth2-2.12.0-44ianMMCkkD9Harv3JXN5i
    hslogger-1.3.2.0-CK7xYV7h2X21XtgfKXebie
    http-client-tls-0.3.6.4-3SOG6pMBD126OroBvnbwcp
    http-conduit-2.3.9.1-CPmopMKYDZmGtVTs3jcq5H
    json-0.10-GtmTPpjuynnC3spyvpHoyU mtl-2.2.2
    network-3.1.4.0-7GxbLibXQB6BN49yptQL65
    network-bsd-2.8.1.0-CawTJYvF4Qd3w2PL2cRFrw
    network-uri-2.6.4.2-8swvJWOy75N7pbfI8WzbN
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-AbHMLWKtSToLwDZcGSPXxe
    pandoc-types-1.23.1-DUhFUS3IsFw3WTB1IkGCo2 parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-2Hw42CquWtj55joOjOmzRr
    recaptcha-0.1.0.4-C7vQH6Vw6kEBzcbcUUd5bQ
    safe-0.3.21-6M2s73s6VIBE0aNh1wWxu0
    skylighting-0.14.2-9pIHu5pXF5P78d9cxl76gn
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-Lap6GPARkRXCVbqA2faY6P
    tagsoup-0.14.8-2O7tK5RXOMf1gW8hbRDaNa
    temporary-1.3-IuvCcNxKbgM9H8NbQNEe0S text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-F5YQp8wqjfhFQbYeQB0JGr
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-KPqM7fkGU7HIYn98FEGylF xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-GNUvBVCK4fr2CT0XPKAeY9
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-8iCHVrFhaMDFSOKMTBRAvC
    zlib-0.7.0.0-LNxfZD2yBOpG9CUE6LYKNw

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

