#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-SUGfkgoS6l5tg8WB4x6Qo
key:                  gitit-0.15.1.2-SUGfkgoS6l5tg8WB4x6Qo
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  8aced61597f3d5d05d86ef2601cc4cfa
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-SUGfkgoS6l5tg8WB4x6Qo
depends:
    HStringTemplate-0.8.8-LL4pBImpTMQIsGrNXzkiyF
    HTTP-4000.4.1-5YaMsB4upvr2tr0e2Yr4Lc
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG base-4.17.2.1
    base64-bytestring-1.2.1.0-Lbg95oHQaiJ5WTZ2yAUrqi
    blaze-html-0.9.2.0-D6khwrbejGRHAmMP2tGf4Z bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-2bAcvikUTeoJk6RQapznsw
    feed-1.3.2.1-LGuyHfL6H8A892GQsxBv6 filepath-1.4.2.2
    filestore-0.6.5.1-JAWwH1l57qJ3N2EzzWGbC7 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-G0s9PTO8gIjCigLCCHjgk8
    hoauth2-2.12.0-chhuoEjnm9AwKXWtTGrWE
    hslogger-1.3.2.0-7ShpWSVarF72XV5E1YAyFf
    http-client-tls-0.3.6.4-JnWaCoPi7KZ8DaHdfoFfuf
    http-conduit-2.3.9.1-LgOKwVemqZ11w6ESfzKP2k
    json-0.10-F49pC4egrWZxpn5cFxwPH mtl-2.2.2
    network-3.1.4.0-1eoJcyQnoY08famP5jSKP3
    network-bsd-2.8.1.0-2Idz5QPbLS37FO0cfIbqZZ
    network-uri-2.6.4.2-4dyZiFqUsAXDJ8mS3jtc8B
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-ID8sDjohCsfBsUnoGmknPD
    pandoc-types-1.23.1-ECK1zuYhKfx6GZrEU3gYj1 parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-5Vfv7B7ZdGT6rasffmKWRk
    recaptcha-0.1.0.4-FFRVkg1SPGV9r4ZeK5A0f8
    safe-0.3.21-Kkw0osvJ6bGGcKGjvVXiul
    skylighting-0.14.2-6QjcXU3vodr9TWLTZfLf5W
    split-0.2.5-BTOw45Vh0HiC6vu4BN5MeO syb-0.7.3-DvMMPSfjQylGDaZxljQ4qT
    tagsoup-0.14.8-3GR71DUnZfY7QLjBrHWIvS
    temporary-1.3-1x1h49uB6HQBNYAxVFima5 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-4OVCysUETUWHCpnLfkqdPP
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-Bl9xkMof8FZC1vqH9i1Mdj xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-AWZdAVzcv56HPHiKd5M0SJ
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-D8z0iCoLf8lL5y3YcoFUas
    zlib-0.7.0.0-HXtTAV6BEvXDp6A0D3XVVx

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

