#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-4yo5IXgxwYgF5CMg5wxWCr
key:                  gitit-0.15.1.2-4yo5IXgxwYgF5CMg5wxWCr
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  626d8dc92a6f2d7acb0b7a6d57886d1c
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-4yo5IXgxwYgF5CMg5wxWCr
depends:
    HStringTemplate-0.8.8-Edx4Weaq88UDuDIZ79PuUx
    HTTP-4000.4.1-9S4Jm2S89YUFTulUbOJpae
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-KxhFBZPQYXiG3TO3nhA4Kq base-4.17.2.1
    base64-bytestring-1.2.1.0-GAmjGtWIu9x1vslmHvw2RC
    blaze-html-0.9.2.0-JvWO5U1ZqnhKpJxukwWjlC bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-J3UGL7gY4SV897x01GGQOR
    feed-1.3.2.1-CvfbfZW9HdIEPRVIkJZIh filepath-1.4.2.2
    filestore-0.6.5.1-3onsJKzBgiV9kG5SKmrCdh ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-2xMRVW8QRfwE8CzOcZvcNT
    hoauth2-2.10.0-C4ZfYIaR86t3yRPqi5QSXo
    hslogger-1.3.1.2-7cQcJPLUXZcJJrv1fX8vXI
    http-client-tls-0.3.6.4-IZdKaCSx74jCuO4bihyNpT
    http-conduit-2.3.9.1-GnLewiLzzRNIX5AyUGzEKb
    json-0.10-9GJAf3a6YYQAcKncNwHemp mtl-2.2.2
    network-3.1.4.0-ItBhIFDvz12FCCKfYobIMX
    network-bsd-2.8.1.0-AFh2WFCoL5pHjaTZ9bNOdj
    network-uri-2.6.4.2-Ej2S5J8Z0oCB2cTGXU0OdX
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.1.13-1Emf8YdjsI61as83DyrnTT
    pandoc-types-1.23.1-CuPpRPLL58CDH46kyFIgd0 parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-1epqCSzcS4p5bPWcI4Ab0S
    recaptcha-0.1.0.4-50hxNJ3Vk5F3OZjeTzNn5z
    safe-0.3.21-KJlW7jRgZb73RD220AjTnZ
    skylighting-0.14.1.1-5V7DhVPs9QBALaI9yqyuG2
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-IcpReLUVUA26QHGPwIROQw
    tagsoup-0.14.8-mIOgCAIDqHLr9JpKOf53C
    temporary-1.3-G3JGTlFyfueEWhF9il8L2k text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-G9ubsIPVSgB3Cl9Dv639wC
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-41UNy0cv50pDk0xRPtEdvG xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-GCk8JD4DopvCx25bzLBFm7
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-CvOrbO9x0vjD6h4sDGgBNy
    zlib-0.7.0.0-91jlV9oVAmRK4kV4PuEmaG

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

