#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-LB6rhyS9KcFCYx0ZZk8HDR
key:                  gitit-0.15.1.2-LB6rhyS9KcFCYx0ZZk8HDR
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  a029952679729d0ccedb7d126a729afc
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-LB6rhyS9KcFCYx0ZZk8HDR
depends:
    HStringTemplate-0.8.8-JiM4BkCWnFrATbd8GiGGHp
    HTTP-4000.4.1-9WNcGHxwV7oIgnHvMHz59n
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-DAjCoZEGWBTDXHPn96Kb1j base-4.17.2.1
    base64-bytestring-1.2.1.0-AW9I0WOkr0IYZNZquGJUP
    blaze-html-0.9.2.0-BNiEFLNNUNIEHlooTHUqgE bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-2KDyzxaTG2DBOzy3jQ6TNI
    feed-1.3.2.1-K0jnYz1b54v7zpdpGQGnqD filepath-1.4.2.2
    filestore-0.6.5.1-8q7sMfBKVQl1PYYqPXN5iL ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-I2WWkv0d2dqACUW6M5Fbu1
    hoauth2-2.13.0-9bEhGhy0pH4KGffoIWBFT4
    hslogger-1.3.2.0-1qY224WAgbRIf9sR8BuJiG
    http-client-tls-0.3.6.4-7GHufzv4aig4Ncu6224c0U
    http-conduit-2.3.9.1-9Ct6jgxY5X12F1xXSm7cXD
    json-0.10-GCot9Zh08dF6y4P0CuY2u7 mtl-2.2.2
    network-3.1.4.0-4UbSgXPdAp7DQ7Pftr1aPB
    network-bsd-2.8.1.0-AdZ7q19Usvj4P8px7xbjon
    network-uri-2.6.4.2-IKG3zvKYtEQ3q1XygxFZnU
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.3-G7iScWqk0YK8Ya3ZFxoN21
    pandoc-types-1.23.1-1d1aArVMP6AAFrKBMoUpVD parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-U9X4N4HDf8JDMoZsBnozN
    recaptcha-0.1.0.4-1vqShPEoWnW1ZwRd2GXPHi
    safe-0.3.21-159SecEsuJT5xXa0fzfSU2
    skylighting-0.14.3-E8Nyih2iY3u8xu4s5FAZ3Q
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-8wamvTeFqIS3IMzaHn3GXS
    tagsoup-0.14.8-3Y04trQnJwdG2M3ZI0yPbv
    temporary-1.3-9g1OGPiytt1BO3oUGnOgqn text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-11JNfN5qkseKW4DaKb7el6
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-2nGoE6xvKhhKHUUvbJu5ST xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-bI7sYdsyBCJGOuObLmgOt
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-Ad8b9x0XNdTKwhJXS3ZJLF
    zlib-0.7.0.0-4e7wIz3ojLOAV2Wk6rHCKU

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

