#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-AYOvf43GR9uLME5KIj39DA
key:                  glirc-2.40-AYOvf43GR9uLME5KIj39DA
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  0e5e7bba1994c685a97926107e22f6e1
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-AYOvf43GR9uLME5KIj39DA
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-IExhgagsrLm6UykpDkchmu
    async-2.2.5-KcBItHJGOZL2FAQS48vqcn
    attoparsec-0.14.4-K4GZo37SQ24KyCrR1RSIsH base-4.17.2.1
    base64-bytestring-1.2.1.0-B7TpHxQlQ7x5xHtuAREw0z
    bytestring-0.11.5.3 config-schema-1.3.0.0-73xEInGDZoS6I6zxbq9fXR
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-5UoJSFmM7wLFHM7Aymza1X directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-FTtembRu9iLISDggkC4CHv
    githash-0.1.6.3-JrnmHw2vJBpDkUKJm5Sfoc
    hashable-1.4.4.0-9uPnQxUdwOnCZlD9EiHqMs
    hookup-0.8-HRr84SDLjeoHTAdESg203
    irc-core-2.12-4pZp8JXF6yH2j08mqHW3GJ
    kan-extensions-5.2.7-LNdYlE6tQi0Eig7qOe69L7
    lens-5.3-LWObp7pQkqo7IU7mPMlzlm
    network-3.1.4.0-Clrm8B2IBAjIFHTKmEcInu
    psqueues-0.2.8.1-6v9aScwX4FQIxX0003iiGj
    random-1.2.1.3-FtBkzNFMEVVAWMk0jeYogw
    regex-tdfa-1.3.2.4-AG3wQnDWHjR8IyIVdzEE1S
    semigroupoids-6.0.1-KXp0LYmddte6kFAiCW0XGO
    split-0.2.5-8TDPZlIHK1VKb3LgCQDYep stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-BFKX6ZOF9Ou9geziHh8r23
    unix-2.7.3 unordered-containers-0.2.20-3iRUctzIz2JCUYhLp7SKku
    vector-0.13.2.0-GniUvXn58d91eC1W7jmZ0
    vty-6.2-Lcuv7fOmdiMBuQvpwK7w7n

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

