#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-Fr8iX1xQumODr29QTceYPL
key:                  glirc-2.40.1-Fr8iX1xQumODr29QTceYPL
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  d9e7cbd607a8af0e01981cbc6215e137
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-Fr8iX1xQumODr29QTceYPL
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-9MhIThhB2kjD9QC8GCIQPx
    async-2.2.5-HB5EOpH6TM6FYgOEK5nN87
    attoparsec-0.14.4-HrmGc7uWcHZBxPSUhHwhWb base-4.17.2.1
    base64-bytestring-1.2.1.0-Gcv0cK19O0C10ALYRTEs9u
    bytestring-0.11.5.3 config-schema-1.3.0.0-L143z2ZwMKzJSRQxepTpU4
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-D7NLBrfkIomGQlKpL4FnyV directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-6qH0BV7uWBY9WRPbhnTBW1
    githash-0.1.6.3-F5IH3paueem2ygsVjA18rO
    hashable-1.4.4.0-7d9WFDaK31uHgEwdYM8cSb
    hookup-0.8-GNwRLEbg0KnC3nsgfkcZvJ
    irc-core-2.12-EqA3yBVOITn16N9zCaK3XZ
    kan-extensions-5.2.7-9i4tQ3lM3BF8ibFBmnww7j
    lens-5.3.1-9N2tK9zs7SGKEpVslmdE8u
    network-3.1.4.0-1ps2oXOoyxa7GsNgS88GCq
    psqueues-0.2.8.2-7neYUk1wJ76A7A2C0Rzmji
    random-1.2.1.3-6fLOERitWZgLekqeklTRBb
    regex-tdfa-1.3.2.4-76nazsu2jDf2z4IzA4PXWU
    semigroupoids-6.0.1-1gh8OSweUHoBPxrzLKEmMu
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-8udIdsw0LXGFTedDDXPwbe
    unix-2.7.3 unordered-containers-0.2.20-90liAnN3BtD8VAzg2AGnlq
    vector-0.13.2.0-Fx80VLFrFKz3Sy2krWU8Ue
    vty-6.2-9qhVllmo6N57UwitI2ZqKh

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

