/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.opentelemetry.api.trace;

import org.jetbrains.kotlin.io.opentelemetry.api.common.Attributes;
import org.jetbrains.kotlin.io.opentelemetry.api.internal.ApiUsageLogger;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.PropagatedSpan;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.SpanContext;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.SpanContextKey;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.StatusCode;
import org.jetbrains.kotlin.io.opentelemetry.context.Context;
import org.jetbrains.kotlin.io.opentelemetry.context.ImplicitContextKeyed;

public interface Span
extends ImplicitContextKeyed {
    public static Span current() {
        Span span = (Span)Context.current().get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null) {
            ApiUsageLogger.log("context is null");
            return Span.getInvalid();
        }
        return PropagatedSpan.create(spanContext);
    }

    default public Span setStatus(StatusCode statusCode) {
        return this.setStatus(statusCode, "");
    }

    public Span setStatus(StatusCode var1, String var2);

    public Span recordException(Throwable var1, Attributes var2);

    public void end();

    public SpanContext getSpanContext();
}

