/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import java.io.File;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.quality.AbstractCodeQualityTask;
import org.gradle.api.plugins.quality.CodeNarcReports;
import org.gradle.api.plugins.quality.internal.CodeNarcAction;
import org.gradle.api.plugins.quality.internal.CodeNarcActionParameters;
import org.gradle.api.plugins.quality.internal.CodeNarcReportsImpl;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Describables;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.workers.WorkQueue;

@CacheableTask
public abstract class CodeNarc
extends AbstractCodeQualityTask
implements Reporting<CodeNarcReports> {
    private FileCollection codenarcClasspath;
    private FileCollection compilationClasspath;
    private TextResource config;
    private int maxPriority1Violations;
    private int maxPriority2Violations;
    private int maxPriority3Violations;
    private final CodeNarcReports reports = (CodeNarcReports)this.getObjectFactory().newInstance(CodeNarcReportsImpl.class, new Object[]{Describables.quoted((Object)"Task", (Object)this.getIdentityPath())});

    public CodeNarc() {
        this.compilationClasspath = this.getProject().files(new Object[0]);
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public File getConfigFile() {
        return this.getConfig() == null ? null : this.getConfig().asFile();
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @ToBeReplacedByLazyProperty
    public FileTree getSource() {
        return super.getSource();
    }

    public void setConfigFile(File configFile) {
        this.setConfig(this.getProject().getResources().getText().fromFile((Object)configFile));
    }

    @TaskAction
    public void run() {
        WorkQueue workQueue = this.getWorkerExecutor().processIsolation(spec -> this.configureForkOptions(spec.getForkOptions()));
        workQueue.submit(CodeNarcAction.class, this::setupParameters);
    }

    private void setupParameters(CodeNarcActionParameters parameters) {
        parameters.getAntLibraryClasspath().setFrom((Iterable)this.getCodenarcClasspath());
        parameters.getCompilationClasspath().setFrom((Iterable)this.getCompilationClasspath());
        parameters.getConfig().set(this.getConfigFile());
        parameters.getMaxPriority1Violations().set((Object)this.getMaxPriority1Violations());
        parameters.getMaxPriority2Violations().set((Object)this.getMaxPriority2Violations());
        parameters.getMaxPriority3Violations().set((Object)this.getMaxPriority3Violations());
        parameters.getEnabledReports().set((Iterable)this.getReports().getEnabled().stream().map(report -> {
            CodeNarcActionParameters.EnabledReport newReport = (CodeNarcActionParameters.EnabledReport)this.getObjectFactory().newInstance(CodeNarcActionParameters.EnabledReport.class, new Object[0]);
            newReport.getName().set((Object)report.getName());
            newReport.getOutputLocation().set((Provider)report.getOutputLocation());
            return newReport;
        }).collect(Collectors.toList()));
        parameters.getIgnoreFailures().set((Object)this.getIgnoreFailures());
        parameters.getSource().setFrom((Iterable)this.getSource());
    }

    public CodeNarcReports reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public CodeNarcReports reports(Action<? super CodeNarcReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getCodenarcClasspath() {
        return this.codenarcClasspath;
    }

    public void setCodenarcClasspath(FileCollection codenarcClasspath) {
        this.codenarcClasspath = codenarcClasspath;
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getCompilationClasspath() {
        return this.compilationClasspath;
    }

    public void setCompilationClasspath(FileCollection compilationClasspath) {
        this.compilationClasspath = compilationClasspath;
    }

    @Nested
    public TextResource getConfig() {
        return this.config;
    }

    public void setConfig(TextResource config) {
        this.config = config;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public int getMaxPriority1Violations() {
        return this.maxPriority1Violations;
    }

    public void setMaxPriority1Violations(int maxPriority1Violations) {
        this.maxPriority1Violations = maxPriority1Violations;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public int getMaxPriority2Violations() {
        return this.maxPriority2Violations;
    }

    public void setMaxPriority2Violations(int maxPriority2Violations) {
        this.maxPriority2Violations = maxPriority2Violations;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public int getMaxPriority3Violations() {
        return this.maxPriority3Violations;
    }

    public void setMaxPriority3Violations(int maxPriority3Violations) {
        this.maxPriority3Violations = maxPriority3Violations;
    }

    @Nested
    public CodeNarcReports getReports() {
        return this.reports;
    }
}

