#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-EZ4q40CmD1e6rYIqwxbubT
key:                  aeson-2.1.2.1-EZ4q40CmD1e6rYIqwxbubT
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  da409745bc00a9ea376f5ec6e9e3c96c
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-EZ4q40CmD1e6rYIqwxbubT
depends:
    OneTuple-0.4.2-AgsRyJzXgaRBeAUoRAKyao
    QuickCheck-2.14.3-7Pyc2AYOm6L3Hfy5iTUeSy
    attoparsec-0.14.4-K6A3Lnx18lt9B7Ad03ungd base-4.17.2.1
    base-compat-batteries-0.12.3-3HdfeRUc4ebLtEfTaroPuu
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-Hk7ottUiQPP3SSFpayflzz deepseq-1.4.8.0
    dlist-1.0-I6FB5Nlk17hG16fxQzZSEb exceptions-0.10.5
    generically-0.1.1-AbIR3UuaaDo1wP8oTk6Dpw ghc-prim-0.9.1
    hashable-1.4.4.0-7zzKXDBa1HP1F6vPi1Tvtg
    indexed-traversable-0.1.4-9Yra3WDK9eE6oqTuJLwCGF
    primitive-0.8.0.0-5TU9coTCbFAF1LmcqkQLR6
    scientific-0.3.7.0-EaRpQXcrvKCD1LBpAEBJcM
    semialign-1.3-6lS3P4BG8P5GF9KQkdOroz
    strict-0.5-Asx9r8khpkJF5SvMHY9rKf
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-6JESF0ntfWwGBrtTMoZzkY
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-EUN4GybzrE7FQDMpKNFISs time-1.12.2
    time-compat-1.9.6.1-7IiwlW7vFWH8fdgbewXKV0
    unordered-containers-0.2.20-Kq2dPHqifzB9n0MYGmTosg
    uuid-types-1.0.6-7DTS07AIYQJ4dPCOh4ydF8
    vector-0.13.2.0-F8322NeNtfL69paM3N9AVt
    witherable-0.4.2-HmcKDsRoRCt6EULhuBzHiG

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

