#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-7TMJ6p0lPVhG6CIuOzoeIX
key:                  aeson-2.1.2.1-7TMJ6p0lPVhG6CIuOzoeIX
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  fac9ee5577a8c01124b5f5a0fcbce538
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-7TMJ6p0lPVhG6CIuOzoeIX
depends:
    OneTuple-0.4.2-6YubkrvLB6RDWKEI1F6zoU
    QuickCheck-2.14.3-AWnG2Z8xMvaCjZJci5yyUU
    attoparsec-0.14.4-IqYBa84WdkQFW0ao0EbpsL base-4.17.2.1
    base-compat-batteries-0.12.3-IhI3gSRv8IS4WXFpC6Xyu5
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-1rJLfmyHaxM1t4TlkxIrhM deepseq-1.4.8.0
    dlist-1.0-I6FB5Nlk17hG16fxQzZSEb exceptions-0.10.5
    generically-0.1.1-HutabJ1bNG04KpPscc4tbV ghc-prim-0.9.1
    hashable-1.4.4.0-FynBNkBkxFwFS4cZZfROI0
    indexed-traversable-0.1.4-JMFfMY9qkSC3EA9yJB3Bj3
    primitive-0.8.0.0-6An9wzMGepD768IPMOzTEV
    scientific-0.3.7.0-Gqw7zQrIdQ6AMN7G6h757T
    semialign-1.3-82LhWskdDLL3vMXkCH30Oh
    strict-0.5-B9Nn6a2aMP2F5oMoH9Uop6
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-EeJbjUU0bCdFwYrVszH4l1
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-4P37SNkDGDGUrZlK0zeYY time-1.12.2
    time-compat-1.9.6.1-8K73TvxpfQn6qvlKqI9vvQ
    unordered-containers-0.2.20-9U3MJ5tqJC21lluZ2htuAw
    uuid-types-1.0.6-9fbqz1GWLuO4AUs0op8fGK
    vector-0.13.2.0-7ui5x1CRQnp40KJGogy4Qf
    witherable-0.4.2-GJ4vSRjZN8D7shBaYeDN5y

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

