#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb
key:                  aeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  2fcd3ee7b495e404863a160661b2377e
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb
depends:
    OneTuple-0.4.2-H2hq3WX7vAYH5Mde32s1b7
    QuickCheck-2.14.3-KXTisc688NGHRnxG3vFYz5
    attoparsec-0.14.4-GuMPfMcqjBDDq1IerlxPtw base-4.17.2.1
    base-compat-batteries-0.13.0-3nC4HumkPbt9P8n0IFfS2e
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-JYg4OHIYKet86IYYftyaW2 deepseq-1.4.8.0
    dlist-1.0-BKgPi70fx5AJreCYiKxIIN exceptions-0.10.5
    generically-0.1.1-D7FBAQ4wEPGCWVr2r5hsrK ghc-prim-0.9.1
    hashable-1.4.4.0-BEEuzU8Xb1pET12cUzIyiR
    indexed-traversable-0.1.4-HG6KC0xY4QL1bu8moi9PYK
    primitive-0.9.1.0-GChnkqMWBe7B15Z0K3IGlf
    scientific-0.3.8.0-4NIM1ptKK7Y3EgpQdVTV5l
    semialign-1.3.1-IjanWIx4qjs1s7rD9nd3DJ
    strict-0.5-GV5a1xRw4joIZsUwrkilLh
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-72L4XTpJm8f8n6a1xQ7zPw
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-CGeYxyuBFlc1Yz3ybvsTPO time-1.12.2
    time-compat-1.9.6.1-GSzJ0fLdtlt7ILeqMQMlx
    unordered-containers-0.2.20-IhcdMC6aki1KSQ4zttUKBR
    uuid-types-1.0.6-ErdtALHm61o7fES6hx6EFZ
    vector-0.13.2.0-B39FQf4cXUZ2GlwNF0TDTd
    witherable-0.4.2-4UkOn9oin3Q5DkaibB8irI

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

