#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M
key:                  aeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  418dbf470d69071da4c8a6b963c99255
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-H1ahbkp4Y7o4mfa4dlXJ2M
depends:
    OneTuple-0.4.2-5DyQFzq8WA51jg2V77K4Uo
    QuickCheck-2.14.3-CpTyyGCQ8vELJYAkeHIgu4
    attoparsec-0.14.4-EuJHdCyQx9qFeM6j3QZsTf base-4.17.2.1
    base-compat-batteries-0.13.0-BMAS8Gep38251oHfjMoLhV
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-FaCSwEZDk2RGCkIsPCJxwt deepseq-1.4.8.0
    dlist-1.0-BKgPi70fx5AJreCYiKxIIN exceptions-0.10.5
    generically-0.1.1-LNFQlMEK70Q9MQJN87uJPv ghc-prim-0.9.1
    hashable-1.4.4.0-92QHxum7zjW25fH5Mdbvto
    indexed-traversable-0.1.4-HmCeTJ1cz14DZudjUkSqsc
    primitive-0.9.1.0-K5FffD7IzwSCOmYZphWR0K
    scientific-0.3.8.0-6uPUyX2SLNQ5uEuI9iq9EK
    semialign-1.3.1-KI03nXLnBNT61ehXfoKIla
    strict-0.5-2CepwdUl6wb1PePI2vwYnM
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-4qpll6DrrUwGInpyZhDvH9
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-IFcRIL6PxjZ14coZxMpOMV time-1.12.2
    time-compat-1.9.7-H1T0bJs9C1B5Yd1AMxc0gn
    unordered-containers-0.2.20-L0GY6JfHBKC8QjVdSVYiO8
    uuid-types-1.0.6-3B6hMZuUWHV2tqfyf9WluR
    vector-0.13.2.0-LTUcBi4LXgv7CSERMHHzQp
    witherable-0.4.2-IuzoN0TutxJKhl8Q3OV5Gi

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

