#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson-pretty
version:              0.8.10
visibility:           public
id:                   aeson-pretty-0.8.10-6Jj4MhYvGcCJDG7KnnBAWa
key:                  aeson-pretty-0.8.10-6Jj4MhYvGcCJDG7KnnBAWa
license:              BSD-3-Clause
copyright:            Copyright 2011 Falko Peters
maintainer:           Martijn Bastiaan <martijn@hmbastiaan.nl>
author:               Falko Peters <falko.peters@gmail.com>
stability:            experimental
homepage:             http://github.com/informatikr/aeson-pretty
synopsis:             JSON pretty-printing library and command-line tool.
description:
    A JSON pretty-printing library compatible with aeson as well as
    a command-line tool to improve readabilty of streams of JSON data.

    The /library/ provides the function "encodePretty". It is a drop-in
    replacement for aeson'\''s "encode" function, producing JSON-ByteStrings for
    human readers.

    The /command-line tool/ reads JSON from stdin and writes prettified JSON
    to stdout. It also offers a complementary "compact"-mode, essentially the
    opposite of pretty-printing. If you specify @-flib-only@ like this

    > cabal install -flib-only aeson-pretty

    the command-line tool will NOT be installed.

category:             Text, Web, JSON, Pretty Printer
abi:                  06ffe39bdf26b5895d15ddac0a74e745
exposed:              True
exposed-modules:      Data.Aeson.Encode.Pretty
import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-pretty-0.8.10
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-pretty-0.8.10
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-pretty-0.8.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson-pretty
hs-libraries:         HSaeson-pretty-0.8.10-6Jj4MhYvGcCJDG7KnnBAWa
depends:
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us base-4.17.2.1
    base-compat-0.13.0-4bY7VGgUDQwFnN0OMsXbDp bytestring-0.11.5.3
    scientific-0.3.8.0-JrlaAXGfnydA9ZtLsuTElg text-2.0.2
    unordered-containers-0.2.20-ASGEyX3xTBf3ZK5sYSGlF8
    vector-0.13.2.0-L6HpF7nmtGm1K7R40olL6U

haddock-interfaces:
    /usr/share/doc/haskell-aeson-pretty/html/aeson-pretty.haddock

haddock-html:         /usr/share/doc/haskell-aeson-pretty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

