#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arithmoi
version:              0.13.2.0
visibility:           public
id:                   arithmoi-0.13.2.0-5Dsv48HZSN5cMMbQblLYH
key:                  arithmoi-0.13.2.0-5Dsv48HZSN5cMMbQblLYH
license:              MIT
copyright:
    (c) 2016-2021 Andrew Lelechenko, 2016-2019 Carter Schonwald, 2011 Daniel Fischer

maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko, Daniel Fischer
homepage:             https://github.com/Bodigrim/arithmoi
synopsis:             Efficient basic number-theoretic functions.
description:
    A library of basic functionality needed for
    number-theoretic calculations. The aim of this library
    is to provide efficient implementations of the functions.
    Primes and related things (totients, factorisation),
    powers (integer roots and tests, modular exponentiation).

category:             Math, Algorithms, Number Theory
abi:                  283e9c59d3aa9d1c1ce99a23b848f167
exposed:              True
exposed-modules:
    Math.NumberTheory.ArithmeticFunctions
    Math.NumberTheory.ArithmeticFunctions.Inverse
    Math.NumberTheory.ArithmeticFunctions.Mertens
    Math.NumberTheory.ArithmeticFunctions.Moebius
    Math.NumberTheory.ArithmeticFunctions.NFreedom
    Math.NumberTheory.ArithmeticFunctions.SieveBlock
    Math.NumberTheory.Curves.Montgomery Math.NumberTheory.Diophantine
    Math.NumberTheory.DirichletCharacters
    Math.NumberTheory.Euclidean.Coprimes Math.NumberTheory.Moduli
    Math.NumberTheory.Moduli.Cbrt Math.NumberTheory.Moduli.Chinese
    Math.NumberTheory.Moduli.Class Math.NumberTheory.Moduli.Equations
    Math.NumberTheory.Moduli.Multiplicative
    Math.NumberTheory.Moduli.Singleton Math.NumberTheory.Moduli.Sqrt
    Math.NumberTheory.MoebiusInversion Math.NumberTheory.Prefactored
    Math.NumberTheory.Primes Math.NumberTheory.Primes.Counting
    Math.NumberTheory.Primes.IntSet Math.NumberTheory.Primes.Testing
    Math.NumberTheory.Quadratic.EisensteinIntegers
    Math.NumberTheory.Quadratic.GaussianIntegers
    Math.NumberTheory.Recurrences
    Math.NumberTheory.Recurrences.Bilinear
    Math.NumberTheory.Recurrences.Linear
    Math.NumberTheory.SmoothNumbers Math.NumberTheory.Zeta

hidden-modules:
    Math.NumberTheory.ArithmeticFunctions.Class
    Math.NumberTheory.ArithmeticFunctions.Standard
    Math.NumberTheory.Moduli.Internal
    Math.NumberTheory.Moduli.JacobiSymbol
    Math.NumberTheory.Moduli.SomeMod
    Math.NumberTheory.Primes.Counting.Approximate
    Math.NumberTheory.Primes.Counting.Impl
    Math.NumberTheory.Primes.Factorisation.Montgomery
    Math.NumberTheory.Primes.Factorisation.TrialDivision
    Math.NumberTheory.Primes.Sieve.Eratosthenes
    Math.NumberTheory.Primes.Sieve.Indexing
    Math.NumberTheory.Primes.Small
    Math.NumberTheory.Primes.Testing.Certified
    Math.NumberTheory.Primes.Testing.Probabilistic
    Math.NumberTheory.Primes.Types
    Math.NumberTheory.Recurrences.Pentagonal
    Math.NumberTheory.RootsOfUnity Math.NumberTheory.Utils
    Math.NumberTheory.Utils.DirichletSeries
    Math.NumberTheory.Utils.FromIntegral
    Math.NumberTheory.Utils.Hyperbola Math.NumberTheory.Zeta.Dirichlet
    Math.NumberTheory.Zeta.Hurwitz Math.NumberTheory.Zeta.Riemann
    Math.NumberTheory.Zeta.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-arithmoi
hs-libraries:         HSarithmoi-0.13.2.0-5Dsv48HZSN5cMMbQblLYH
depends:
    base-4.17.2.1 bitvec-1.1.5.0-DPr1NBaPBeLwqRqLKsIDr
    chimera-0.4.1.0-IHfJDi4mYboE6PY50nBHG2
    constraints-0.14.2-Cs7BcMCRC7p94iJ5N6cONg containers-0.6.7
    deepseq-1.4.8.0 exact-pi-0.5.0.2-HuknmWabctq3Q4Rf3lf0v3
    ghc-bignum-1.3 infinite-list-0.1.2-9NlQAMF2S3R2KflhpLQHYY
    integer-logarithms-1.0.4-BRmAjUWWnSzDWWc7GtOJxS
    integer-roots-1.0.3.0-4Xb4BVBlfkl1vHRfAkUbwG
    mod-0.2.1.0-K8JZ4V5Vz9H2YoAeH3szSz
    random-1.2.1.3-EWI627yJJMEDZyiJYbiRy4
    semirings-0.7-6iJga6jAjSNp8MQwr1blh transformers-0.5.6.2
    vector-0.13.2.0-FDZBPFjQhmHDghUn2Zh3lL

haddock-interfaces:   /usr/share/doc/haskell-arithmoi/html/arithmoi.haddock
haddock-html:         /usr/share/doc/haskell-arithmoi/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

