#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 asn1-encoding
version:              0.9.6
visibility:           public
id:                   asn1-encoding-0.9.6-4QGxvmwNaLFDCNmiug7spa
key:                  asn1-encoding-0.9.6-4QGxvmwNaLFDCNmiug7spa
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/vincenthz/hs-asn1
synopsis:             ASN1 data reader and writer in RAW, BER and DER forms
description:
    ASN1 data reader and writer in raw form with supports for high level forms of ASN1 (BER, and DER).

category:             Data
abi:                  beda6c73e1f9404f74b7249b69c032e7
exposed:              True
exposed-modules:
    Data.ASN1.BinaryEncoding Data.ASN1.BinaryEncoding.Raw
    Data.ASN1.Encoding Data.ASN1.Error Data.ASN1.Object Data.ASN1.Prim
    Data.ASN1.Stream

hidden-modules:
    Data.ASN1.BinaryEncoding.Parse Data.ASN1.BinaryEncoding.Writer
    Data.ASN1.Internal Data.ASN1.Serialize Data.ASN1.Get

import-dirs:          /usr/lib/ghc-9.4.8/site-local/asn1-encoding-0.9.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/asn1-encoding-0.9.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/asn1-encoding-0.9.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-asn1-encoding
hs-libraries:         HSasn1-encoding-0.9.6-4QGxvmwNaLFDCNmiug7spa
depends:
    asn1-types-0.3.4-VxacLSE1zNJE2ccrOQRFq base-4.17.2.1
    bytestring-0.11.5.3 hourglass-0.2.12-dAUkgXLil533G2IV0frBg

haddock-interfaces:
    /usr/share/doc/haskell-asn1-encoding/html/asn1-encoding.haddock

haddock-html:         /usr/share/doc/haskell-asn1-encoding/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

