#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 async
version:              2.2.5
visibility:           public
id:                   async-2.2.5-DLLO0Mnvxu7HErYx4gsRCE
key:                  async-2.2.5-DLLO0Mnvxu7HErYx4gsRCE
license:              BSD-3-Clause
copyright:            (c) Simon Marlow 2012
maintainer:           Simon Marlow <marlowsd@gmail.com>
author:               Simon Marlow
homepage:             https://github.com/simonmar/async
synopsis:             Run IO operations asynchronously and wait for their results
description:
    This package provides a higher-level interface over
    threads, in which an @Async a@ is a concurrent
    thread that will eventually deliver a value of
    type @a@.  The package provides ways to create
    @Async@ computations, wait for their results, and
    cancel them.

    Using @Async@ is safer than using threads in two
    ways:

    * When waiting for a thread to return a result,
    if the thread dies with an exception then the
    caller must either re-throw the exception
    ('\''wait'\'') or handle it ('\''waitCatch'\''); the
    exception cannot be ignored.

    * The API makes it possible to build a tree of
    threads that are automatically killed when
    their parent dies (see '\''withAsync'\'').

category:             Concurrency
abi:                  a3f15789813f476c7a13d39cc09d7323
exposed:              True
exposed-modules:
    Control.Concurrent.Async Control.Concurrent.Async.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/async-2.2.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/async-2.2.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/async-2.2.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-async
hs-libraries:         HSasync-2.2.5-DLLO0Mnvxu7HErYx4gsRCE
depends:
    base-4.17.2.1 hashable-1.4.6.0-JiQr1Tltq7G4W5bcwnoSMj stm-2.5.1.0

haddock-interfaces:   /usr/share/doc/haskell-async/html/async.haddock
haddock-html:         /usr/share/doc/haskell-async/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

