#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aws
version:              0.24
visibility:           public
id:                   aws-0.24-IZSfYSKf8N37s626ioLYvY
key:                  aws-0.24-IZSfYSKf8N37s626ioLYvY
license:              BSD-3-Clause
copyright:            See contributors list in README and LICENSE file
maintainer:           aristidb@gmail.com
author:               Aristid Breitkreuz, contributors see README
homepage:             http://github.com/aristidb/aws
synopsis:             Amazon Web Services (AWS) for Haskell
description:
    Bindings for Amazon Web Services (AWS), with the aim of supporting all AWS services. To see a high level overview of the library, see the README at <https://github.com/aristidb/aws/blob/master/README.md>.

category:             Network, Web, AWS, Cloud, Distributed Computing
abi:                  ff37d8ef264038135bca68b072e76cb3
exposed:              True
exposed-modules:
    Aws Aws.Aws Aws.Core Aws.DynamoDb Aws.DynamoDb.Commands
    Aws.DynamoDb.Commands.BatchGetItem
    Aws.DynamoDb.Commands.BatchWriteItem
    Aws.DynamoDb.Commands.DeleteItem Aws.DynamoDb.Commands.GetItem
    Aws.DynamoDb.Commands.PutItem Aws.DynamoDb.Commands.Query
    Aws.DynamoDb.Commands.Scan Aws.DynamoDb.Commands.Table
    Aws.DynamoDb.Commands.UpdateItem Aws.DynamoDb.Core
    Aws.Ec2.InstanceMetadata Aws.Iam Aws.Iam.Commands
    Aws.Iam.Commands.AddUserToGroup Aws.Iam.Commands.CreateAccessKey
    Aws.Iam.Commands.CreateGroup Aws.Iam.Commands.CreateUser
    Aws.Iam.Commands.DeleteAccessKey Aws.Iam.Commands.DeleteGroup
    Aws.Iam.Commands.DeleteGroupPolicy Aws.Iam.Commands.DeleteUser
    Aws.Iam.Commands.DeleteUserPolicy Aws.Iam.Commands.GetGroupPolicy
    Aws.Iam.Commands.GetUser Aws.Iam.Commands.GetUserPolicy
    Aws.Iam.Commands.ListAccessKeys Aws.Iam.Commands.ListGroupPolicies
    Aws.Iam.Commands.ListGroups Aws.Iam.Commands.ListMfaDevices
    Aws.Iam.Commands.ListUserPolicies Aws.Iam.Commands.ListUsers
    Aws.Iam.Commands.PutGroupPolicy Aws.Iam.Commands.PutUserPolicy
    Aws.Iam.Commands.RemoveUserFromGroup
    Aws.Iam.Commands.UpdateAccessKey Aws.Iam.Commands.UpdateGroup
    Aws.Iam.Commands.UpdateUser Aws.Iam.Core Aws.Iam.Internal
    Aws.Network Aws.S3 Aws.S3.Commands Aws.S3.Commands.CopyObject
    Aws.S3.Commands.DeleteBucket Aws.S3.Commands.DeleteObject
    Aws.S3.Commands.DeleteObjectVersion Aws.S3.Commands.DeleteObjects
    Aws.S3.Commands.GetBucket Aws.S3.Commands.GetBucketLocation
    Aws.S3.Commands.GetBucketObjectVersions Aws.S3.Commands.GetObject
    Aws.S3.Commands.GetService Aws.S3.Commands.HeadObject
    Aws.S3.Commands.Multipart Aws.S3.Commands.PutBucket
    Aws.S3.Commands.PutBucketVersioning Aws.S3.Commands.PutObject
    Aws.S3.Core Aws.Ses Aws.Ses.Commands
    Aws.Ses.Commands.DeleteIdentity
    Aws.Ses.Commands.GetIdentityDkimAttributes
    Aws.Ses.Commands.GetIdentityNotificationAttributes
    Aws.Ses.Commands.GetIdentityVerificationAttributes
    Aws.Ses.Commands.ListIdentities Aws.Ses.Commands.SendRawEmail
    Aws.Ses.Commands.SetIdentityDkimEnabled
    Aws.Ses.Commands.SetIdentityFeedbackForwardingEnabled
    Aws.Ses.Commands.SetIdentityNotificationTopic
    Aws.Ses.Commands.VerifyDomainDkim
    Aws.Ses.Commands.VerifyDomainIdentity
    Aws.Ses.Commands.VerifyEmailIdentity Aws.Ses.Core Aws.SimpleDb
    Aws.SimpleDb.Commands Aws.SimpleDb.Commands.Attributes
    Aws.SimpleDb.Commands.Domain Aws.SimpleDb.Commands.Select
    Aws.SimpleDb.Core Aws.Sqs Aws.Sqs.Commands Aws.Sqs.Commands.Message
    Aws.Sqs.Commands.Permission Aws.Sqs.Commands.Queue
    Aws.Sqs.Commands.QueueAttributes Aws.Sqs.Core

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aws-0.24
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aws-0.24
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aws-0.24
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aws
hs-libraries:         HSaws-0.24-IZSfYSKf8N37s626ioLYvY
depends:
    aeson-2.1.2.1-41nZsNdpCJ94QO3IYYsFbV
    attoparsec-0.14.4-6t7vY6Q8UUxCr7xgApY0J0 base-4.17.2.1
    base16-bytestring-1.0.2.0-2g7vQYppoMG2r37VyquVQT
    base64-bytestring-1.2.1.0-4DbFMB2wqjsI3SEJJZAUQb
    blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS
    byteable-0.1.1-BiXMgwkGoIQH63GBEhxKBY bytestring-0.11.5.3
    case-insensitive-1.2.1.0-KKJyu9JGFWV4kYAUCco28N
    cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    conduit-1.3.6.1-4J0p2y8YZbl5jbLvhSkgCv
    conduit-extra-1.3.7-Ajk39DYeR8SCitLkHBuvyO containers-0.6.7
    cryptonite-0.30-1VFnzPzmSzjxqMnISKy4Y
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    exceptions-0.10.5 filepath-1.4.2.2
    http-client-tls-0.3.6.4-Cnr6POTzqsU8qQHAu0A4zz
    http-conduit-2.3.9.1-GzC96qBuvDU7sUI5g556at
    http-types-0.12.4-4HneWdIW87FoB16iA969W
    lifted-base-0.2.3.12-6wswo9GT4zCGLn4QWI7nep
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-control-1.0.3.1-18Icxj9GvXSIdvvVrM16Af mtl-2.2.2
    network-3.1.4.0-CtaCAPUvf8iCYTgusVmkxJ
    network-bsd-2.8.1.0-6xefxFrJZFHK8kDymPBKXp
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    resourcet-1.2.6-HOcTeGTfW655uDg0bvoLZW
    safe-0.3.21-EVxU3guTVsn44meiNlrghU
    scientific-0.3.7.0-BwEO4QQ4poVHhQfhShWbCU
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2 time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-1XH4GFhGkAzqDGOzdhg7S
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    vector-0.13.2.0-7SxE3dSPVCM2VxyJW4x4GJ
    xml-conduit-1.9.1.4-J0Oz7YCPEldBjFvuSpAMww

haddock-interfaces:   /usr/share/doc/haskell-aws/html/aws.haddock
haddock-html:         /usr/share/doc/haskell-aws/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

