#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bitvec
version:              1.1.4.0
visibility:           public
id:                   bitvec-1.1.4.0-BYYWjbX6Ob2DaKE2alINxx
key:                  bitvec-1.1.4.0-BYYWjbX6Ob2DaKE2alINxx
license:              BSD-3-Clause
copyright:            2019-2022 Andrew Lelechenko, 2012-2016 James Cook
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:
    Andrew Lelechenko <andrew.lelechenko@gmail.com>,
    James Cook <mokus@deepbondi.net>

homepage:             https://github.com/Bodigrim/bitvec
synopsis:             Space-efficient bit vectors
description:
    A newtype over '\''Bool'\'' with a better '\''Vector'\'' instance: 8x less memory, up to 1000x faster.

    The <https://hackage.haskell.org/package/vector vector>
    package represents unboxed arrays of '\''Bool'\''s
    spending 1 byte (8 bits) per boolean.
    This library provides a newtype wrapper '\''Bit'\'' and a custom instance
    of an unboxed '\''Vector'\'', which packs bits densely,
    achieving an __8x smaller memory footprint.__
    The performance stays mostly the same;
    the most significant degradation happens for random writes
    (up to 10% slower).
    On the other hand, for certain bulk bit operations
    '\''Vector'\'' '\''Bit'\'' is up to 1000x faster than '\''Vector'\'' '\''Bool'\''.

    === Thread safety

    * "Data.Bit" is faster, but writes and flips are thread-unsafe.
    This is because naive updates are not atomic:
    they read the whole word from memory,
    then modify a bit, then write the whole word back.
    * "Data.Bit.ThreadSafe" is slower (usually 10-20%),
    but writes and flips are thread-safe.

    === Similar packages

    * <https://hackage.haskell.org/package/bv bv> and
    <https://hackage.haskell.org/package/bv-little bv-little>
    do not offer mutable vectors.

    * <https://hackage.haskell.org/package/array array>
    is memory-efficient for '\''Bool'\'', but lacks
    a handy '\''Vector'\'' interface and is not thread-safe.

category:             Data, Bit Vectors
abi:                  3569d1da422247ed1d31cb6d65f1a4e8
exposed:              True
exposed-modules:      Data.Bit Data.Bit.ThreadSafe
hidden-modules:
    Data.Bit.F2Poly Data.Bit.F2PolyTS Data.Bit.Immutable
    Data.Bit.ImmutableTS Data.Bit.Internal Data.Bit.InternalTS
    Data.Bit.Mutable Data.Bit.MutableTS Data.Bit.PdepPext
    Data.Bit.Utils Data.Bit.Gmp

import-dirs:          /usr/lib/ghc-9.4.8/site-local/bitvec-1.1.4.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/bitvec-1.1.4.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/bitvec-1.1.4.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bitvec
hs-libraries:         HSbitvec-1.1.4.0-BYYWjbX6Ob2DaKE2alINxx
extra-libraries:      gmp
depends:
    base-4.17.2.1 bytestring-0.11.5.3 deepseq-1.4.8.0 ghc-bignum-1.3
    primitive-0.9.1.0-4og3N5b6tAb1VUfCmYprp3
    vector-0.13.2.0-ZKpjTfyjPa7BNElf7Ue7Z

haddock-interfaces:   /usr/share/doc/haskell-bitvec/html/bitvec.haddock
haddock-html:         /usr/share/doc/haskell-bitvec/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

