#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bitwise
version:              1.0.0.1
visibility:           public
id:                   bitwise-1.0.0.1-5dgWVVgyT97K5zOPUnyObb
key:                  bitwise-1.0.0.1-5dgWVVgyT97K5zOPUnyObb
license:              BSD-3-Clause
copyright:            (c) 2012,2016,2018 Claude Heiland-Allen
maintainer:           claude@mathr.co.uk
author:               Claude Heiland-Allen
homepage:             https://code.mathr.co.uk/bitwise
synopsis:             fast multi-dimensional unboxed bit packed Bool arrays
description:
    Unboxed multidimensional bit packed Bool arrays with fast aggregate
    operations based on lifting Bool operations to bitwise operations.

    There are many other bit packed structures out there, but none met
    all of these requirements:

    (1) unboxed bit packed Bool array,

    (2) multi-dimensional indexing,

    (3) fast (de)serialization, or interoperable with foreign code,

    (4) fast aggregate operations (fold, map, zip).

    Quick tour of the bitwise library:

    [Data.Bits.Bitwise] Lift boolean operations on '\''Bool'\'' to bitwise
    operations on '\''Data.Bits.Bits'\''.

    [Data.Array.BitArray] Immutable bit arrays.

    [Data.Array.BitArray.ST] Mutable bit arrays in '\''Control.Monad.ST.ST'\''.

    [Data.Array.BitArray.IO] Mutable bit arrays in '\''IO'\''.

    [Data.Array.BitArray.ByteString] (De)serialization.

    [Codec.Image.PBM] Portable bitmap monochrome 2D image format.

    Very rough performance benchmarks:

    * immutable random access single bit reads:
    @BitArray ix@ is about 40% slower than @UArray ix Bool@,

    * '\''Control.Monad.ST.ST'\'' mutable random access single bit reads:
    @STBitArray s ix@ is about the same as @STUArray s ix Bool@,

    * immutable map @Bool -> Bool@:
    @BitArray ix@ is about 85x faster than @UArray ix Bool@,

    * immutable zipWith @Bool -> Bool -> Bool@:
    @BitArray ix@ is about 1300x faster than @UArray ix Bool@.

category:             Data, Data Structures, Bit Vectors
abi:                  d08863642741afc6820abf05567910bd
exposed:              True
exposed-modules:
    Codec.Image.PBM Data.Array.BitArray Data.Array.BitArray.ByteString
    Data.Array.BitArray.IO Data.Array.BitArray.ST Data.Bits.Bitwise

hidden-modules:       Data.Array.BitArray.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/bitwise-1.0.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/bitwise-1.0.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/bitwise-1.0.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bitwise
hs-libraries:         HSbitwise-1.0.0.1-5dgWVVgyT97K5zOPUnyObb
depends:              array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3
haddock-interfaces:   /usr/share/doc/haskell-bitwise/html/bitwise.haddock
haddock-html:         /usr/share/doc/haskell-bitwise/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

