#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bytestring-strict-builder
version:              0.4.5.8
visibility:           public
id:                   bytestring-strict-builder-0.4.5.8-CCoFUSiqc8wGam7r1i5x0Y
key:                  bytestring-strict-builder-0.4.5.8-CCoFUSiqc8wGam7r1i5x0Y
license:              MIT
copyright:            (c) 2017, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/bytestring-strict-builder
synopsis:             An efficient strict bytestring builder
description:
    According to 
    <https://github.com/nikita-volkov/bytestring-builders-benchmark the competition benchmarks>, 
    this library provides on average the fastest builder of strict bytestrings. 
    .
    Practical benchmarks have proven it to be highly performant as well.
    The encoders from the \"postgresql-binary\" library have shown
    a stable performance improvement by factors of up to 10 after the migration
    from the standard builder to \"bytestring-strict-builder\".

category:             Text, ByteString, Builders, Serialization
abi:                  565cf078c34317691fcaa19c4dc02e22
exposed:              True
exposed-modules:      ByteString.StrictBuilder
hidden-modules:
    ByteString.StrictBuilder.Population
    ByteString.StrictBuilder.Population.UncheckedShifting
    ByteString.StrictBuilder.Prelude ByteString.StrictBuilder.UTF8

import-dirs:
    /usr/lib/ghc-9.4.8/site-local/bytestring-strict-builder-0.4.5.8

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/bytestring-strict-builder-0.4.5.8

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/bytestring-strict-builder-0.4.5.8

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bytestring-strict-builder
hs-libraries:         HSbytestring-strict-builder-0.4.5.8-CCoFUSiqc8wGam7r1i5x0Y
depends:              base-4.17.2.1 bytestring-0.11.5.3
haddock-interfaces:
    /usr/share/doc/haskell-bytestring-strict-builder/html/bytestring-strict-builder.haddock

haddock-html:         /usr/share/doc/haskell-bytestring-strict-builder/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

