#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.16.3
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.16.3-AFBZDJtLjBFHIAAk8cDnaC-haskell-ci-internal

key:
    haskell-ci-0.16.3-AFBZDJtLjBFHIAAk8cDnaC-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  a2b094eac63104c5ee66969785470a86
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cabal HaskellCI.Cli
    HaskellCI.Compiler HaskellCI.Config HaskellCI.Config.Components
    HaskellCI.Config.ConstraintSet HaskellCI.Config.CopyFields
    HaskellCI.Config.Docspec HaskellCI.Config.Doctest
    HaskellCI.Config.Dump HaskellCI.Config.Empty HaskellCI.Config.Folds
    HaskellCI.Config.HLint HaskellCI.Config.Installed
    HaskellCI.Config.Jobs HaskellCI.Config.PackageScope
    HaskellCI.Config.Ubuntu HaskellCI.Config.Validity
    HaskellCI.Diagnostics HaskellCI.Error HaskellCI.Ghcup
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.16.3-AFBZDJtLjBFHIAAk8cDnaC-haskell-ci-internal

depends:
    Cabal-syntax-3.8.1.0 HsYAML-0.2.1.4-7xgLbQtdJEV4Zobg2eOiOn
    ShellCheck-0.11.0-7wcLO7TuYOHKjhNIXCK4Xq
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    attoparsec-0.14.4-AS2Ju05FAjs55rPAuL3miO base-4.17.2.1
    base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp
    base16-bytestring-1.0.2.0-HnopC1pBvWk9dgrypuG55K binary-0.8.9.1
    bytestring-0.11.5.3
    cabal-install-parsers-0.6-1iZTr0LUp7iAboPX8BeV6y containers-0.6.7
    cryptohash-sha256-0.11.102.1-H4bTMrsO7C8KhRBEMouzBp deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    generic-lens-lite-0.1.1-fdAG00wdys4njg4MryBwd
    indexed-traversable-0.1.4-G1Ar9vM2x492EvfRvVfHxJ
    indexed-traversable-instances-0.1.2-InCNmFzbyj5CUii9LP0zk9
    ini-0.4.2-4m1pev6nWp535DDc4L1Hph
    lattices-2.2.1-CXpB1xJp7WTEt5DH3EI8zo mtl-2.2.2
    network-uri-2.6.4.2-HjnHIRdbGth3RAPPiFyOPG
    optparse-applicative-0.18.1.0-5z7uKq3kDhiFdyVMsq5grp
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.18.0
    temporary-1.3-21yt0VJKXh7mDWSuXOVeh text-2.0.2 transformers-0.5.6.2
    unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    zinza-0.2-5Q82SVn2xEu1NjfjSTjAli

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

