#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clock
version:              0.8.4
visibility:           public
id:                   clock-0.8.4-IWGGiWVRGO6DvoMHIcmZzf
key:                  clock-0.8.4-IWGGiWVRGO6DvoMHIcmZzf
license:              BSD-3-Clause
copyright:
    Copyright © Cetin Sert 2009-2023, Eugene Kirpichov 2010, Finn Espen Gundersen 2013, Gerolf Seitz 2013, Mathieu Boespflug 2014 2015, Chris Done 2015, Dimitri Sabadie 2015, Christian Burger 2015, Mario Longobardi 2016, Alexander Vershilov 2021.

maintainer:           Cetin Sert <cetin@elefunc.com>, Elefunc, Inc.
author:               Cetin Sert <cetin@elefunc.com>, Elefunc, Inc.
stability:            stable
homepage:             https://github.com/corsis/clock
synopsis:
    High-resolution clock functions: monotonic, realtime, cputime.

description:
    A package for convenient access to high-resolution clock and
    timer functions of different operating systems via a unified API.

    POSIX code and surface API was developed by Cetin Sert in 2009.

    Windows code was contributed by Eugene Kirpichov in 2010.

    FreeBSD code was contributed by Finn Espen Gundersen on 2013-10-14.

    OS X code was contributed by Gerolf Seitz on 2013-10-15.

    Derived @Generic@, @Typeable@ and other instances for @Clock@ and @TimeSpec@ was contributed by Mathieu Boespflug on 2014-09-17.

    Corrected dependency listing for @GHC < 7.6@ was contributed by Brian McKenna on 2014-09-30.

    Windows code corrected by Dimitri Sabadie on 2015-02-09.

    Added @timeSpecAsNanoSecs@ as observed widely-used by Chris Done on 2015-01-06, exported correctly on 2015-04-20.

    Imported Control.Applicative operators correctly for Haskell Platform on Windows on 2015-04-21.

    Unit tests and instance fixes by Christian Burger on 2015-06-25.

    Removal of fromInteger : Integer -> TimeSpec by Cetin Sert on 2015-12-15.

    New Linux-specific Clocks: MonotonicRaw, Boottime, MonotonicCoarse, RealtimeCoarse by Cetin Sert on 2015-12-15.

    Reintroduction fromInteger : Integer -> TimeSpec by Cetin Sert on 2016-04-05.

    Fixes for older Linux build failures introduced by new Linux-specific clocks by Mario Longobardi on 2016-04-18.

    Refreshment release in 2019-04 after numerous contributions.

    Refactoring for Windows, Mac implementation consistence by Alexander Vershilov on 2021-01-16.

    [Version Scheme]
    Major-@/R/@-ewrite . New-@/F/@-unctionality . @/I/@-mprovementAndBugFixes . @/P/@-ackagingOnly

    * @PackagingOnly@ changes are made for quality assurance reasons.

category:             System
abi:                  7e534732b97c0b53641dcb7ba02cd444
exposed:              True
exposed-modules:      System.Clock System.Clock.Seconds
import-dirs:          /usr/lib/ghc-9.6.6/site-local/clock-0.8.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/clock-0.8.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/clock-0.8.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clock
hs-libraries:         HSclock-0.8.4-IWGGiWVRGO6DvoMHIcmZzf
depends:              base-4.18.2.1
haddock-interfaces:   /usr/share/doc/haskell-clock/html/clock.haddock
haddock-html:         /usr/share/doc/haskell-clock/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

