#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 doctest
version:              0.22.0
visibility:           public
id:                   doctest-0.22.0-2jUNU5dBXjB2qTFukz3bUX
key:                  doctest-0.22.0-2jUNU5dBXjB2qTFukz3bUX
license:              MIT
copyright:            (c) 2009-2023 Simon Hengel
maintainer:           Simon Hengel <sol@typeful.net>
author:               Simon Hengel <sol@typeful.net>
homepage:             https://github.com/sol/doctest#readme
synopsis:             Test interactive Haskell examples
description:
    `doctest` is a tool that checks [examples](https://www.haskell.org/haddock/doc/html/ch03s08.html#idm140354810775744)
    and [properties](https://www.haskell.org/haddock/doc/html/ch03s08.html#idm140354810771856)
    in Haddock comments.
    It is similar in spirit to the [popular Python module with the same name](https://docs.python.org/3/library/doctest.html).

    Documentation is at <https://github.com/sol/doctest#readme>.

category:             Testing
abi:                  99995794ff984854b11826fecf341dd4
exposed:              True
exposed-modules:
    Test.DocTest Test.DocTest.Internal.Extract
    Test.DocTest.Internal.Location Test.DocTest.Internal.Parse
    Test.DocTest.Internal.Run

hidden-modules:
    Extract GhcUtil Info Interpreter Language.Haskell.GhciWrapper
    Location Options PackageDBs Parse Property Run Runner
    Runner.Example Util Paths_doctest

import-dirs:          /usr/lib/ghc-9.4.8/site-local/doctest-0.22.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/doctest-0.22.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/doctest-0.22.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-doctest
hs-libraries:         HSdoctest-0.22.0-2jUNU5dBXjB2qTFukz3bUX
depends:
    base-4.17.2.1 base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp
    code-page-0.2.1-LeQPy5FeQvS92HSQRBnpzj deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2 ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj process-1.6.18.0
    syb-0.7.2.4-CLsCb1U1DGkGwwvmeMNNEv transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-doctest/html/doctest.haddock
haddock-html:         /usr/share/doc/haskell-doctest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

