#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 double-conversion
version:              2.0.5.0
visibility:           public
id:                   double-conversion-2.0.5.0-HKSWgSoAVAVEOWoLved2Y3
key:                  double-conversion-2.0.5.0-HKSWgSoAVAVEOWoLved2Y3
license:              BSD-2-Clause
maintainer:           Bryan O'\''Sullivan <bos@serpentine.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/double-conversion
synopsis:
    Fast conversion between single and double precision floating point and text

description:
    A library that performs fast, accurate conversion between
    floating point and text.

    This library is implemented as bindings to the C++
    @double-conversion@ library written by Florian Loitsch at Google:
    <https://github.com/floitsch/double-conversion>.

    Now it can convert single precision numbers, and also it can create
    Builder, instead of bytestring or text.

    The '\''Text'\'' versions of these functions are about 30 times faster
    than the default '\''show'\'' implementation for the '\''Double'\'' type.

    The '\''ByteString'\'' versions are have very close speed to the '\''Text'\'' versions;

    Builder versions (both for Text and Bytestring) are slower on single value,
    but they are much faster on large number of values
    (up to 20x faster on list with 20000 doubles).

    As a final note, be aware that the @bytestring-show@ package is
    about 50% slower than simply using '\''show'\''.

category:             Text
abi:                  eb8a02f2f9596ed113492198cac89ae8
exposed:              True
exposed-modules:
    Data.Double.Conversion.ByteString
    Data.Double.Conversion.Convertable Data.Double.Conversion.Text

hidden-modules:
    Data.Double.Conversion.Internal.FFI
    Data.Double.Conversion.Internal.ByteString
    Data.Double.Conversion.Internal.ByteStringBuilder
    Data.Double.Conversion.Internal.Text
    Data.Double.Conversion.Internal.TextBuilder

import-dirs:          /usr/lib/ghc-9.4.8/site-local/double-conversion-2.0.5.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/double-conversion-2.0.5.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/double-conversion-2.0.5.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-double-conversion
hs-libraries:         HSdouble-conversion-2.0.5.0-HKSWgSoAVAVEOWoLved2Y3
extra-libraries:      double-conversion
depends:
    base-4.17.2.1 bytestring-0.11.5.3 ghc-prim-0.9.1
    system-cxx-std-lib-1.0 text-2.0.2

haddock-interfaces:
    /usr/share/doc/haskell-double-conversion/html/double-conversion.haddock

haddock-html:         /usr/share/doc/haskell-double-conversion/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

