#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 fclabels
version:              2.0.5.1
visibility:           public
id:                   fclabels-2.0.5.1-1ubsfuJlIfz67sBYFHYIMw
key:                  fclabels-2.0.5.1-1ubsfuJlIfz67sBYFHYIMw
license:              BSD-3-Clause
maintainer:           Sebastiaan Visser <code@fvisser.nl>
author:
    Sebastiaan Visser, Erik Hesselink, Chris Eidhof, Sjoerd Visscher
    with lots of help and feedback from others.

homepage:             https://github.com/sebastiaanvisser/fclabels
synopsis:             First class accessor labels implemented as lenses.
description:
    This package provides first class labels that can act as
    bidirectional record fields. The labels can be derived
    automatically using Template Haskell which means you don'\''t have
    to write any boilerplate yourself. The labels are implemented as
    /lenses/ and are fully composable. Lenses can be used to /get/,
    /set/ and /modify/ parts of a data type in a consistent way.

    See "Data.Label" for an introductory explanation or see the
    introductory blog post at
    <http://fvisser.nl/post/2013/okt/1/fclabels-2.0.html>

    * /Total and partial lenses/

    Internally lenses do not used Haskell functions directly, but
    are implemented as categories. Categories allow the lenses to be
    run in custom computational contexts. This approach allows us to
    make partial lenses that point to fields of multi-constructor
    datatypes in an elegant way.

    See "Data.Label.Partial" for the use of partial labels.

    * /Monomorphic and polymorphic lenses/

    We have both polymorphic and monomorphic lenses. Polymorphic
    lenses allow updates that change the type. The types of
    polymorphic lenses are slightly more verbose than their
    monomorphic counterparts, but their usage is similar. Because
    monomorphic lenses are built by restricting the types of
    polymorphic lenses they are essentially the same and can be
    freely composed with eachother.

    See "Data.Label.Mono" and "Data.Label.Poly" for the difference
    between polymorphic and monomorphic lenses.

    * /Using fclabels/

    To simplify working with labels we supply both a set of labels
    for Haskell'\''s base types, like lists, tuples, Maybe and Either,
    and we supply a set of combinators for working with labels for
    values in the Reader and State monad.

    See "Data.Label.Base" and "Data.Label.Monadic" for more
    information.

    * /Changelog from 2.0.4 to 2.0.5/

    >   - Support for GHC 8.10. Thanks to Potato Hatsue.

category:             Data, Lenses
abi:                  e658e56bda56bece986f58fbd64d8978
exposed:              True
exposed-modules:
    Data.Label Data.Label.Base Data.Label.Derive Data.Label.Failing
    Data.Label.Monadic Data.Label.Mono Data.Label.Partial
    Data.Label.Point Data.Label.Poly Data.Label.Total

import-dirs:          /usr/lib/ghc-9.4.8/site-local/fclabels-2.0.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/fclabels-2.0.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/fclabels-2.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-fclabels
hs-libraries:         HSfclabels-2.0.5.1-1ubsfuJlIfz67sBYFHYIMw
depends:
    base-4.17.2.1 base-orphans-0.9.3-Ay3ak0BXuFSKZ70cVXGyQ mtl-2.2.2
    template-haskell-2.19.0.0 transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-fclabels/html/fclabels.haddock
haddock-html:         /usr/share/doc/haskell-fclabels/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

