#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 filepath-bytestring
version:              1.4.2.1.13
visibility:           public
id:                   filepath-bytestring-1.4.2.1.13-CT40hor99XqKNlCv6egq2t
key:                  filepath-bytestring-1.4.2.1.13-CT40hor99XqKNlCv6egq2t
license:              BSD-3-Clause
copyright:
    Neil Mitchell 2005-2019
    Joey Hess 2019-2021

maintainer:           Joey Hess <id@joeyh.name>
author:               Neil Mitchell <ndmitchell@gmail.com>
synopsis:
    Library for manipulating RawFilePaths in a cross platform way.

description:
    This package provides functionality for manipulating @RawFilePath@
    values. It can be used as a drop in replacement for the filepath library
    to get the benefits of using ByteStrings. It provides three modules:

    * "System.FilePath.Posix.ByteString" manipulates POSIX\/Linux style @RawFilePath@ values (with @\/@ as the path separator).

    * "System.FilePath.Windows.ByteString" manipulates Windows style @RawFilePath@ values (with either @\\@ or @\/@ as the path separator, and deals with drives).

    * "System.FilePath.ByteString" is an alias for the module appropriate to your platform.

    All three modules provide the same API, and the same documentation (calling out differences in the different variants).

    This package is now deprecated, since filepath 1.4.100.0 provides an
    OsPath type that is based on a bytestring. See
    https://hasufell.github.io/posts/2022-06-29-fixing-haskell-filepaths.html

category:             System
abi:                  14a288a47023dd47674ee5c378ae6c2c
exposed:              True
exposed-modules:
    System.FilePath.ByteString System.FilePath.Posix.ByteString
    System.FilePath.Windows.ByteString

import-dirs:
    /usr/lib/ghc-9.4.8/site-local/filepath-bytestring-1.4.2.1.13

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/filepath-bytestring-1.4.2.1.13

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/filepath-bytestring-1.4.2.1.13

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-filepath-bytestring
hs-libraries:         HSfilepath-bytestring-1.4.2.1.13-CT40hor99XqKNlCv6egq2t
depends:              base-4.17.2.1 bytestring-0.11.5.3 unix-2.7.3
haddock-interfaces:
    /usr/share/doc/haskell-filepath-bytestring/html/filepath-bytestring.haddock

haddock-html:         /usr/share/doc/haskell-filepath-bytestring/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

