"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregateFunction = void 0;
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class AggregateFunction extends _node.PPLNode {
  constructor(name, children, statsFunctionName, valueExpression, percentileAggFunction) {
    super(name, children);
    this.statsFunctionName = statsFunctionName;
    this.valueExpression = valueExpression;
    this.percentileAggFunction = percentileAggFunction;
  }
  getTokens() {
    return {
      name: this.statsFunctionName,
      value_expression: this.valueExpression,
      percentile_agg_function: this.percentileAggFunction
    };
  }
  toString() {
    if (this.statsFunctionName && this.valueExpression) {
      return `${this.statsFunctionName}(${this.valueExpression})`;
    } else if (this.statsFunctionName) {
      return `${this.statsFunctionName}()`;
    } else if (this.percentileAggFunction) {
      return `${this.percentileAggFunction}`;
    }
    return '';
  }
}
exports.AggregateFunction = AggregateFunction;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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