\name{IsolatedWatershedImageFilter}
\alias{IsolatedWatershedImageFilter}
\title{IsolatedWatershedImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Isolate watershed basins using two seeds.
IsolatedWatershedImageFilter}
\details{
IsolatedWatershedImageFilter labels pixels with ReplaceValue1 that are in the same watershed basin
as Seed1 AND NOT the same as Seed2. The filter adjusts the waterlevel
until the two seeds are not in different basins. The user supplies a
Watershed threshold. The algorithm uses a binary search to adjust the
upper waterlevel, starting at UpperValueLimit. UpperValueLimit
defaults to the 1.0.
See:
IsolatedWatershed for the procedural interface
itk::IsolatedWatershedImageFilter for the Doxygen on the original ITK class.
IsolatedWatershedImageFilter}
%C++ includes: sitkIsolatedWatershedImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetIsolatedValueTolerance() const:}{
Set/Get the precision required for the intensity threshold value. The
default is .001.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint8_t GetReplaceValue1() const:}{
Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).
}
\item{uint8_t GetReplaceValue2() const:}{
Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).
}
\item{std::vector< uint32_t > GetSeed1() const:}{
Set seed point 1. This seed will be isolated from Seed2 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue1.
}
\item{std::vector< uint32_t > GetSeed2() const:}{
Set seed point 2. This seed will be isolated from Seed1 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue2.
}
\item{double GetThreshold() const:}{
Set/Get the Watershed threshold. The default is 0.
}
\item{double GetUpperValueLimit() const:}{
Set/Get the limit on the upper waterlevel value. The default is 1.0.
}
\item{ IsolatedWatershedImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetIsolatedValueTolerance(double IsolatedValueTolerance):}{
Set/Get the precision required for the intensity threshold value. The
default is .001.
}
\item{Self SetReplaceValue1(uint8_t ReplaceValue1):}{
Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).
}
\item{Self SetReplaceValue2(uint8_t ReplaceValue2):}{
Set/Get value to replace Seed1(Seed2) pixels, pixels that are within
the basin that contains Seed1(Seed2) this value. The default is 1(0).
}
\item{Self SetSeed1(std::vector< uint32_t > Seed1):}{
Set seed point 1. This seed will be isolated from Seed2 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue1.
}
\item{Self SetSeed2(std::vector< uint32_t > Seed2):}{
Set seed point 2. This seed will be isolated from Seed1 (if possible).
All pixels connected to this seed will be replaced with ReplaceValue2.
}
\item{Self SetThreshold(double Threshold):}{
Set/Get the Watershed threshold. The default is 0.
}
\item{Self SetUpperValueLimit(double UpperValueLimit):}{
Set/Get the limit on the upper waterlevel value. The default is 1.0.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~IsolatedWatershedImageFilter():}{
Destructor
}
}
}
