/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.core;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import xsbt.boot.internal.shaded.coursier.core.Authentication$;

public final class Authentication
implements Serializable,
Product {
    private final String user;
    private final Option<String> passwordOpt;
    private final Seq<Tuple2<String, String>> httpHeaders;
    private final boolean optional;
    private final Option<String> realmOpt;
    private final boolean httpsOnly;
    private final boolean passOnRedirect;

    @Override
    public final Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public final String user() {
        return this.user;
    }

    public final Option<String> passwordOpt() {
        return this.passwordOpt;
    }

    public final Seq<Tuple2<String, String>> httpHeaders() {
        return this.httpHeaders;
    }

    public final boolean optional() {
        return this.optional;
    }

    public final Option<String> realmOpt() {
        return this.realmOpt;
    }

    public final boolean httpsOnly() {
        return this.httpsOnly;
    }

    public final boolean passOnRedirect() {
        return this.passOnRedirect;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        Seq headersStr = (Seq)this.httpHeaders().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            String string;
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                return new Tuple2<Object, String>(string, "****");
            }
            throw new MatchError((Object)string);
        });
        return new StringBuilder(32).append("Authentication(").append(this.user()).append(", ****, ").append(var1_1).append(", ").append(this.optional()).append(", ").append(this.realmOpt()).append(", ").append(this.httpsOnly()).append(", ").append(this.passOnRedirect()).append(")").toString();
    }

    public final boolean userOnly() {
        Authentication authentication = Authentication$.MODULE$.apply(this.user());
        return ((Object)this).equals(authentication);
    }

    public final Seq<Tuple2<String, String>> allHttpHeaders() {
        Seq seq = (Seq)Option$.MODULE$.option2Iterable(this.passwordOpt()).toSeq().map((Function1<String, Tuple2> & Serializable)p -> {
            void var1_1;
            Authentication authentication;
            return new Tuple2<String, String>("Authorization", new StringBuilder(6).append("Basic ").append(Authentication$.MODULE$.basicAuthenticationEncode(authentication.user(), (String)var1_1)).toString());
        });
        return (Seq)seq.$plus$plus(this.httpHeaders());
    }

    /*
     * WARNING - void declaration
     */
    public final Authentication withOptional(boolean optional) {
        void var1_1;
        return new Authentication(this.user(), this.passwordOpt(), this.httpHeaders(), (boolean)var1_1, this.realmOpt(), this.httpsOnly(), this.passOnRedirect());
    }

    /*
     * WARNING - void declaration
     */
    public final Authentication withHttpsOnly(boolean httpsOnly) {
        void var1_1;
        return new Authentication(this.user(), this.passwordOpt(), this.httpHeaders(), this.optional(), this.realmOpt(), (boolean)var1_1, this.passOnRedirect());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canEqual(Object obj) {
        void var1_1;
        return obj != null && var1_1 instanceof Authentication;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        block3: {
            block2: {
                void var1_1;
                if (this == obj) break block2;
                if (!this.canEqual(obj)) break block3;
                Authentication other = (Authentication)obj;
                String string = this.user();
                IterableOnce<Object> iterableOnce = other.user();
                if (string != null ? !string.equals(iterableOnce) : iterableOnce != null) break block3;
                Option<String> option = this.passwordOpt();
                iterableOnce = other.passwordOpt();
                if (option != null ? !option.equals(iterableOnce) : iterableOnce != null) break block3;
                Seq<Tuple2<String, String>> seq = this.httpHeaders();
                iterableOnce = other.httpHeaders();
                if ((seq != null ? !seq.equals(iterableOnce) : iterableOnce != null) || this.optional() != other.optional()) break block3;
                Option<String> option2 = this.realmOpt();
                iterableOnce = other.realmOpt();
                if (option2 != null ? !option2.equals(iterableOnce) : iterableOnce != null) break block3;
                if (this.httpsOnly() != other.httpsOnly() || this.passOnRedirect() != var1_1.passOnRedirect()) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int code = 17 + Statics.anyHash("Authentication");
        code = code * 37 + Statics.anyHash(this.user());
        code = code * 37 + Statics.anyHash(this.passwordOpt());
        code = code * 37 + Statics.anyHash(this.httpHeaders());
        code = code * 37 + (this.optional() ? 1231 : 1237);
        code = code * 37 + Statics.anyHash(this.realmOpt());
        code = code * 37 + (this.httpsOnly() ? 1231 : 1237);
        code = code * 37 + (this.passOnRedirect() ? 1231 : 1237);
        return (int)(var1_1 * 37);
    }

    @Override
    public final String productPrefix() {
        return "Authentication";
    }

    @Override
    public final int productArity() {
        return 7;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object productElement(int n) {
        void var1_1;
        switch (n) {
            case 0: {
                return this.user();
            }
            case 1: {
                return this.passwordOpt();
            }
            case 2: {
                return this.httpHeaders();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean(this.optional());
            }
            case 4: {
                return this.realmOpt();
            }
            case 5: {
                return BoxesRunTime.boxToBoolean(this.httpsOnly());
            }
            case 6: {
                return BoxesRunTime.boxToBoolean(this.passOnRedirect());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Authentication(String user, Option<String> passwordOpt, Seq<Tuple2<String, String>> httpHeaders, boolean optional, Option<String> realmOpt, boolean httpsOnly, boolean passOnRedirect) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.user = var1_1;
        this.passwordOpt = var2_2;
        this.httpHeaders = var3_3;
        this.optional = optional;
        this.realmOpt = realmOpt;
        this.httpsOnly = httpsOnly;
        this.passOnRedirect = passOnRedirect;
        Product.$init$(this);
    }
}

