=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::SlidesApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeSlidesCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my %params = @_;
    my $api_client = AsposeSlidesCloud::ApiClient->new(@_);

    bless { api_client => $api_client }, $class;
}


#
# align_shapes
#
# Changes the placement of selected shapes on the slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $alignment_type Alignment type that will be applied to the shapes. (required)
# @param boolean $align_to_slide If true, shapes will be aligned relative to the slide edges. (optional, default to false)
# @param int[] $shapes Shapes indexes. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'alignment_type' => {
        data_type => 'string',
        description => 'Alignment type that will be applied to the shapes.',
        required => '1',
    },
    'align_to_slide' => {
        data_type => 'boolean',
        description => 'If true, shapes will be aligned relative to the slide edges.',
        required => '0',
    },
    'shapes' => {
        data_type => 'int[]',
        description => 'Shapes indexes.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'align_shapes' } = { 
    	summary => 'Changes the placement of selected shapes on the slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub align_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling align_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling align_shapes");
    }

    # verify the required parameter 'alignment_type' is set
    unless (exists $args{'alignment_type'} && defined $args{'alignment_type'} && $args{'alignment_type'}) {
      croak("Missing the required parameter 'alignment_type' when calling align_shapes");
    }

    # verify enum value
    if (!grep(/^$args{'alignment_type'}$/i, ( 'AlignLeft', 'AlignRight', 'AlignCenter', 'AlignTop', 'AlignMiddle', 'AlignBottom', 'DistributeHorizontally', 'DistributeVertically' ))) {
      croak("Invalid value for 'alignment_type': " . $args{'alignment_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/align/{alignmentType}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'align_to_slide'} && defined $args{'align_to_slide'}) {
        $query_params->{'alignToSlide'} = $self->{api_client}->to_boolean_query_value($args{'align_to_slide'});
    }

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'alignment_type'}) {
        my $_base_variable = "{" . "alignmentType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'alignment_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# align_special_slide_shapes
#
# Changes the placement of selected shapes on the master slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param string $alignment_type Alignment type that will be applied to the shapes. (required)
# @param boolean $align_to_slide If true, shapes will be aligned relative to the slide edges. (optional, default to false)
# @param int[] $shapes Shapes indexes. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'alignment_type' => {
        data_type => 'string',
        description => 'Alignment type that will be applied to the shapes.',
        required => '1',
    },
    'align_to_slide' => {
        data_type => 'boolean',
        description => 'If true, shapes will be aligned relative to the slide edges.',
        required => '0',
    },
    'shapes' => {
        data_type => 'int[]',
        description => 'Shapes indexes.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'align_special_slide_shapes' } = { 
    	summary => 'Changes the placement of selected shapes on the master slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub align_special_slide_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling align_special_slide_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling align_special_slide_shapes");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling align_special_slide_shapes");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'alignment_type' is set
    unless (exists $args{'alignment_type'} && defined $args{'alignment_type'} && $args{'alignment_type'}) {
      croak("Missing the required parameter 'alignment_type' when calling align_special_slide_shapes");
    }

    # verify enum value
    if (!grep(/^$args{'alignment_type'}$/i, ( 'AlignLeft', 'AlignRight', 'AlignCenter', 'AlignTop', 'AlignMiddle', 'AlignBottom', 'DistributeHorizontally', 'DistributeVertically' ))) {
      croak("Invalid value for 'alignment_type': " . $args{'alignment_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/align/{alignmentType}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'align_to_slide'} && defined $args{'align_to_slide'}) {
        $query_params->{'alignToSlide'} = $self->{api_client}->to_boolean_query_value($args{'align_to_slide'});
    }

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'alignment_type'}) {
        my $_base_variable = "{" . "alignmentType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'alignment_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# compress_embedded_fonts
#
# Compresses embedded fonts by removing unused characters.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'compress_embedded_fonts' } = { 
    	summary => 'Compresses embedded fonts by removing unused characters.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub compress_embedded_fonts {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling compress_embedded_fonts");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fonts/embedded/compress';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# compress_embedded_fonts_online
#
# Compresses embedded fonts by removing unused characters.
# 
# @param File $document Document data. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'compress_embedded_fonts_online' } = { 
    	summary => 'Compresses embedded fonts by removing unused characters.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub compress_embedded_fonts_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling compress_embedded_fonts_online");
    }

    # parse inputs
    my $_resource_path = '/slides/fonts/embedded/compress';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# compress_image
#
# Deletes cropped areas of a pictire.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must refer to a picture frame). (required)
# @param double $resolution Target resolution in DPI. (optional)
# @param boolean $delete_picture_cropped_areas true to delete picture cropped areas. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Presentation storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must refer to a picture frame).',
        required => '1',
    },
    'resolution' => {
        data_type => 'double',
        description => 'Target resolution in DPI.',
        required => '0',
    },
    'delete_picture_cropped_areas' => {
        data_type => 'boolean',
        description => 'true to delete picture cropped areas.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'compress_image' } = { 
    	summary => 'Deletes cropped areas of a pictire.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub compress_image {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling compress_image");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling compress_image");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling compress_image");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/compressImage';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'resolution'} && defined $args{'resolution'}) {
        $query_params->{'resolution'} = $self->{api_client}->to_query_value($args{'resolution'});
    }

    # query params
    if (exists $args{'delete_picture_cropped_areas'} && defined $args{'delete_picture_cropped_areas'}) {
        $query_params->{'deletePictureCroppedAreas'} = $self->{api_client}->to_boolean_query_value($args{'delete_picture_cropped_areas'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# convert
#
# Convert presentation from request content to format specified.
# 
# @param File $document Document data. (required)
# @param string $format Export format. (required)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
# @param int[] $slides The indices of the slides to be converted. If not specified, all slides are converted by default. (optional)
# @param ExportOptions $options Export options. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    'slides' => {
        data_type => 'int[]',
        description => 'The indices of the slides to be converted. If not specified, all slides are converted by default.',
        required => '0',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'convert' } = { 
    	summary => 'Convert presentation from request content to format specified.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub convert {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling convert");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling convert");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Pdf', 'Xps', 'Tiff', 'Pptx', 'Odp', 'Otp', 'Ppt', 'Pps', 'Ppsx', 'Pptm', 'Ppsm', 'Pot', 'Potx', 'Potm', 'Html', 'Html5', 'Swf', 'Svg', 'Jpeg', 'Png', 'Gif', 'Bmp', 'Fodp', 'Xaml', 'Mpeg4', 'Md', 'Xml' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/convert/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # query params
    if (exists $args{'slides'} && defined $args{'slides'}) {
        $query_params->{'slides'} = $self->{api_client}->to_query_value($args{'slides'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# convert_and_save
#
# Convert presentation from request content to format specified.
# 
# @param File $document Document data. (required)
# @param string $format Export format. (required)
# @param string $out_path Path to save result. (required)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
# @param int[] $slides The indices of the slides to be converted. If not specified, all slides are converted by default. (optional)
# @param ExportOptions $options Export options. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    'slides' => {
        data_type => 'int[]',
        description => 'The indices of the slides to be converted. If not specified, all slides are converted by default.',
        required => '0',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'convert_and_save' } = { 
    	summary => 'Convert presentation from request content to format specified.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub convert_and_save {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling convert_and_save");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling convert_and_save");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Pdf', 'Xps', 'Tiff', 'Pptx', 'Odp', 'Otp', 'Ppt', 'Pps', 'Ppsx', 'Pptm', 'Ppsm', 'Pot', 'Potx', 'Potm', 'Html', 'Html5', 'Swf', 'Svg', 'Jpeg', 'Png', 'Gif', 'Bmp', 'Fodp', 'Xaml', 'Mpeg4', 'Md', 'Xml' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && defined $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling convert_and_save");
    }

    # parse inputs
    my $_resource_path = '/slides/convert/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # query params
    if (exists $args{'slides'} && defined $args{'slides'}) {
        $query_params->{'slides'} = $self->{api_client}->to_query_value($args{'slides'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# copy_file
#
# Copy file
# 
# @param string $src_path Source file path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $dest_path Destination file path (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
# @param string $version_id File version ID to copy (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source file path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination file path',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to copy',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_file' } = { 
    	summary => 'Copy file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub copy_file {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'} && defined $args{'src_path'} && $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling copy_file");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'} && defined $args{'dest_path'} && $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling copy_file");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/file/copy/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'dest_path'} && defined $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if (exists $args{'src_storage_name'} && defined $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if (exists $args{'dest_storage_name'} && defined $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# copy_folder
#
# Copy folder
# 
# @param string $src_path Source folder path e.g. &#39;/src&#39; (required)
# @param string $dest_path Destination folder path e.g. &#39;/dst&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source folder path e.g. &#39;/src&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination folder path e.g. &#39;/dst&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_folder' } = { 
    	summary => 'Copy folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub copy_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'} && defined $args{'src_path'} && $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling copy_folder");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'} && defined $args{'dest_path'} && $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling copy_folder");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/copy/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'dest_path'} && defined $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if (exists $args{'src_storage_name'} && defined $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if (exists $args{'dest_storage_name'} && defined $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# copy_layout_slide
#
# Copy layoutSlide from source presentation.
# 
# @param string $name Document name. (required)
# @param string $clone_from Name of the document to clone layoutSlide from. (required)
# @param int $clone_from_position Position of cloned layout slide. (required)
# @param string $clone_from_password Password for the document to clone layoutSlide from. (optional)
# @param string $clone_from_storage Storage of the document to clone layoutSlide from. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'clone_from' => {
        data_type => 'string',
        description => 'Name of the document to clone layoutSlide from.',
        required => '1',
    },
    'clone_from_position' => {
        data_type => 'int',
        description => 'Position of cloned layout slide.',
        required => '1',
    },
    'clone_from_password' => {
        data_type => 'string',
        description => 'Password for the document to clone layoutSlide from.',
        required => '0',
    },
    'clone_from_storage' => {
        data_type => 'string',
        description => 'Storage of the document to clone layoutSlide from.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_layout_slide' } = { 
    	summary => 'Copy layoutSlide from source presentation.',
        params => $params,
        returns => 'LayoutSlide',
        };
}
# @return LayoutSlide
#
sub copy_layout_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling copy_layout_slide");
    }

    # verify the required parameter 'clone_from' is set
    unless (exists $args{'clone_from'} && defined $args{'clone_from'} && $args{'clone_from'}) {
      croak("Missing the required parameter 'clone_from' when calling copy_layout_slide");
    }

    # verify the required parameter 'clone_from_position' is set
    unless (exists $args{'clone_from_position'} && defined $args{'clone_from_position'}) {
      croak("Missing the required parameter 'clone_from_position' when calling copy_layout_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/layoutSlides';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'clone_from'} && defined $args{'clone_from'}) {
        $query_params->{'cloneFrom'} = $self->{api_client}->to_query_value($args{'clone_from'});
    }

    # query params
    if (exists $args{'clone_from_position'} && defined $args{'clone_from_position'}) {
        $query_params->{'cloneFromPosition'} = $self->{api_client}->to_query_value($args{'clone_from_position'});
    }

    # query params
    if (exists $args{'clone_from_storage'} && defined $args{'clone_from_storage'}) {
        $query_params->{'cloneFromStorage'} = $self->{api_client}->to_query_value($args{'clone_from_storage'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'clone_from_password'}) {
        $header_params->{':cloneFromPassword'} = $self->{api_client}->to_header_value($args{'clone_from_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LayoutSlide', $response);
    return $_response_object;
}

#
# copy_master_slide
#
# Copy masterSlide from source presentation.
# 
# @param string $name Document name. (required)
# @param string $clone_from Name of the document to clone masterSlide from. (required)
# @param int $clone_from_position Position of cloned master slide. (required)
# @param string $clone_from_password Password for the document to clone masterSlide from. (optional)
# @param string $clone_from_storage Storage of the document to clone masterSlide from. (optional)
# @param boolean $apply_to_all True to apply cloned master slide to every existing slide. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'clone_from' => {
        data_type => 'string',
        description => 'Name of the document to clone masterSlide from.',
        required => '1',
    },
    'clone_from_position' => {
        data_type => 'int',
        description => 'Position of cloned master slide.',
        required => '1',
    },
    'clone_from_password' => {
        data_type => 'string',
        description => 'Password for the document to clone masterSlide from.',
        required => '0',
    },
    'clone_from_storage' => {
        data_type => 'string',
        description => 'Storage of the document to clone masterSlide from.',
        required => '0',
    },
    'apply_to_all' => {
        data_type => 'boolean',
        description => 'True to apply cloned master slide to every existing slide.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_master_slide' } = { 
    	summary => 'Copy masterSlide from source presentation.',
        params => $params,
        returns => 'MasterSlide',
        };
}
# @return MasterSlide
#
sub copy_master_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling copy_master_slide");
    }

    # verify the required parameter 'clone_from' is set
    unless (exists $args{'clone_from'} && defined $args{'clone_from'} && $args{'clone_from'}) {
      croak("Missing the required parameter 'clone_from' when calling copy_master_slide");
    }

    # verify the required parameter 'clone_from_position' is set
    unless (exists $args{'clone_from_position'} && defined $args{'clone_from_position'}) {
      croak("Missing the required parameter 'clone_from_position' when calling copy_master_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/masterSlides';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'clone_from'} && defined $args{'clone_from'}) {
        $query_params->{'cloneFrom'} = $self->{api_client}->to_query_value($args{'clone_from'});
    }

    # query params
    if (exists $args{'clone_from_position'} && defined $args{'clone_from_position'}) {
        $query_params->{'cloneFromPosition'} = $self->{api_client}->to_query_value($args{'clone_from_position'});
    }

    # query params
    if (exists $args{'clone_from_storage'} && defined $args{'clone_from_storage'}) {
        $query_params->{'cloneFromStorage'} = $self->{api_client}->to_query_value($args{'clone_from_storage'});
    }

    # query params
    if (exists $args{'apply_to_all'} && defined $args{'apply_to_all'}) {
        $query_params->{'applyToAll'} = $self->{api_client}->to_boolean_query_value($args{'apply_to_all'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'clone_from_password'}) {
        $header_params->{':cloneFromPassword'} = $self->{api_client}->to_header_value($args{'clone_from_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MasterSlide', $response);
    return $_response_object;
}

#
# copy_slide
#
# Copy a slide from the current or another presentation.
# 
# @param string $name Document name. (required)
# @param int $slide_to_copy The index of the slide to be copied from the source presentation. (required)
# @param int $position The target position at which to copy the slide. Copy to the end by default. (optional)
# @param string $source Name of the document to copy a slide from. (optional)
# @param string $source_password Password for the document to copy a slide from. (optional)
# @param string $source_storage Template storage name. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_to_copy' => {
        data_type => 'int',
        description => 'The index of the slide to be copied from the source presentation.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'The target position at which to copy the slide. Copy to the end by default.',
        required => '0',
    },
    'source' => {
        data_type => 'string',
        description => 'Name of the document to copy a slide from.',
        required => '0',
    },
    'source_password' => {
        data_type => 'string',
        description => 'Password for the document to copy a slide from.',
        required => '0',
    },
    'source_storage' => {
        data_type => 'string',
        description => 'Template storage name.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_slide' } = { 
    	summary => 'Copy a slide from the current or another presentation.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub copy_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling copy_slide");
    }

    # verify the required parameter 'slide_to_copy' is set
    unless (exists $args{'slide_to_copy'} && defined $args{'slide_to_copy'}) {
      croak("Missing the required parameter 'slide_to_copy' when calling copy_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/copy';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'slide_to_copy'} && defined $args{'slide_to_copy'}) {
        $query_params->{'slideToCopy'} = $self->{api_client}->to_query_value($args{'slide_to_copy'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'source'} && defined $args{'source'}) {
        $query_params->{'source'} = $self->{api_client}->to_query_value($args{'source'});
    }

    # query params
    if (exists $args{'source_storage'} && defined $args{'source_storage'}) {
        $query_params->{'sourceStorage'} = $self->{api_client}->to_query_value($args{'source_storage'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'source_password'}) {
        $header_params->{':sourcePassword'} = $self->{api_client}->to_header_value($args{'source_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# create_animation_effect
#
# Add an effect to slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param Effect $effect Animation effect DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'effect' => {
        data_type => 'Effect',
        description => 'Animation effect DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_animation_effect' } = { 
    	summary => 'Add an effect to slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_animation_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_animation_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_animation_effect");
    }

    # verify the required parameter 'effect' is set
    unless (exists $args{'effect'} && defined $args{'effect'} && $args{'effect'}) {
      croak("Missing the required parameter 'effect' when calling create_animation_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/mainSequence';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'effect'} && $args{'effect'}) {
        $_body_data = $args{'effect'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# create_animation_interactive_sequence
#
# Set slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param InteractiveSequence $sequence Animation sequence DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence' => {
        data_type => 'InteractiveSequence',
        description => 'Animation sequence DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_animation_interactive_sequence' } = { 
    	summary => 'Set slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_animation_interactive_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_animation_interactive_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_animation_interactive_sequence");
    }

    # verify the required parameter 'sequence' is set
    unless (exists $args{'sequence'} && defined $args{'sequence'} && $args{'sequence'}) {
      croak("Missing the required parameter 'sequence' when calling create_animation_interactive_sequence");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'sequence'} && $args{'sequence'}) {
        $_body_data = $args{'sequence'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# create_animation_interactive_sequence_effect
#
# Add an animation effect to a slide interactive sequence.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index The position of the interactive sequence. (required)
# @param Effect $effect Animation effect DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'The position of the interactive sequence.',
        required => '1',
    },
    'effect' => {
        data_type => 'Effect',
        description => 'Animation effect DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_animation_interactive_sequence_effect' } = { 
    	summary => 'Add an animation effect to a slide interactive sequence.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_animation_interactive_sequence_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'} && defined $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling create_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'effect' is set
    unless (exists $args{'effect'} && defined $args{'effect'} && $args{'effect'}) {
      croak("Missing the required parameter 'effect' when calling create_animation_interactive_sequence_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'effect'} && $args{'effect'}) {
        $_body_data = $args{'effect'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# create_chart_category
#
# Add a new category to a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param ChartCategory $category Category DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'category' => {
        data_type => 'ChartCategory',
        description => 'Category DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_chart_category' } = { 
    	summary => 'Add a new category to a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub create_chart_category {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_chart_category");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_chart_category");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_chart_category");
    }

    # verify the required parameter 'category' is set
    unless (exists $args{'category'} && defined $args{'category'} && $args{'category'}) {
      croak("Missing the required parameter 'category' when calling create_chart_category");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'category'} && $args{'category'}) {
        $_body_data = $args{'category'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# create_chart_data_point
#
# Add a new data point to a chart series.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $series_index Series index. (required)
# @param DataPoint $data_point Data point DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'data_point' => {
        data_type => 'DataPoint',
        description => 'Data point DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_chart_data_point' } = { 
    	summary => 'Add a new data point to a chart series.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub create_chart_data_point {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_chart_data_point");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_chart_data_point");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_chart_data_point");
    }

    # verify the required parameter 'series_index' is set
    unless (exists $args{'series_index'} && defined $args{'series_index'}) {
      croak("Missing the required parameter 'series_index' when calling create_chart_data_point");
    }

    # verify the required parameter 'data_point' is set
    unless (exists $args{'data_point'} && defined $args{'data_point'} && $args{'data_point'}) {
      croak("Missing the required parameter 'data_point' when calling create_chart_data_point");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'series_index'}) {
        my $_base_variable = "{" . "seriesIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'series_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'data_point'} && $args{'data_point'}) {
        $_body_data = $args{'data_point'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# create_chart_series
#
# Add a new series to a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must be a chart). (required)
# @param Series $series Series DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must be a chart).',
        required => '1',
    },
    'series' => {
        data_type => 'Series',
        description => 'Series DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_chart_series' } = { 
    	summary => 'Add a new series to a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub create_chart_series {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_chart_series");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_chart_series");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_chart_series");
    }

    # verify the required parameter 'series' is set
    unless (exists $args{'series'} && defined $args{'series'} && $args{'series'}) {
      croak("Missing the required parameter 'series' when calling create_chart_series");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'series'} && $args{'series'}) {
        $_body_data = $args{'series'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# create_comment
#
# Adds the comment on the slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param SlideCommentBase $dto Comment DTO. (required)
# @param int $shape_index Shape index. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'SlideCommentBase',
        description => 'Comment DTO.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_comment' } = { 
    	summary => 'Adds the comment on the slide.',
        params => $params,
        returns => 'SlideComments',
        };
}
# @return SlideComments
#
sub create_comment {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_comment");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_comment");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_comment");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/comments';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_index'} && defined $args{'shape_index'}) {
        $query_params->{'shapeIndex'} = $self->{api_client}->to_query_value($args{'shape_index'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideComments', $response);
    return $_response_object;
}

#
# create_comment_online
#
# Adds the comment on the slide.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param SlideCommentBase $dto Comment DTO. (required)
# @param int $shape_index Shape index. (optional)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'SlideCommentBase',
        description => 'Comment DTO.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_comment_online' } = { 
    	summary => 'Adds the comment on the slide.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub create_comment_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling create_comment_online");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_comment_online");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_comment_online");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/comments';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'shape_index'} && defined $args{'shape_index'}) {
        $query_params->{'shapeIndex'} = $self->{api_client}->to_query_value($args{'shape_index'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# create_folder
#
# Create the folder
# 
# @param string $path Folder path to create e.g. &#39;folder_1/folder_2/&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path to create e.g. &#39;folder_1/folder_2/&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_folder' } = { 
    	summary => 'Create the folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub create_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && defined $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling create_folder");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/{path}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# create_image_watermark
#
# Adds an image watermark to each slide of the presentation.  Image can be provided as a part of the form or withing PictureFrame DTO for detailed customization. Both options are applicable simultaneously. 
# 
# @param string $name Document name. (required)
# @param File $image Image data. (optional)
# @param PictureFrame $picture_frame PictureFrame DTO (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'image' => {
        data_type => 'File',
        description => 'Image data.',
        required => '0',
    },
    'picture_frame' => {
        data_type => 'PictureFrame',
        description => 'PictureFrame DTO',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_image_watermark' } = { 
    	summary => 'Adds an image watermark to each slide of the presentation.  Image can be provided as a part of the form or withing PictureFrame DTO for detailed customization. Both options are applicable simultaneously. ',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub create_image_watermark {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_image_watermark");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/watermark/image';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'image'} && $args{'image'}) {
        push(@$files, $args{'image'});
    }
    # body params
    if ( exists $args{'picture_frame'} && $args{'picture_frame'}) {
        $_body_data = $args{'picture_frame'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# create_image_watermark_online
#
# Adds an image watermark to each slide of the presentation.  Image can be provided as a part of the form or withing PictureFrame DTO for detailed customization. Both options are applicable simultaneously. 
# 
# @param File $document Document data. (required)
# @param File $image Image data. (optional)
# @param PictureFrame $picture_frame PictureFrame DTO. (optional)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'image' => {
        data_type => 'File',
        description => 'Image data.',
        required => '0',
    },
    'picture_frame' => {
        data_type => 'PictureFrame',
        description => 'PictureFrame DTO.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_image_watermark_online' } = { 
    	summary => 'Adds an image watermark to each slide of the presentation.  Image can be provided as a part of the form or withing PictureFrame DTO for detailed customization. Both options are applicable simultaneously. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub create_image_watermark_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling create_image_watermark_online");
    }

    # parse inputs
    my $_resource_path = '/slides/watermark/image';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    if ( exists $args{'image'} && $args{'image'}) {
        push(@$files, $args{'image'});
    }
    # body params
    if ( exists $args{'picture_frame'} && $args{'picture_frame'}) {
        $_body_data = $args{'picture_frame'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# create_notes_slide
#
# Add new notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param NotesSlide $dto A NotesSlide object with notes slide data. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'NotesSlide',
        description => 'A NotesSlide object with notes slide data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_notes_slide' } = { 
    	summary => 'Add new notes slide.',
        params => $params,
        returns => 'NotesSlide',
        };
}
# @return NotesSlide
#
sub create_notes_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_notes_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_notes_slide");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_notes_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlide', $response);
    return $_response_object;
}

#
# create_paragraph
#
# Creates new paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param int $position Position of the new paragraph in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new paragraph in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_paragraph' } = { 
    	summary => 'Creates new paragraph.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub create_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_paragraph");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# create_portion
#
# Creates new portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param int $position Position of the new portion in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new portion in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_portion' } = { 
    	summary => 'Creates new portion.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub create_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling create_portion");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# create_presentation
#
# Create a presentation.
# 
# @param string $name Document name. (required)
# @param File $data Source presentation binary data. (optional)
# @param string $input_password The password for source presentation. (optional)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'data' => {
        data_type => 'File',
        description => 'Source presentation binary data.',
        required => '0',
    },
    'input_password' => {
        data_type => 'string',
        description => 'The password for source presentation.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_presentation' } = { 
    	summary => 'Create a presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub create_presentation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_presentation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'input_password'}) {
        $header_params->{':inputPassword'} = $self->{api_client}->to_header_value($args{'input_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'data'} && $args{'data'}) {
        push(@$files, $args{'data'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# create_presentation_from_source
#
# Create a presentation from an existing source.
# 
# @param string $name Document name. (required)
# @param string $source_path Source file path. (optional)
# @param string $source_password Source file password. (optional)
# @param string $source_storage Source storage name. (optional)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'source_path' => {
        data_type => 'string',
        description => 'Source file path.',
        required => '0',
    },
    'source_password' => {
        data_type => 'string',
        description => 'Source file password.',
        required => '0',
    },
    'source_storage' => {
        data_type => 'string',
        description => 'Source storage name.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_presentation_from_source' } = { 
    	summary => 'Create a presentation from an existing source.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub create_presentation_from_source {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_presentation_from_source");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fromSource';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'source_path'} && defined $args{'source_path'}) {
        $query_params->{'sourcePath'} = $self->{api_client}->to_query_value($args{'source_path'});
    }

    # query params
    if (exists $args{'source_storage'} && defined $args{'source_storage'}) {
        $query_params->{'sourceStorage'} = $self->{api_client}->to_query_value($args{'source_storage'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'source_password'}) {
        $header_params->{':sourcePassword'} = $self->{api_client}->to_header_value($args{'source_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# create_presentation_from_template
#
# Create a presentation.
# 
# @param string $name Document name. (required)
# @param string $template_path Template file path. (required)
# @param string $data Document input data. (optional)
# @param string $template_password Template file password. (optional)
# @param string $template_storage Template storage name. (optional)
# @param boolean $is_image_data_embedded True if image data is embedded. (optional, default to false)
# @param string $password The document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'template_path' => {
        data_type => 'string',
        description => 'Template file path.',
        required => '1',
    },
    'data' => {
        data_type => 'string',
        description => 'Document input data.',
        required => '0',
    },
    'template_password' => {
        data_type => 'string',
        description => 'Template file password.',
        required => '0',
    },
    'template_storage' => {
        data_type => 'string',
        description => 'Template storage name.',
        required => '0',
    },
    'is_image_data_embedded' => {
        data_type => 'boolean',
        description => 'True if image data is embedded.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_presentation_from_template' } = { 
    	summary => 'Create a presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub create_presentation_from_template {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_presentation_from_template");
    }

    # verify the required parameter 'template_path' is set
    unless (exists $args{'template_path'} && defined $args{'template_path'} && $args{'template_path'}) {
      croak("Missing the required parameter 'template_path' when calling create_presentation_from_template");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fromTemplate';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'template_path'} && defined $args{'template_path'}) {
        $query_params->{'templatePath'} = $self->{api_client}->to_query_value($args{'template_path'});
    }

    # query params
    if (exists $args{'template_storage'} && defined $args{'template_storage'}) {
        $query_params->{'templateStorage'} = $self->{api_client}->to_query_value($args{'template_storage'});
    }

    # query params
    if (exists $args{'is_image_data_embedded'} && defined $args{'is_image_data_embedded'}) {
        $query_params->{'isImageDataEmbedded'} = $self->{api_client}->to_boolean_query_value($args{'is_image_data_embedded'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'template_password'}) {
        $header_params->{':templatePassword'} = $self->{api_client}->to_header_value($args{'template_password'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'data'} && $args{'data'}) {
        $_body_data = $args{'data'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# create_section
#
# Create a section starting at a specified slide index.
# 
# @param string $name Document name. (required)
# @param string $section_name Section name. (required)
# @param int $slide_index Slide index (one-based). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_name' => {
        data_type => 'string',
        description => 'Section name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index (one-based).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_section' } = { 
    	summary => 'Create a section starting at a specified slide index.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub create_section {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_section");
    }

    # verify the required parameter 'section_name' is set
    unless (exists $args{'section_name'} && defined $args{'section_name'} && $args{'section_name'}) {
      croak("Missing the required parameter 'section_name' when calling create_section");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_section");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'section_name'} && defined $args{'section_name'}) {
        $query_params->{'sectionName'} = $self->{api_client}->to_query_value($args{'section_name'});
    }

    # query params
    if (exists $args{'slide_index'} && defined $args{'slide_index'}) {
        $query_params->{'slideIndex'} = $self->{api_client}->to_query_value($args{'slide_index'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# create_shape
#
# Create new shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param ShapeBase $dto Shape DTO. (optional)
# @param int $shape_to_clone Optional index for clone shape instead of adding a new one. (optional)
# @param int $position Position of the new shape in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '0',
    },
    'shape_to_clone' => {
        data_type => 'int',
        description => 'Optional index for clone shape instead of adding a new one.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new shape in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_shape' } = { 
    	summary => 'Create new shape.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub create_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_to_clone'} && defined $args{'shape_to_clone'}) {
        $query_params->{'shapeToClone'} = $self->{api_client}->to_query_value($args{'shape_to_clone'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# create_slide
#
# Create a slide.
# 
# @param string $name Document name. (required)
# @param string $layout_alias Alias of layout slide for new slide. Alias may be the type of layout, name of layout slide or index (optional)
# @param int $position The target position at which to create the slide. Add to the end by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'layout_alias' => {
        data_type => 'string',
        description => 'Alias of layout slide for new slide. Alias may be the type of layout, name of layout slide or index',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'The target position at which to create the slide. Add to the end by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_slide' } = { 
    	summary => 'Create a slide.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub create_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'layout_alias'} && defined $args{'layout_alias'}) {
        $query_params->{'layoutAlias'} = $self->{api_client}->to_query_value($args{'layout_alias'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# create_smart_art_node
#
# Add SmartArt node
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $smart_art_index Index of the object on the slide among the same type of objects. (required)
# @param string $sub_node Sub-node path (e.g. \&quot;3\&quot;, \&quot;3/nodes/2). (optional)
# @param string $text Node text. (optional)
# @param int $position Position to insert a new node. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'smart_art_index' => {
        data_type => 'int',
        description => 'Index of the object on the slide among the same type of objects.',
        required => '1',
    },
    'sub_node' => {
        data_type => 'string',
        description => 'Sub-node path (e.g. \&quot;3\&quot;, \&quot;3/nodes/2).',
        required => '0',
    },
    'text' => {
        data_type => 'string',
        description => 'Node text.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position to insert a new node.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_smart_art_node' } = { 
    	summary => 'Add SmartArt node',
        params => $params,
        returns => 'SmartArt',
        };
}
# @return SmartArt
#
sub create_smart_art_node {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_smart_art_node");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_smart_art_node");
    }

    # verify the required parameter 'smart_art_index' is set
    unless (exists $args{'smart_art_index'} && defined $args{'smart_art_index'}) {
      croak("Missing the required parameter 'smart_art_index' when calling create_smart_art_node");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/smartArts/{smartArtIndex}/nodes';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'sub_node'} && defined $args{'sub_node'}) {
        $query_params->{'subNode'} = $self->{api_client}->to_query_value($args{'sub_node'});
    }

    # query params
    if (exists $args{'text'} && defined $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'smart_art_index'}) {
        my $_base_variable = "{" . "smartArtIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'smart_art_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SmartArt', $response);
    return $_response_object;
}

#
# create_special_slide_animation_effect
#
# Add an effect to special slide (master, layout, notes) animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param Effect $effect Animation effect DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'effect' => {
        data_type => 'Effect',
        description => 'Animation effect DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_special_slide_animation_effect' } = { 
    	summary => 'Add an effect to special slide (master, layout, notes) animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_special_slide_animation_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_special_slide_animation_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_special_slide_animation_effect");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling create_special_slide_animation_effect");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'effect' is set
    unless (exists $args{'effect'} && defined $args{'effect'} && $args{'effect'}) {
      croak("Missing the required parameter 'effect' when calling create_special_slide_animation_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'effect'} && $args{'effect'}) {
        $_body_data = $args{'effect'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# create_special_slide_animation_interactive_sequence
#
# Set special slide (master, layout, notes) animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param InteractiveSequence $sequence Animation sequence DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'sequence' => {
        data_type => 'InteractiveSequence',
        description => 'Animation sequence DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_special_slide_animation_interactive_sequence' } = { 
    	summary => 'Set special slide (master, layout, notes) animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_special_slide_animation_interactive_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_special_slide_animation_interactive_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_special_slide_animation_interactive_sequence");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling create_special_slide_animation_interactive_sequence");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'sequence' is set
    unless (exists $args{'sequence'} && defined $args{'sequence'} && $args{'sequence'}) {
      croak("Missing the required parameter 'sequence' when calling create_special_slide_animation_interactive_sequence");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'sequence'} && $args{'sequence'}) {
        $_body_data = $args{'sequence'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# create_special_slide_animation_interactive_sequence_effect
#
# Add an animation effect to a special slide (master, layout, notes) interactive sequence.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $sequence_index The position of the interactive sequence. (required)
# @param Effect $effect Animation effect DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'The position of the interactive sequence.',
        required => '1',
    },
    'effect' => {
        data_type => 'Effect',
        description => 'Animation effect DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_special_slide_animation_interactive_sequence_effect' } = { 
    	summary => 'Add an animation effect to a special slide (master, layout, notes) interactive sequence.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub create_special_slide_animation_interactive_sequence_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_special_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_special_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling create_special_slide_animation_interactive_sequence_effect");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'} && defined $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling create_special_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'effect' is set
    unless (exists $args{'effect'} && defined $args{'effect'} && $args{'effect'}) {
      croak("Missing the required parameter 'effect' when calling create_special_slide_animation_interactive_sequence_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'effect'} && $args{'effect'}) {
        $_body_data = $args{'effect'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# create_special_slide_paragraph
#
# Creates new paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param int $position Position of the new paragraph in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new paragraph in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_special_slide_paragraph' } = { 
    	summary => 'Creates new paragraph.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub create_special_slide_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_special_slide_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_special_slide_paragraph");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling create_special_slide_paragraph");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_special_slide_paragraph");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_special_slide_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# create_special_slide_portion
#
# Creates new portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param int $position Position of the new portion in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new portion in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_special_slide_portion' } = { 
    	summary => 'Creates new portion.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub create_special_slide_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_special_slide_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_special_slide_portion");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling create_special_slide_portion");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_special_slide_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling create_special_slide_portion");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_special_slide_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# create_special_slide_shape
#
# Create new shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param ShapeBase $dto Shape DTO. (required)
# @param int $shape_to_clone Optional index for clone shape instead of adding a new one. (optional)
# @param int $position Position of the new shape in the list. Default is at the end of the list. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '1',
    },
    'shape_to_clone' => {
        data_type => 'int',
        description => 'Optional index for clone shape instead of adding a new one.',
        required => '0',
    },
    'position' => {
        data_type => 'int',
        description => 'Position of the new shape in the list. Default is at the end of the list.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_special_slide_shape' } = { 
    	summary => 'Create new shape.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub create_special_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_special_slide_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_special_slide_shape");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling create_special_slide_shape");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_special_slide_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_to_clone'} && defined $args{'shape_to_clone'}) {
        $query_params->{'shapeToClone'} = $self->{api_client}->to_query_value($args{'shape_to_clone'});
    }

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# create_table_cell_paragraph
#
# Creates table cell paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param int $cell_index Table cell index. (required)
# @param Paragraph $dto Paragraph DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'cell_index' => {
        data_type => 'int',
        description => 'Table cell index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Paragraph',
        description => 'Paragraph DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_table_cell_paragraph' } = { 
    	summary => 'Creates table cell paragraph.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub create_table_cell_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_table_cell_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_table_cell_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_table_cell_paragraph");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling create_table_cell_paragraph");
    }

    # verify the required parameter 'cell_index' is set
    unless (exists $args{'cell_index'} && defined $args{'cell_index'}) {
      croak("Missing the required parameter 'cell_index' when calling create_table_cell_paragraph");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_table_cell_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_index'}) {
        my $_base_variable = "{" . "cellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# create_table_cell_portion
#
# Creates table cell portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param int $cell_index Table cell index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param Portion $dto Portion DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'cell_index' => {
        data_type => 'int',
        description => 'Table cell index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'dto' => {
        data_type => 'Portion',
        description => 'Portion DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_table_cell_portion' } = { 
    	summary => 'Creates table cell portion.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub create_table_cell_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_table_cell_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_table_cell_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_table_cell_portion");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling create_table_cell_portion");
    }

    # verify the required parameter 'cell_index' is set
    unless (exists $args{'cell_index'} && defined $args{'cell_index'}) {
      croak("Missing the required parameter 'cell_index' when calling create_table_cell_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling create_table_cell_portion");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_table_cell_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_index'}) {
        my $_base_variable = "{" . "cellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# create_table_row
#
# Inserts the table row in the specified position. If position is not specified, the row add to the end of the table.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param TableRow $dto Table row data. (required)
# @param int $position Position. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'dto' => {
        data_type => 'TableRow',
        description => 'Table row data.',
        required => '1',
    },
    'position' => {
        data_type => 'int',
        description => 'Position.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_table_row' } = { 
    	summary => 'Inserts the table row in the specified position. If position is not specified, the row add to the end of the table.',
        params => $params,
        returns => 'TableRow',
        };
}
# @return TableRow
#
sub create_table_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_table_row");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling create_table_row");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling create_table_row");
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling create_table_row");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'position'} && defined $args{'position'}) {
        $query_params->{'position'} = $self->{api_client}->to_query_value($args{'position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TableRow', $response);
    return $_response_object;
}

#
# create_vba_module
#
# Append module to VBA project             
# 
# @param string $name Document name. (required)
# @param VbaModule $module_dto VBA module DTO. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'module_dto' => {
        data_type => 'VbaModule',
        description => 'VBA module DTO.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_vba_module' } = { 
    	summary => 'Append module to VBA project             ',
        params => $params,
        returns => 'VbaModule',
        };
}
# @return VbaModule
#
sub create_vba_module {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_vba_module");
    }

    # verify the required parameter 'module_dto' is set
    unless (exists $args{'module_dto'} && defined $args{'module_dto'} && $args{'module_dto'}) {
      croak("Missing the required parameter 'module_dto' when calling create_vba_module");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/vbaProject/modules';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'module_dto'} && $args{'module_dto'}) {
        $_body_data = $args{'module_dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('VbaModule', $response);
    return $_response_object;
}

#
# create_watermark
#
# Adds a text watermark to each slide of the presentation. Text watermark can be setup via method arguments or withing Shape DTO for detailed customization. Both options are applicable simultaneously. 
# 
# @param string $name Document name. (required)
# @param Shape $shape Shape DTO (optional)
# @param double $font_height Watermark font height. (optional)
# @param string $text Watermark text. (optional)
# @param string $font_name Watermark font name. (optional)
# @param string $font_color Watermark font color. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'shape' => {
        data_type => 'Shape',
        description => 'Shape DTO',
        required => '0',
    },
    'font_height' => {
        data_type => 'double',
        description => 'Watermark font height.',
        required => '0',
    },
    'text' => {
        data_type => 'string',
        description => 'Watermark text.',
        required => '0',
    },
    'font_name' => {
        data_type => 'string',
        description => 'Watermark font name.',
        required => '0',
    },
    'font_color' => {
        data_type => 'string',
        description => 'Watermark font color.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_watermark' } = { 
    	summary => 'Adds a text watermark to each slide of the presentation. Text watermark can be setup via method arguments or withing Shape DTO for detailed customization. Both options are applicable simultaneously. ',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub create_watermark {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling create_watermark");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/watermark';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'font_height'} && defined $args{'font_height'}) {
        $query_params->{'fontHeight'} = $self->{api_client}->to_query_value($args{'font_height'});
    }

    # query params
    if (exists $args{'text'} && defined $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if (exists $args{'font_name'} && defined $args{'font_name'}) {
        $query_params->{'fontName'} = $self->{api_client}->to_query_value($args{'font_name'});
    }

    # query params
    if (exists $args{'font_color'} && defined $args{'font_color'}) {
        $query_params->{'fontColor'} = $self->{api_client}->to_query_value($args{'font_color'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'shape'} && $args{'shape'}) {
        $_body_data = $args{'shape'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# create_watermark_online
#
# Adds a text watermark to each slide of the presentation. Text watermark can be setup via method arguments or withing Shape DTO for detailed customization. Both options are applicable simultaneously. 
# 
# @param File $document Document data. (required)
# @param Shape $shape Shape DTO (optional)
# @param double $font_height Watermark font height. (optional)
# @param string $text Watermark text. (optional)
# @param string $font_name Watermark font name. (optional)
# @param string $font_color Watermark font color. (optional)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'shape' => {
        data_type => 'Shape',
        description => 'Shape DTO',
        required => '0',
    },
    'font_height' => {
        data_type => 'double',
        description => 'Watermark font height.',
        required => '0',
    },
    'text' => {
        data_type => 'string',
        description => 'Watermark text.',
        required => '0',
    },
    'font_name' => {
        data_type => 'string',
        description => 'Watermark font name.',
        required => '0',
    },
    'font_color' => {
        data_type => 'string',
        description => 'Watermark font color.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_watermark_online' } = { 
    	summary => 'Adds a text watermark to each slide of the presentation. Text watermark can be setup via method arguments or withing Shape DTO for detailed customization. Both options are applicable simultaneously. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub create_watermark_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling create_watermark_online");
    }

    # parse inputs
    my $_resource_path = '/slides/watermark';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'font_height'} && defined $args{'font_height'}) {
        $query_params->{'fontHeight'} = $self->{api_client}->to_query_value($args{'font_height'});
    }

    # query params
    if (exists $args{'text'} && defined $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if (exists $args{'font_name'} && defined $args{'font_name'}) {
        $query_params->{'fontName'} = $self->{api_client}->to_query_value($args{'font_name'});
    }

    # query params
    if (exists $args{'font_color'} && defined $args{'font_color'}) {
        $query_params->{'fontColor'} = $self->{api_client}->to_query_value($args{'font_color'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # body params
    if ( exists $args{'shape'} && $args{'shape'}) {
        $_body_data = $args{'shape'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# delete_animation
#
# Remove animation from a slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation' } = { 
    	summary => 'Remove animation from a slide.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_animation");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_animation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_animation_effect
#
# Remove an effect from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $effect_index Index of the effect to be removed. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'effect_index' => {
        data_type => 'int',
        description => 'Index of the effect to be removed.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_effect' } = { 
    	summary => 'Remove an effect from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_animation_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_animation_effect");
    }

    # verify the required parameter 'effect_index' is set
    unless (exists $args{'effect_index'} && defined $args{'effect_index'}) {
      croak("Missing the required parameter 'effect_index' when calling delete_animation_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/mainSequence/{effectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'effect_index'}) {
        my $_base_variable = "{" . "effectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'effect_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_animation_interactive_sequence
#
# Remove an interactive sequence from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index The index of an interactive sequence to be deleted. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'The index of an interactive sequence to be deleted.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_interactive_sequence' } = { 
    	summary => 'Remove an interactive sequence from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_interactive_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_animation_interactive_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_animation_interactive_sequence");
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'} && defined $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling delete_animation_interactive_sequence");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_animation_interactive_sequence_effect
#
# Remove an effect from slide animation interactive sequence.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $sequence_index Interactive sequence index. (required)
# @param int $effect_index Index of the effect to be removed. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'Interactive sequence index.',
        required => '1',
    },
    'effect_index' => {
        data_type => 'int',
        description => 'Index of the effect to be removed.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_interactive_sequence_effect' } = { 
    	summary => 'Remove an effect from slide animation interactive sequence.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_interactive_sequence_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'} && defined $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling delete_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'effect_index' is set
    unless (exists $args{'effect_index'} && defined $args{'effect_index'}) {
      croak("Missing the required parameter 'effect_index' when calling delete_animation_interactive_sequence_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}/{effectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'effect_index'}) {
        my $_base_variable = "{" . "effectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'effect_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_animation_interactive_sequences
#
# Clear all interactive sequences from slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_interactive_sequences' } = { 
    	summary => 'Clear all interactive sequences from slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_interactive_sequences {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_animation_interactive_sequences");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_animation_interactive_sequences");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_animation_main_sequence
#
# Clear main sequence in slide animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_animation_main_sequence' } = { 
    	summary => 'Clear main sequence in slide animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_animation_main_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_animation_main_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_animation_main_sequence");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation/mainSequence';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_background
#
# Remove background from a slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_background' } = { 
    	summary => 'Remove background from a slide.',
        params => $params,
        returns => 'SlideBackground',
        };
}
# @return SlideBackground
#
sub delete_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_background");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_background");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/background';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideBackground', $response);
    return $_response_object;
}

#
# delete_chart_category
#
# Delete a category from a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $category_index Category index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'category_index' => {
        data_type => 'int',
        description => 'Category index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_chart_category' } = { 
    	summary => 'Delete a category from a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub delete_chart_category {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_chart_category");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_chart_category");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_chart_category");
    }

    # verify the required parameter 'category_index' is set
    unless (exists $args{'category_index'} && defined $args{'category_index'}) {
      croak("Missing the required parameter 'category_index' when calling delete_chart_category");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories/{categoryIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'category_index'}) {
        my $_base_variable = "{" . "categoryIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'category_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# delete_chart_data_point
#
# Delete a data point from a chart series.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $series_index Series index. (required)
# @param int $point_index Data point index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'point_index' => {
        data_type => 'int',
        description => 'Data point index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_chart_data_point' } = { 
    	summary => 'Delete a data point from a chart series.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub delete_chart_data_point {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_chart_data_point");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_chart_data_point");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_chart_data_point");
    }

    # verify the required parameter 'series_index' is set
    unless (exists $args{'series_index'} && defined $args{'series_index'}) {
      croak("Missing the required parameter 'series_index' when calling delete_chart_data_point");
    }

    # verify the required parameter 'point_index' is set
    unless (exists $args{'point_index'} && defined $args{'point_index'}) {
      croak("Missing the required parameter 'point_index' when calling delete_chart_data_point");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints/{pointIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'series_index'}) {
        my $_base_variable = "{" . "seriesIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'series_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'point_index'}) {
        my $_base_variable = "{" . "pointIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'point_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# delete_chart_series
#
# Delete a series from a chart.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must be a chart). (required)
# @param int $series_index Series index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must be a chart).',
        required => '1',
    },
    'series_index' => {
        data_type => 'int',
        description => 'Series index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_chart_series' } = { 
    	summary => 'Delete a series from a chart.',
        params => $params,
        returns => 'Chart',
        };
}
# @return Chart
#
sub delete_chart_series {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_chart_series");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_chart_series");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_chart_series");
    }

    # verify the required parameter 'series_index' is set
    unless (exists $args{'series_index'} && defined $args{'series_index'}) {
      croak("Missing the required parameter 'series_index' when calling delete_chart_series");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'series_index'}) {
        my $_base_variable = "{" . "seriesIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'series_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Chart', $response);
    return $_response_object;
}

#
# delete_comments
#
# Removes comments of the specified author from the presentation. If author value is not provided all comments will be removed. 
# 
# @param string $name Document name. (required)
# @param string $author Author of comments. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'author' => {
        data_type => 'string',
        description => 'Author of comments.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_comments' } = { 
    	summary => 'Removes comments of the specified author from the presentation. If author value is not provided all comments will be removed. ',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_comments {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_comments");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/comments';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'author'} && defined $args{'author'}) {
        $query_params->{'author'} = $self->{api_client}->to_query_value($args{'author'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# delete_comments_online
#
# Removes comments of the specified author from the presentation. If author value is not provided all comments will be removed. 
# 
# @param File $document Document data. (required)
# @param string $author Author of comments. (optional)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'author' => {
        data_type => 'string',
        description => 'Author of comments.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_comments_online' } = { 
    	summary => 'Removes comments of the specified author from the presentation. If author value is not provided all comments will be removed. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub delete_comments_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling delete_comments_online");
    }

    # parse inputs
    my $_resource_path = '/slides/comments/delete';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'author'} && defined $args{'author'}) {
        $query_params->{'author'} = $self->{api_client}->to_query_value($args{'author'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# delete_document_properties
#
# Clean document properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_document_properties' } = { 
    	summary => 'Clean document properties.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub delete_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_document_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperties', $response);
    return $_response_object;
}

#
# delete_document_property
#
# Delete document property.
# 
# @param string $name Document name. (required)
# @param string $property_name The property name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_document_property' } = { 
    	summary => 'Delete document property.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub delete_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'} && defined $args{'property_name'} && $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling delete_document_property");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties/{propertyName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperties', $response);
    return $_response_object;
}

#
# delete_embedded_font
#
# Removes specified embedded font and returns presentation fonts info.
# 
# @param string $name Document name. (required)
# @param string $font_name Font name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'font_name' => {
        data_type => 'string',
        description => 'Font name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_embedded_font' } = { 
    	summary => 'Removes specified embedded font and returns presentation fonts info.',
        params => $params,
        returns => 'FontsData',
        };
}
# @return FontsData
#
sub delete_embedded_font {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_embedded_font");
    }

    # verify the required parameter 'font_name' is set
    unless (exists $args{'font_name'} && defined $args{'font_name'} && $args{'font_name'}) {
      croak("Missing the required parameter 'font_name' when calling delete_embedded_font");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fonts/embedded/{fontName}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'font_name'}) {
        my $_base_variable = "{" . "fontName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'font_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FontsData', $response);
    return $_response_object;
}

#
# delete_embedded_font_online
#
# Removes specified embedded font and returns presentation.
# 
# @param File $document Document data. (required)
# @param string $font_name Font name. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'font_name' => {
        data_type => 'string',
        description => 'Font name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_embedded_font_online' } = { 
    	summary => 'Removes specified embedded font and returns presentation.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub delete_embedded_font_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling delete_embedded_font_online");
    }

    # verify the required parameter 'font_name' is set
    unless (exists $args{'font_name'} && defined $args{'font_name'} && $args{'font_name'}) {
      croak("Missing the required parameter 'font_name' when calling delete_embedded_font_online");
    }

    # parse inputs
    my $_resource_path = '/slides/fonts/embedded/{fontName}/delete';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'font_name'}) {
        my $_base_variable = "{" . "fontName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'font_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# delete_file
#
# Delete file
# 
# @param string $path File path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID to delete (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to delete',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_file' } = { 
    	summary => 'Delete file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_file {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && defined $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_file");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/file/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# delete_folder
#
# Delete folder
# 
# @param string $path Folder path e.g. &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
# @param boolean $recursive Enable to delete folders, subfolders and files (optional, default to false)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path e.g. &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'recursive' => {
        data_type => 'boolean',
        description => 'Enable to delete folders, subfolders and files',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_folder' } = { 
    	summary => 'Delete folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && defined $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_folder");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if (exists $args{'recursive'} && defined $args{'recursive'}) {
        $query_params->{'recursive'} = $self->{api_client}->to_boolean_query_value($args{'recursive'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# delete_notes_slide
#
# Remove notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_notes_slide' } = { 
    	summary => 'Remove notes slide.',
        params => $params,
        returns => 'Slide',
        };
}
# @return Slide
#
sub delete_notes_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_notes_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_notes_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slide', $response);
    return $_response_object;
}

#
# delete_paragraph
#
# Remove a paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_paragraph' } = { 
    	summary => 'Remove a paragraph.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_paragraphs
#
# Remove a range of paragraphs.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int[] $paragraphs The indices of the paragraphs to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraphs' => {
        data_type => 'int[]',
        description => 'The indices of the paragraphs to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_paragraphs' } = { 
    	summary => 'Remove a range of paragraphs.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'paragraphs'} && defined $args{'paragraphs'}) {
        $query_params->{'paragraphs'} = $self->{api_client}->to_query_value($args{'paragraphs'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_picture_cropped_areas
#
# Deletes cropped areas of a pictire.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index (must refer to a picture frame). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Presentation storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index (must refer to a picture frame).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_picture_cropped_areas' } = { 
    	summary => 'Deletes cropped areas of a pictire.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_picture_cropped_areas {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_picture_cropped_areas");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_picture_cropped_areas");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_picture_cropped_areas");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/pictureCroppedAreas';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# delete_portion
#
# Remove a portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_portion' } = { 
    	summary => 'Remove a portion.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling delete_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_portions
#
# Remove a range of portions.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int[] $portions The indices of the portions to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portions' => {
        data_type => 'int[]',
        description => 'The indices of the portions to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_portions' } = { 
    	summary => 'Remove a range of portions.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'portions'} && defined $args{'portions'}) {
        $query_params->{'portions'} = $self->{api_client}->to_query_value($args{'portions'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_protection
#
# Resets all presentation protection settings. 
# 
# @param string $name Document name. (required)
# @param string $password Presentation password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Presentation password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_protection' } = { 
    	summary => 'Resets all presentation protection settings. ',
        params => $params,
        returns => 'ProtectionProperties',
        };
}
# @return ProtectionProperties
#
sub delete_protection {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_protection");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/protection';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ProtectionProperties', $response);
    return $_response_object;
}

#
# delete_protection_online
#
# Resets all presentation protection settings. 
# 
# @param File $document Document data. (required)
# @param string $password Presentation password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Presentation password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_protection_online' } = { 
    	summary => 'Resets all presentation protection settings. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub delete_protection_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling delete_protection_online");
    }

    # parse inputs
    my $_resource_path = '/slides/protection/delete';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# delete_section
#
# Delete a presentation section.
# 
# @param string $name Document name. (required)
# @param int $section_index Section index. (required)
# @param boolean $with_slides True to delete the slides related to the deleted section; move them to the remaining sections otherwise. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_index' => {
        data_type => 'int',
        description => 'Section index.',
        required => '1',
    },
    'with_slides' => {
        data_type => 'boolean',
        description => 'True to delete the slides related to the deleted section; move them to the remaining sections otherwise.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_section' } = { 
    	summary => 'Delete a presentation section.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub delete_section {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_section");
    }

    # verify the required parameter 'section_index' is set
    unless (exists $args{'section_index'} && defined $args{'section_index'}) {
      croak("Missing the required parameter 'section_index' when calling delete_section");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections/{sectionIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'with_slides'} && defined $args{'with_slides'}) {
        $query_params->{'withSlides'} = $self->{api_client}->to_boolean_query_value($args{'with_slides'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'section_index'}) {
        my $_base_variable = "{" . "sectionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'section_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# delete_sections
#
# Delete presentation sections.
# 
# @param string $name Document name. (required)
# @param int[] $sections The indices of the sections to be deleted; delete all by default. (optional)
# @param boolean $with_slides True to delete the slides related to the deleted sections; move them to the remaining sections otherwise. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'sections' => {
        data_type => 'int[]',
        description => 'The indices of the sections to be deleted; delete all by default.',
        required => '0',
    },
    'with_slides' => {
        data_type => 'boolean',
        description => 'True to delete the slides related to the deleted sections; move them to the remaining sections otherwise.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_sections' } = { 
    	summary => 'Delete presentation sections.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub delete_sections {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_sections");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'sections'} && defined $args{'sections'}) {
        $query_params->{'sections'} = $self->{api_client}->to_query_value($args{'sections'});
    }

    # query params
    if (exists $args{'with_slides'} && defined $args{'with_slides'}) {
        $query_params->{'withSlides'} = $self->{api_client}->to_boolean_query_value($args{'with_slides'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# delete_shape
#
# Remove a shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_shape' } = { 
    	summary => 'Remove a shape.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_shapes
#
# Remove a range of shapes.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int[] $shapes The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shapes' => {
        data_type => 'int[]',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_shapes' } = { 
    	summary => 'Remove a range of shapes.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_shapes");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_slide
#
# Delete a presentation slide by index.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide' } = { 
    	summary => 'Delete a presentation slide by index.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub delete_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# delete_slide_comments
#
# Removes comments of the specified author from the slide. If author value is not provided all comments will be removed. 
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $author Author of comments. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'author' => {
        data_type => 'string',
        description => 'Author of comments.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_comments' } = { 
    	summary => 'Removes comments of the specified author from the slide. If author value is not provided all comments will be removed. ',
        params => $params,
        returns => 'SlideComments',
        };
}
# @return SlideComments
#
sub delete_slide_comments {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slide_comments");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_comments");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/comments';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'author'} && defined $args{'author'}) {
        $query_params->{'author'} = $self->{api_client}->to_query_value($args{'author'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideComments', $response);
    return $_response_object;
}

#
# delete_slide_comments_online
#
# Removes comments of the specified author from the slide. If author value is not provided all comments will be removed.              
# 
# @param File $document Document data. (required)
# @param int $slide_index  (required)
# @param string $author Author of comments. (optional)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'author' => {
        data_type => 'string',
        description => 'Author of comments.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slide_comments_online' } = { 
    	summary => 'Removes comments of the specified author from the slide. If author value is not provided all comments will be removed.              ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub delete_slide_comments_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling delete_slide_comments_online");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_slide_comments_online");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/comments/delete';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'author'} && defined $args{'author'}) {
        $query_params->{'author'} = $self->{api_client}->to_query_value($args{'author'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# delete_slides
#
# Delete presentation slides.
# 
# @param string $name Document name. (required)
# @param int[] $slides The indices of the slides to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slides' => {
        data_type => 'int[]',
        description => 'The indices of the slides to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_slides' } = { 
    	summary => 'Delete presentation slides.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub delete_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_slides");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'slides'} && defined $args{'slides'}) {
        $query_params->{'slides'} = $self->{api_client}->to_query_value($args{'slides'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# delete_smart_art_node
#
# Delete SmartArt node
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $smart_art_index Index of the object on the slide among the same type of objects. (required)
# @param int $node_index Root level node index. (required)
# @param string $sub_node Sub-node path (e.g. \&quot;3\&quot;, \&quot;3/nodes/2). (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'smart_art_index' => {
        data_type => 'int',
        description => 'Index of the object on the slide among the same type of objects.',
        required => '1',
    },
    'node_index' => {
        data_type => 'int',
        description => 'Root level node index.',
        required => '1',
    },
    'sub_node' => {
        data_type => 'string',
        description => 'Sub-node path (e.g. \&quot;3\&quot;, \&quot;3/nodes/2).',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_smart_art_node' } = { 
    	summary => 'Delete SmartArt node',
        params => $params,
        returns => 'SmartArt',
        };
}
# @return SmartArt
#
sub delete_smart_art_node {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_smart_art_node");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_smart_art_node");
    }

    # verify the required parameter 'smart_art_index' is set
    unless (exists $args{'smart_art_index'} && defined $args{'smart_art_index'}) {
      croak("Missing the required parameter 'smart_art_index' when calling delete_smart_art_node");
    }

    # verify the required parameter 'node_index' is set
    unless (exists $args{'node_index'} && defined $args{'node_index'}) {
      croak("Missing the required parameter 'node_index' when calling delete_smart_art_node");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/smartArts/{smartArtIndex}/nodes/{nodeIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'sub_node'} && defined $args{'sub_node'}) {
        $query_params->{'subNode'} = $self->{api_client}->to_query_value($args{'sub_node'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'smart_art_index'}) {
        my $_base_variable = "{" . "smartArtIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'smart_art_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'node_index'}) {
        my $_base_variable = "{" . "nodeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'node_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SmartArt', $response);
    return $_response_object;
}

#
# delete_special_slide_animation
#
# Remove animation from a special slide (master, layout, notes).
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_animation' } = { 
    	summary => 'Remove animation from a special slide (master, layout, notes).',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_special_slide_animation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_animation");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_animation");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_animation");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_special_slide_animation_effect
#
# Remove an effect from special slide (master, layout, notes) animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $effect_index Index of the effect to be removed. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'effect_index' => {
        data_type => 'int',
        description => 'Index of the effect to be removed.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_animation_effect' } = { 
    	summary => 'Remove an effect from special slide (master, layout, notes) animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_special_slide_animation_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_animation_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_animation_effect");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_animation_effect");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'effect_index' is set
    unless (exists $args{'effect_index'} && defined $args{'effect_index'}) {
      croak("Missing the required parameter 'effect_index' when calling delete_special_slide_animation_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence/{effectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'effect_index'}) {
        my $_base_variable = "{" . "effectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'effect_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_special_slide_animation_interactive_sequence
#
# Remove an interactive sequence from special slide (master, layout, notes) animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $sequence_index The index of an interactive sequence to be deleted. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'The index of an interactive sequence to be deleted.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_animation_interactive_sequence' } = { 
    	summary => 'Remove an interactive sequence from special slide (master, layout, notes) animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_special_slide_animation_interactive_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_animation_interactive_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_animation_interactive_sequence");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_animation_interactive_sequence");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'} && defined $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling delete_special_slide_animation_interactive_sequence");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_special_slide_animation_interactive_sequence_effect
#
# Remove an effect from special slide (master, layout, notes) animation interactive sequence.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $sequence_index Interactive sequence index. (required)
# @param int $effect_index Index of the effect to be removed. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'sequence_index' => {
        data_type => 'int',
        description => 'Interactive sequence index.',
        required => '1',
    },
    'effect_index' => {
        data_type => 'int',
        description => 'Index of the effect to be removed.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_animation_interactive_sequence_effect' } = { 
    	summary => 'Remove an effect from special slide (master, layout, notes) animation interactive sequence.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_special_slide_animation_interactive_sequence_effect {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_animation_interactive_sequence_effect");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'sequence_index' is set
    unless (exists $args{'sequence_index'} && defined $args{'sequence_index'}) {
      croak("Missing the required parameter 'sequence_index' when calling delete_special_slide_animation_interactive_sequence_effect");
    }

    # verify the required parameter 'effect_index' is set
    unless (exists $args{'effect_index'} && defined $args{'effect_index'}) {
      croak("Missing the required parameter 'effect_index' when calling delete_special_slide_animation_interactive_sequence_effect");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}/{effectIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sequence_index'}) {
        my $_base_variable = "{" . "sequenceIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sequence_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'effect_index'}) {
        my $_base_variable = "{" . "effectIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'effect_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_special_slide_animation_interactive_sequences
#
# Clear all interactive sequences from special slide (master, layout, notes) animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_animation_interactive_sequences' } = { 
    	summary => 'Clear all interactive sequences from special slide (master, layout, notes) animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_special_slide_animation_interactive_sequences {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_animation_interactive_sequences");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_animation_interactive_sequences");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_animation_interactive_sequences");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_special_slide_animation_main_sequence
#
# Clear main sequence in special slide (master, layout, notes) animation.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_animation_main_sequence' } = { 
    	summary => 'Clear main sequence in special slide (master, layout, notes) animation.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub delete_special_slide_animation_main_sequence {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_animation_main_sequence");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_animation_main_sequence");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_animation_main_sequence");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# delete_special_slide_paragraph
#
# Remove a paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_paragraph' } = { 
    	summary => 'Remove a paragraph.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_special_slide_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_paragraph");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_paragraph");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_special_slide_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_special_slide_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_special_slide_paragraphs
#
# Remove a range of paragraphs.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param int[] $paragraphs The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraphs' => {
        data_type => 'int[]',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_paragraphs' } = { 
    	summary => 'Remove a range of paragraphs.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_special_slide_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_paragraphs");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_paragraphs");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_special_slide_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'paragraphs'} && defined $args{'paragraphs'}) {
        $query_params->{'paragraphs'} = $self->{api_client}->to_query_value($args{'paragraphs'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_special_slide_portion
#
# Remove a portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_portion' } = { 
    	summary => 'Remove a portion.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_special_slide_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_portion");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_portion");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_special_slide_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_special_slide_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling delete_special_slide_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_special_slide_portions
#
# Remove a range of portions.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int[] $portions The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portions' => {
        data_type => 'int[]',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_portions' } = { 
    	summary => 'Remove a range of portions.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_special_slide_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_portions");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_portions");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_special_slide_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_special_slide_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'portions'} && defined $args{'portions'}) {
        $query_params->{'portions'} = $self->{api_client}->to_query_value($args{'portions'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_special_slide_shape
#
# Remove a shape.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_shape' } = { 
    	summary => 'Remove a shape.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_special_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_shape");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_shape");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_special_slide_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_special_slide_shapes
#
# Remove a range of shapes.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int[] $shapes The indices of the shapes to be deleted; delete all by default. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shapes' => {
        data_type => 'int[]',
        description => 'The indices of the shapes to be deleted; delete all by default.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_special_slide_shapes' } = { 
    	summary => 'Remove a range of shapes.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub delete_special_slide_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_special_slide_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_special_slide_shapes");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling delete_special_slide_shapes");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# delete_table_cell_paragraph
#
# Delete cell paragraph.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param int $cell_index Table cell index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'cell_index' => {
        data_type => 'int',
        description => 'Table cell index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_table_cell_paragraph' } = { 
    	summary => 'Delete cell paragraph.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub delete_table_cell_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_table_cell_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_table_cell_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_table_cell_paragraph");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling delete_table_cell_paragraph");
    }

    # verify the required parameter 'cell_index' is set
    unless (exists $args{'cell_index'} && defined $args{'cell_index'}) {
      croak("Missing the required parameter 'cell_index' when calling delete_table_cell_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_table_cell_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_index'}) {
        my $_base_variable = "{" . "cellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# delete_table_cell_portion
#
# Delete table ell portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param int $cell_index Table cell index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'cell_index' => {
        data_type => 'int',
        description => 'Table cell index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_table_cell_portion' } = { 
    	summary => 'Delete table ell portion.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub delete_table_cell_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_table_cell_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_table_cell_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_table_cell_portion");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling delete_table_cell_portion");
    }

    # verify the required parameter 'cell_index' is set
    unless (exists $args{'cell_index'} && defined $args{'cell_index'}) {
      croak("Missing the required parameter 'cell_index' when calling delete_table_cell_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling delete_table_cell_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling delete_table_cell_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_index'}) {
        my $_base_variable = "{" . "cellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# delete_table_row
#
# Deletes the table row.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param boolean $with_attached_rows Also delete all attached rows. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'with_attached_rows' => {
        data_type => 'boolean',
        description => 'Also delete all attached rows.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_table_row' } = { 
    	summary => 'Deletes the table row.',
        params => $params,
        returns => 'Table',
        };
}
# @return Table
#
sub delete_table_row {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_table_row");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling delete_table_row");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling delete_table_row");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling delete_table_row");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'with_attached_rows'} && defined $args{'with_attached_rows'}) {
        $query_params->{'withAttachedRows'} = $self->{api_client}->to_boolean_query_value($args{'with_attached_rows'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Table', $response);
    return $_response_object;
}

#
# delete_unused_layout_slides
#
# Removes unused layout slides.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_unused_layout_slides' } = { 
    	summary => 'Removes unused layout slides.',
        params => $params,
        returns => 'LayoutSlides',
        };
}
# @return LayoutSlides
#
sub delete_unused_layout_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_unused_layout_slides");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/layoutSlides';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LayoutSlides', $response);
    return $_response_object;
}

#
# delete_unused_layout_slides_online
#
# Removes unused layout slides.
# 
# @param File $document Document data (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_unused_layout_slides_online' } = { 
    	summary => 'Removes unused layout slides.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub delete_unused_layout_slides_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling delete_unused_layout_slides_online");
    }

    # parse inputs
    my $_resource_path = '/slides/layoutSlides/delete';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# delete_unused_master_slides
#
# Removes unused master slides.
# 
# @param string $name Document name. (required)
# @param boolean $ignore_preserve_field Determines, whether this method should remove unused master even if its             preserve property is set to true. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'ignore_preserve_field' => {
        data_type => 'boolean',
        description => 'Determines, whether this method should remove unused master even if its             preserve property is set to true.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_unused_master_slides' } = { 
    	summary => 'Removes unused master slides.',
        params => $params,
        returns => 'MasterSlides',
        };
}
# @return MasterSlides
#
sub delete_unused_master_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_unused_master_slides");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/masterSlides';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'ignore_preserve_field'} && defined $args{'ignore_preserve_field'}) {
        $query_params->{'ignorePreserveField'} = $self->{api_client}->to_boolean_query_value($args{'ignore_preserve_field'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MasterSlides', $response);
    return $_response_object;
}

#
# delete_unused_master_slides_online
#
# Removes unused master slides.
# 
# @param File $document Document data (required)
# @param boolean $ignore_preserve_field Determines, whether this method should remove unused master even if its             preserve property is set to true. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data',
        required => '1',
    },
    'ignore_preserve_field' => {
        data_type => 'boolean',
        description => 'Determines, whether this method should remove unused master even if its             preserve property is set to true.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_unused_master_slides_online' } = { 
    	summary => 'Removes unused master slides.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub delete_unused_master_slides_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling delete_unused_master_slides_online");
    }

    # parse inputs
    my $_resource_path = '/slides/masterSlides/delete';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'ignore_preserve_field'} && defined $args{'ignore_preserve_field'}) {
        $query_params->{'ignorePreserveField'} = $self->{api_client}->to_boolean_query_value($args{'ignore_preserve_field'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# delete_vba_module
#
# Delete module from VBA project.
# 
# @param string $name Document name. (required)
# @param int $module_index The index of the macros module to remove. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'module_index' => {
        data_type => 'int',
        description => 'The index of the macros module to remove.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_vba_module' } = { 
    	summary => 'Delete module from VBA project.',
        params => $params,
        returns => 'VbaProject',
        };
}
# @return VbaProject
#
sub delete_vba_module {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_vba_module");
    }

    # verify the required parameter 'module_index' is set
    unless (exists $args{'module_index'} && defined $args{'module_index'}) {
      croak("Missing the required parameter 'module_index' when calling delete_vba_module");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/vbaProject/modules/{moduleIndex}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'module_index'}) {
        my $_base_variable = "{" . "moduleIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'module_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('VbaProject', $response);
    return $_response_object;
}

#
# delete_watermark
#
# Removes shapes with name \"watermark\" from the presentation.
# 
# @param string $name Document name. (required)
# @param string $shape_name Name of the watermark shape. If null, default value \&quot;watermark\&quot;is used. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'shape_name' => {
        data_type => 'string',
        description => 'Name of the watermark shape. If null, default value \&quot;watermark\&quot;is used.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_watermark' } = { 
    	summary => 'Removes shapes with name \&quot;watermark\&quot; from the presentation.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_watermark {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_watermark");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/watermark/delete';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_name'} && defined $args{'shape_name'}) {
        $query_params->{'shapeName'} = $self->{api_client}->to_query_value($args{'shape_name'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# delete_watermark_online
#
# Removes shapes with name \"watermark\" from the presentation.
# 
# @param File $document Document data. (required)
# @param string $shape_name Name of the watermark shape. If null, default value \&quot;watermark\&quot;is used. (optional)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'shape_name' => {
        data_type => 'string',
        description => 'Name of the watermark shape. If null, default value \&quot;watermark\&quot;is used.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_watermark_online' } = { 
    	summary => 'Removes shapes with name \&quot;watermark\&quot; from the presentation.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub delete_watermark_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling delete_watermark_online");
    }

    # parse inputs
    my $_resource_path = '/slides/watermark/delete';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'shape_name'} && defined $args{'shape_name'}) {
        $query_params->{'shapeName'} = $self->{api_client}->to_query_value($args{'shape_name'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_file
#
# Download file
# 
# @param string $path File path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID to download (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to download',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_file' } = { 
    	summary => 'Download file',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_file {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && defined $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling download_file");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/file/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_image
#
# Get image in specified format.
# 
# @param string $name Document name. (required)
# @param int $index Image index. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_image' } = { 
    	summary => 'Get image in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_image {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_image");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'} && defined $args{'index'}) {
      croak("Missing the required parameter 'index' when calling download_image");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_image");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/{index}/{format}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_image_default_format
#
# Get image binary data.
# 
# @param string $name Document name. (required)
# @param int $index Image index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_image_default_format' } = { 
    	summary => 'Get image binary data.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_image_default_format {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_image_default_format");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'} && defined $args{'index'}) {
      croak("Missing the required parameter 'index' when calling download_image_default_format");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/{index}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_image_default_format_online
#
# Get image binary data.
# 
# @param File $document Document data. (required)
# @param int $index Image index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_image_default_format_online' } = { 
    	summary => 'Get image binary data.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_image_default_format_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling download_image_default_format_online");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'} && defined $args{'index'}) {
      croak("Missing the required parameter 'index' when calling download_image_default_format_online");
    }

    # parse inputs
    my $_resource_path = '/slides/images/{index}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_image_online
#
# Get image in specified format.
# 
# @param File $document Document data. (required)
# @param int $index Image index. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_image_online' } = { 
    	summary => 'Get image in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_image_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling download_image_online");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'} && defined $args{'index'}) {
      croak("Missing the required parameter 'index' when calling download_image_online");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_image_online");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/images/{index}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_images
#
# Get all presentation images in specified format.
# 
# @param string $name  (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_images' } = { 
    	summary => 'Get all presentation images in specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_images {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_images");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_images");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/download/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_images_default_format
#
# Get all presentation images.
# 
# @param string $name  (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_images_default_format' } = { 
    	summary => 'Get all presentation images.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_images_default_format {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_images_default_format");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/download';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_images_default_format_online
#
# Get all presentation images.
# 
# @param File $document Document data. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_images_default_format_online' } = { 
    	summary => 'Get all presentation images.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_images_default_format_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling download_images_default_format_online");
    }

    # parse inputs
    my $_resource_path = '/slides/images/download';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_images_online
#
# Get all presentation images in specified format. 
# 
# @param File $document Document data. (required)
# @param string $format Export format (png, jpg, gif). (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format (png, jpg, gif).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_images_online' } = { 
    	summary => 'Get all presentation images in specified format. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_images_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling download_images_online");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_images_online");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/images/download/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_math_portion
#
# Convert Mathematical Text to MathML Format
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $format Format. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Format.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_math_portion' } = { 
    	summary => 'Convert Mathematical Text to MathML Format',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_math_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_math_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling download_math_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling download_math_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling download_math_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling download_math_portion");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_math_portion");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'MathML', 'LaTeX' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_notes_slide
#
# Convert notes slide to the specified image format.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width The width of the slide representation in the output format. (optional)
# @param int $height The height of the slide representation in the output format (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'The width of the slide representation in the output format.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'The height of the slide representation in the output format',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_notes_slide' } = { 
    	summary => 'Convert notes slide to the specified image format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_notes_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_notes_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling download_notes_slide");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_notes_slide");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Html', 'Pdf', 'Xps', 'Pptx', 'Odp', 'Otp', 'Ppt', 'Pps', 'Ppsx', 'Pptm', 'Ppsm', 'Potx', 'Pot', 'Potm', 'Svg', 'Fodp', 'Xaml', 'Html5' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/{format}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_notes_slide_online
#
# Convert notes slide to the specified image format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width The width of the slide representation in the output format. (optional)
# @param int $height The height of the slide representation in the output format. (optional)
# @param string $password Document password. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'The width of the slide representation in the output format.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'The height of the slide representation in the output format.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_notes_slide_online' } = { 
    	summary => 'Convert notes slide to the specified image format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_notes_slide_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling download_notes_slide_online");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling download_notes_slide_online");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_notes_slide_online");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Html', 'Pdf', 'Xps', 'Pptx', 'Odp', 'Otp', 'Ppt', 'Pps', 'Ppsx', 'Pptm', 'Ppsm', 'Potx', 'Pot', 'Potm', 'Svg', 'Fodp', 'Xaml', 'Html5' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/notesSlide/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_presentation
#
# Save a presentation to a specified format.
# 
# @param string $name Document name. (required)
# @param string $format Export format. (required)
# @param ExportOptions $options Export options. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
# @param int[] $slides The indices of the slides to be saved. If not specified, all slides are saved by default. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    'slides' => {
        data_type => 'int[]',
        description => 'The indices of the slides to be saved. If not specified, all slides are saved by default.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_presentation' } = { 
    	summary => 'Save a presentation to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_presentation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_presentation");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_presentation");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Pdf', 'Xps', 'Tiff', 'Pptx', 'Odp', 'Otp', 'Ppt', 'Pps', 'Ppsx', 'Pptm', 'Ppsm', 'Pot', 'Potx', 'Potm', 'Html', 'Html5', 'Swf', 'Svg', 'Jpeg', 'Png', 'Gif', 'Bmp', 'Fodp', 'Xaml', 'Mpeg4', 'Md', 'Xml' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # query params
    if (exists $args{'slides'} && defined $args{'slides'}) {
        $query_params->{'slides'} = $self->{api_client}->to_query_value($args{'slides'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_shape
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling download_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling download_shape");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_shape");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Svg' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # verify enum value
    if (exists $args{'bounds'} && $args{'bounds'} && !grep(/^$args{'bounds'}$/i, ( 'Slide', 'Shape', 'Appearance' ))) {
      croak("Invalid value for 'bounds': " . $args{'bounds'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_shape_from_dto
#
# Creates the shape from the DTO and returns the result in the specified format.
# 
# @param string $format Export format (required)
# @param ShapeBase $dto Shape DTO. (required)
{
    my $params = {
    'format' => {
        data_type => 'string',
        description => 'Export format',
        required => '1',
    },
    'dto' => {
        data_type => 'ShapeBase',
        description => 'Shape DTO.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_shape_from_dto' } = { 
    	summary => 'Creates the shape from the DTO and returns the result in the specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_shape_from_dto {
    my ($self, %args) = @_;

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_shape_from_dto");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Svg' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # verify the required parameter 'dto' is set
    unless (exists $args{'dto'} && defined $args{'dto'} && $args{'dto'}) {
      croak("Missing the required parameter 'dto' when calling download_shape_from_dto");
    }

    # parse inputs
    my $_resource_path = '/slides/shape/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'dto'} && $args{'dto'}) {
        $_body_data = $args{'dto'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_shape_online
#
# Render shape to specified picture format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
# @param IShapeExportOptions $options Export options. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'Export options.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_shape_online' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_shape_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling download_shape_online");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling download_shape_online");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling download_shape_online");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_shape_online");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Svg' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # verify enum value
    if (exists $args{'bounds'} && $args{'bounds'} && !grep(/^$args{'bounds'}$/i, ( 'Slide', 'Shape', 'Appearance' ))) {
      croak("Invalid value for 'bounds': " . $args{'bounds'});
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/shapes/{shapeIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_slide
#
# Save a slide to a specified format.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param ExportOptions $options Export options. (optional)
# @param int $width The width of the slide representation in the output format; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param int $height The height of the slide representation in the output format; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'The width of the slide representation in the output format; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'The height of the slide representation in the output format; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_slide' } = { 
    	summary => 'Save a slide to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling download_slide");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_slide");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Html', 'Pdf', 'Xps', 'Pptx', 'Odp', 'Otp', 'Ppt', 'Pps', 'Ppsx', 'Pptm', 'Ppsm', 'Potx', 'Pot', 'Potm', 'Svg', 'Fodp', 'Xaml', 'Html5', 'Md', 'Xml' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_slide_online
#
# Save a slide to a specified format.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $format Output file format. (required)
# @param int $width The width of the slide representation in the output format; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param int $height The height of the slide representation in the output format; 0 to not adjust the size. Default is 0. (optional, default to 0)
# @param string $password Document password. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Storage folder containing custom fonts to be used with the document. (optional)
# @param ExportOptions $options Export options. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Output file format.',
        required => '1',
    },
    'width' => {
        data_type => 'int',
        description => 'The width of the slide representation in the output format; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'The height of the slide representation in the output format; 0 to not adjust the size. Default is 0.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder containing custom fonts to be used with the document.',
        required => '0',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_slide_online' } = { 
    	summary => 'Save a slide to a specified format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_slide_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling download_slide_online");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling download_slide_online");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_slide_online");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Html', 'Pdf', 'Xps', 'Pptx', 'Odp', 'Otp', 'Ppt', 'Pps', 'Ppsx', 'Pptm', 'Ppsm', 'Potx', 'Pot', 'Potm', 'Svg', 'Fodp', 'Xaml', 'Html5', 'Md', 'Xml' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_special_slide_shape
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param IShapeExportOptions $options Export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'Export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_special_slide_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_special_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling download_special_slide_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling download_special_slide_shape");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling download_special_slide_shape");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling download_special_slide_shape");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling download_special_slide_shape");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Svg' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # verify enum value
    if (exists $args{'bounds'} && $args{'bounds'} && !grep(/^$args{'bounds'}$/i, ( 'Slide', 'Shape', 'Appearance' ))) {
      croak("Invalid value for 'bounds': " . $args{'bounds'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/{format}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# get_animation
#
# Read slide animation effects.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. If specified, only effects related to that shape are returned. (optional)
# @param int $paragraph_index Paragraph index. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index. If specified, only effects related to that shape are returned.',
        required => '0',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_animation' } = { 
    	summary => 'Read slide animation effects.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub get_animation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_animation");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_animation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/animation';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_index'} && defined $args{'shape_index'}) {
        $query_params->{'shapeIndex'} = $self->{api_client}->to_query_value($args{'shape_index'});
    }

    # query params
    if (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
        $query_params->{'paragraphIndex'} = $self->{api_client}->to_query_value($args{'paragraph_index'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# get_api_info
#
# Get API info.
# 
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'get_api_info' } = { 
    	summary => 'Get API info.',
        params => $params,
        returns => 'ApiInfo',
        };
}
# @return ApiInfo
#
sub get_api_info {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/slides/info';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ApiInfo', $response);
    return $_response_object;
}

#
# get_available_fonts
#
# Returns presentation fonts info.
# 
# @param string $fonts_folder Storage folder for custom fonts. (optional)
# @param string $storage Storage for custom fonts. (optional)
{
    my $params = {
    'fonts_folder' => {
        data_type => 'string',
        description => 'Storage folder for custom fonts.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Storage for custom fonts.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_available_fonts' } = { 
    	summary => 'Returns presentation fonts info.',
        params => $params,
        returns => 'FontsData',
        };
}
# @return FontsData
#
sub get_available_fonts {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/slides/fonts/available';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FontsData', $response);
    return $_response_object;
}

#
# get_background
#
# Read slide background info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_background' } = { 
    	summary => 'Read slide background info.',
        params => $params,
        returns => 'SlideBackground',
        };
}
# @return SlideBackground
#
sub get_background {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_background");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_background");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/background';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideBackground', $response);
    return $_response_object;
}

#
# get_color_scheme
#
# Read slide theme color scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_color_scheme' } = { 
    	summary => 'Read slide theme color scheme info.',
        params => $params,
        returns => 'ColorScheme',
        };
}
# @return ColorScheme
#
sub get_color_scheme {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_color_scheme");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_color_scheme");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/theme/colorScheme';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ColorScheme', $response);
    return $_response_object;
}

#
# get_comment_authors
#
# Lists comment authors.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_comment_authors' } = { 
    	summary => 'Lists comment authors.',
        params => $params,
        returns => 'CommentAuthors',
        };
}
# @return CommentAuthors
#
sub get_comment_authors {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_comment_authors");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/comments/authors';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('CommentAuthors', $response);
    return $_response_object;
}

#
# get_disc_usage
#
# Get disc usage
# 
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_disc_usage' } = { 
    	summary => 'Get disc usage',
        params => $params,
        returns => 'DiscUsage',
        };
}
# @return DiscUsage
#
sub get_disc_usage {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/slides/storage/disc';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DiscUsage', $response);
    return $_response_object;
}

#
# get_document_properties
#
# Read presentation document properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_document_properties' } = { 
    	summary => 'Read presentation document properties.',
        params => $params,
        returns => 'DocumentProperties',
        };
}
# @return DocumentProperties
#
sub get_document_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_document_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperties', $response);
    return $_response_object;
}

#
# get_document_property
#
# Read presentation document property.
# 
# @param string $name Document name. (required)
# @param string $property_name The property name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'property_name' => {
        data_type => 'string',
        description => 'The property name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_document_property' } = { 
    	summary => 'Read presentation document property.',
        params => $params,
        returns => 'DocumentProperty',
        };
}
# @return DocumentProperty
#
sub get_document_property {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_document_property");
    }

    # verify the required parameter 'property_name' is set
    unless (exists $args{'property_name'} && defined $args{'property_name'} && $args{'property_name'}) {
      croak("Missing the required parameter 'property_name' when calling get_document_property");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/documentproperties/{propertyName}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'property_name'}) {
        my $_base_variable = "{" . "propertyName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'property_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentProperty', $response);
    return $_response_object;
}

#
# get_file_versions
#
# Get file versions
# 
# @param string $path File path e.g. &#39;/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_file_versions' } = { 
    	summary => 'Get file versions',
        params => $params,
        returns => 'FileVersions',
        };
}
# @return FileVersions
#
sub get_file_versions {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && defined $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_file_versions");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/version/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FileVersions', $response);
    return $_response_object;
}

#
# get_files_list
#
# Get all files and folders within a folder
# 
# @param string $path Folder path e.g. &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path e.g. &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_files_list' } = { 
    	summary => 'Get all files and folders within a folder',
        params => $params,
        returns => 'FilesList',
        };
}
# @return FilesList
#
sub get_files_list {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && defined $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_files_list");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FilesList', $response);
    return $_response_object;
}

#
# get_font_scheme
#
# Read slide theme font scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_font_scheme' } = { 
    	summary => 'Read slide theme font scheme info.',
        params => $params,
        returns => 'FontScheme',
        };
}
# @return FontScheme
#
sub get_font_scheme {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_font_scheme");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_font_scheme");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/theme/fontScheme';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FontScheme', $response);
    return $_response_object;
}

#
# get_fonts
#
# Returns presentation fonts info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_fonts' } = { 
    	summary => 'Returns presentation fonts info.',
        params => $params,
        returns => 'FontsData',
        };
}
# @return FontsData
#
sub get_fonts {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_fonts");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fonts';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FontsData', $response);
    return $_response_object;
}

#
# get_fonts_online
#
# Returns presentation fonts info.
# 
# @param File $document Document data. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_fonts_online' } = { 
    	summary => 'Returns presentation fonts info.',
        params => $params,
        returns => 'FontsData',
        };
}
# @return FontsData
#
sub get_fonts_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling get_fonts_online");
    }

    # parse inputs
    my $_resource_path = '/slides/fonts';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FontsData', $response);
    return $_response_object;
}

#
# get_format_scheme
#
# Read slide theme format scheme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_format_scheme' } = { 
    	summary => 'Read slide theme format scheme info.',
        params => $params,
        returns => 'FormatScheme',
        };
}
# @return FormatScheme
#
sub get_format_scheme {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_format_scheme");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_format_scheme");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/theme/formatScheme';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FormatScheme', $response);
    return $_response_object;
}

#
# get_html5_templates
#
# Get default templates for HTML5 export.
# 
{
    my $params = {
    };
    __PACKAGE__->method_documentation->{ 'get_html5_templates' } = { 
    	summary => 'Get default templates for HTML5 export.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub get_html5_templates {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/slides/html5Templates';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# get_layout_slide
#
# Read presentation layoutSlide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_layout_slide' } = { 
    	summary => 'Read presentation layoutSlide info.',
        params => $params,
        returns => 'LayoutSlide',
        };
}
# @return LayoutSlide
#
sub get_layout_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_layout_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_layout_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/layoutSlides/{slideIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LayoutSlide', $response);
    return $_response_object;
}

#
# get_layout_slides
#
# Read presentation layoutSlides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_layout_slides' } = { 
    	summary => 'Read presentation layoutSlides info.',
        params => $params,
        returns => 'LayoutSlides',
        };
}
# @return LayoutSlides
#
sub get_layout_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_layout_slides");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/layoutSlides';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('LayoutSlides', $response);
    return $_response_object;
}

#
# get_master_slide
#
# Read presentation masterSlide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_master_slide' } = { 
    	summary => 'Read presentation masterSlide info.',
        params => $params,
        returns => 'MasterSlide',
        };
}
# @return MasterSlide
#
sub get_master_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_master_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_master_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/masterSlides/{slideIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MasterSlide', $response);
    return $_response_object;
}

#
# get_master_slides
#
# Read presentation masterSlides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_master_slides' } = { 
    	summary => 'Read presentation masterSlides info.',
        params => $params,
        returns => 'MasterSlides',
        };
}
# @return MasterSlides
#
sub get_master_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_master_slides");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/masterSlides';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('MasterSlides', $response);
    return $_response_object;
}

#
# get_notes_slide
#
# Read notes slide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide' } = { 
    	summary => 'Read notes slide info.',
        params => $params,
        returns => 'NotesSlide',
        };
}
# @return NotesSlide
#
sub get_notes_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlide', $response);
    return $_response_object;
}

#
# get_notes_slide_header_footer
#
# Get header/footer info for the notes slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_header_footer' } = { 
    	summary => 'Get header/footer info for the notes slide.',
        params => $params,
        returns => 'NotesSlideHeaderFooter',
        };
}
# @return NotesSlideHeaderFooter
#
sub get_notes_slide_header_footer {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_notes_slide_header_footer");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_header_footer");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/headerFooter';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlideHeaderFooter', $response);
    return $_response_object;
}

#
# get_notes_slide_online
#
# Read notes slide info.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_notes_slide_online' } = { 
    	summary => 'Read notes slide info.',
        params => $params,
        returns => 'NotesSlide',
        };
}
# @return NotesSlide
#
sub get_notes_slide_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling get_notes_slide_online");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_notes_slide_online");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/notesSlide';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('NotesSlide', $response);
    return $_response_object;
}

#
# get_paragraph
#
# Read shape paragraph info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_paragraph' } = { 
    	summary => 'Read shape paragraph info.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# get_paragraph_effective
#
# Read effective paragraph info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_paragraph_effective' } = { 
    	summary => 'Read effective paragraph info.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_paragraph_effective {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_paragraph_effective");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_paragraph_effective");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_paragraph_effective");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_paragraph_effective");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/effective';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# get_paragraph_rectangle
#
# Return coordinates of rect that bounds paragraph. The rect includes all the lines of text in paragraph, including empty ones.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_paragraph_rectangle' } = { 
    	summary => 'Return coordinates of rect that bounds paragraph. The rect includes all the lines of text in paragraph, including empty ones.',
        params => $params,
        returns => 'TextBounds',
        };
}
# @return TextBounds
#
sub get_paragraph_rectangle {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_paragraph_rectangle");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_paragraph_rectangle");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_paragraph_rectangle");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_paragraph_rectangle");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/bounds';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextBounds', $response);
    return $_response_object;
}

#
# get_paragraphs
#
# Read shape paragraphs info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_paragraphs' } = { 
    	summary => 'Read shape paragraphs info.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# get_placeholder
#
# Read slide placeholder info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $placeholder_index Placeholder index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'placeholder_index' => {
        data_type => 'int',
        description => 'Placeholder index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_placeholder' } = { 
    	summary => 'Read slide placeholder info.',
        params => $params,
        returns => 'Placeholder',
        };
}
# @return Placeholder
#
sub get_placeholder {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_placeholder");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_placeholder");
    }

    # verify the required parameter 'placeholder_index' is set
    unless (exists $args{'placeholder_index'} && defined $args{'placeholder_index'}) {
      croak("Missing the required parameter 'placeholder_index' when calling get_placeholder");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/placeholders/{placeholderIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'placeholder_index'}) {
        my $_base_variable = "{" . "placeholderIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'placeholder_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Placeholder', $response);
    return $_response_object;
}

#
# get_placeholders
#
# Read slide placeholders info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_placeholders' } = { 
    	summary => 'Read slide placeholders info.',
        params => $params,
        returns => 'Placeholders',
        };
}
# @return Placeholders
#
sub get_placeholders {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_placeholders");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_placeholders");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/placeholders';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Placeholders', $response);
    return $_response_object;
}

#
# get_portion
#
# Read paragraph portion info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_portion' } = { 
    	summary => 'Read paragraph portion info.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling get_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# get_portion_effective
#
# Read effective portion info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_portion_effective' } = { 
    	summary => 'Read effective portion info.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_portion_effective {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_portion_effective");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_portion_effective");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_portion_effective");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_portion_effective");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling get_portion_effective");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}/effective';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# get_portion_rectangle
#
# Return coordinates of rect that bounds paragraph. The rect includes all the lines of text in paragraph, including empty ones.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_portion_rectangle' } = { 
    	summary => 'Return coordinates of rect that bounds paragraph. The rect includes all the lines of text in paragraph, including empty ones.',
        params => $params,
        returns => 'TextBounds',
        };
}
# @return TextBounds
#
sub get_portion_rectangle {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_portion_rectangle");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_portion_rectangle");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_portion_rectangle");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_portion_rectangle");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling get_portion_rectangle");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}/bounds';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextBounds', $response);
    return $_response_object;
}

#
# get_portions
#
# Read paragraph portions info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_portions' } = { 
    	summary => 'Read paragraph portions info.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# get_presentation
#
# Read presentation info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_presentation' } = { 
    	summary => 'Read presentation info.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub get_presentation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_presentation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# get_presentation_images
#
# Read presentation images info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_presentation_images' } = { 
    	summary => 'Read presentation images info.',
        params => $params,
        returns => 'Images',
        };
}
# @return Images
#
sub get_presentation_images {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_presentation_images");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Images', $response);
    return $_response_object;
}

#
# get_presentation_text_items
#
# Extract presentation text items.
# 
# @param string $name Document name. (required)
# @param boolean $with_empty True to incude empty items. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'with_empty' => {
        data_type => 'boolean',
        description => 'True to incude empty items.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_presentation_text_items' } = { 
    	summary => 'Extract presentation text items.',
        params => $params,
        returns => 'TextItems',
        };
}
# @return TextItems
#
sub get_presentation_text_items {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_presentation_text_items");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/textItems';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'with_empty'} && defined $args{'with_empty'}) {
        $query_params->{'withEmpty'} = $self->{api_client}->to_boolean_query_value($args{'with_empty'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItems', $response);
    return $_response_object;
}

#
# get_protection_properties
#
# Read presentation protection properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_protection_properties' } = { 
    	summary => 'Read presentation protection properties.',
        params => $params,
        returns => 'ProtectionProperties',
        };
}
# @return ProtectionProperties
#
sub get_protection_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_protection_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/protection';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ProtectionProperties', $response);
    return $_response_object;
}

#
# get_sections
#
# Read presentation sections info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_sections' } = { 
    	summary => 'Read presentation sections info.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub get_sections {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_sections");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# get_shape
#
# Read slide shape info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_shape' } = { 
    	summary => 'Read slide shape info.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub get_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# get_shape_geometry_path
#
# Returns geometry path of the shape
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_shape_geometry_path' } = { 
    	summary => 'Returns geometry path of the shape',
        params => $params,
        returns => 'GeometryPaths',
        };
}
# @return GeometryPaths
#
sub get_shape_geometry_path {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_shape_geometry_path");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_shape_geometry_path");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_shape_geometry_path");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/geometryPath';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('GeometryPaths', $response);
    return $_response_object;
}

#
# get_shapes
#
# Read slide shapes info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $shape_type Shape type. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2\&quot;). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'shape_type' => {
        data_type => 'string',
        description => 'Shape type.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2\&quot;).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_shapes' } = { 
    	summary => 'Read slide shapes info.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub get_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_shapes");
    }

    # verify enum value
    if (exists $args{'shape_type'} && $args{'shape_type'} && !grep(/^$args{'shape_type'}$/i, ( 'Shape', 'Chart', 'Table', 'PictureFrame', 'VideoFrame', 'AudioFrame', 'SmartArt', 'OleObjectFrame', 'GroupShape', 'GraphicalObject', 'Connector', 'SmartArtShape', 'ZoomFrame', 'SectionZoomFrame', 'SummaryZoomFrame', 'SummaryZoomSection' ))) {
      croak("Invalid value for 'shape_type': " . $args{'shape_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'shape_type'} && defined $args{'shape_type'}) {
        $query_params->{'shapeType'} = $self->{api_client}->to_query_value($args{'shape_type'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# get_slide
#
# Read presentation slide info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide' } = { 
    	summary => 'Read presentation slide info.',
        params => $params,
        returns => 'Slide',
        };
}
# @return Slide
#
sub get_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slide', $response);
    return $_response_object;
}

#
# get_slide_comments
#
# Read presentation slide comments.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_comments' } = { 
    	summary => 'Read presentation slide comments.',
        params => $params,
        returns => 'SlideComments',
        };
}
# @return SlideComments
#
sub get_slide_comments {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_comments");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_comments");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/comments';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideComments', $response);
    return $_response_object;
}

#
# get_slide_header_footer
#
# Get footer info for the slide.
# 
# @param string $name Document name. (required)
# @param int $slide_index The position of the slide to be reordered. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'The position of the slide to be reordered.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_header_footer' } = { 
    	summary => 'Get footer info for the slide.',
        params => $params,
        returns => 'HeaderFooter',
        };
}
# @return HeaderFooter
#
sub get_slide_header_footer {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_header_footer");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_header_footer");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/headerFooter';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('HeaderFooter', $response);
    return $_response_object;
}

#
# get_slide_images
#
# Read slide images info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_images' } = { 
    	summary => 'Read slide images info.',
        params => $params,
        returns => 'Images',
        };
}
# @return Images
#
sub get_slide_images {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_images");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_images");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/images';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Images', $response);
    return $_response_object;
}

#
# get_slide_properties
#
# Read presentation slide properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_properties' } = { 
    	summary => 'Read presentation slide properties.',
        params => $params,
        returns => 'SlideProperties',
        };
}
# @return SlideProperties
#
sub get_slide_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slideProperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideProperties', $response);
    return $_response_object;
}

#
# get_slide_show_properties
#
# Read presentation slide show properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_show_properties' } = { 
    	summary => 'Read presentation slide show properties.',
        params => $params,
        returns => 'SlideShowProperties',
        };
}
# @return SlideShowProperties
#
sub get_slide_show_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_show_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slideShowProperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideShowProperties', $response);
    return $_response_object;
}

#
# get_slide_text_items
#
# Extract slide text items.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param boolean $with_empty True to include empty items. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'with_empty' => {
        data_type => 'boolean',
        description => 'True to include empty items.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slide_text_items' } = { 
    	summary => 'Extract slide text items.',
        params => $params,
        returns => 'TextItems',
        };
}
# @return TextItems
#
sub get_slide_text_items {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slide_text_items");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_slide_text_items");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/textItems';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'with_empty'} && defined $args{'with_empty'}) {
        $query_params->{'withEmpty'} = $self->{api_client}->to_boolean_query_value($args{'with_empty'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('TextItems', $response);
    return $_response_object;
}

#
# get_slides
#
# Read presentation slides info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_slides' } = { 
    	summary => 'Read presentation slides info.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub get_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_slides");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# get_special_slide_animation
#
# Read special slide (master, layout, notes) animation effects.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. If specified, only effects related to that shape are returned. (optional)
# @param int $paragraph_index Paragraph index. If specified, only effects related to that paragraph are returned. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index. If specified, only effects related to that shape are returned.',
        required => '0',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index. If specified, only effects related to that paragraph are returned.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_special_slide_animation' } = { 
    	summary => 'Read special slide (master, layout, notes) animation effects.',
        params => $params,
        returns => 'SlideAnimation',
        };
}
# @return SlideAnimation
#
sub get_special_slide_animation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_special_slide_animation");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_special_slide_animation");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling get_special_slide_animation");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/animation';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'shape_index'} && defined $args{'shape_index'}) {
        $query_params->{'shapeIndex'} = $self->{api_client}->to_query_value($args{'shape_index'});
    }

    # query params
    if (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
        $query_params->{'paragraphIndex'} = $self->{api_client}->to_query_value($args{'paragraph_index'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideAnimation', $response);
    return $_response_object;
}

#
# get_special_slide_paragraph
#
# Read shape paragraph info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_special_slide_paragraph' } = { 
    	summary => 'Read shape paragraph info.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_special_slide_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_special_slide_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_special_slide_paragraph");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling get_special_slide_paragraph");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_special_slide_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_special_slide_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# get_special_slide_paragraphs
#
# Read special shape paragraphs info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_special_slide_paragraphs' } = { 
    	summary => 'Read special shape paragraphs info.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_special_slide_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_special_slide_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_special_slide_paragraphs");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling get_special_slide_paragraphs");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_special_slide_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# get_special_slide_portion
#
# Read paragraph portion info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_special_slide_portion' } = { 
    	summary => 'Read paragraph portion info.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_special_slide_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_special_slide_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_special_slide_portion");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling get_special_slide_portion");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_special_slide_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_special_slide_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling get_special_slide_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# get_special_slide_portions
#
# Read paragraph portions info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_special_slide_portions' } = { 
    	summary => 'Read paragraph portions info.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_special_slide_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_special_slide_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_special_slide_portions");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling get_special_slide_portions");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_special_slide_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_special_slide_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# get_special_slide_shape
#
# Read special slide shape info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param int $shape_index Shape index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_special_slide_shape' } = { 
    	summary => 'Read special slide shape info.',
        params => $params,
        returns => 'ShapeBase',
        };
}
# @return ShapeBase
#
sub get_special_slide_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_special_slide_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_special_slide_shape");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling get_special_slide_shape");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_special_slide_shape");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ShapeBase', $response);
    return $_response_object;
}

#
# get_special_slide_shapes
#
# Read special slide shapes info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Parent slide index. (required)
# @param string $slide_type Slide type (master, layout or notes). (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Parent slide index.',
        required => '1',
    },
    'slide_type' => {
        data_type => 'string',
        description => 'Slide type (master, layout or notes).',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_special_slide_shapes' } = { 
    	summary => 'Read special slide shapes info.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub get_special_slide_shapes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_special_slide_shapes");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_special_slide_shapes");
    }

    # verify the required parameter 'slide_type' is set
    unless (exists $args{'slide_type'} && defined $args{'slide_type'} && $args{'slide_type'}) {
      croak("Missing the required parameter 'slide_type' when calling get_special_slide_shapes");
    }

    # verify enum value
    if (!grep(/^$args{'slide_type'}$/i, ( 'MasterSlide', 'LayoutSlide', 'NotesSlide' ))) {
      croak("Invalid value for 'slide_type': " . $args{'slide_type'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/{slideType}/shapes';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_type'}) {
        my $_base_variable = "{" . "slideType" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_type'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# get_table_cell_paragraph
#
# Returns paragraph info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param int $cell_index Table cell index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'cell_index' => {
        data_type => 'int',
        description => 'Table cell index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_table_cell_paragraph' } = { 
    	summary => 'Returns paragraph info.',
        params => $params,
        returns => 'Paragraph',
        };
}
# @return Paragraph
#
sub get_table_cell_paragraph {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_table_cell_paragraph");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_table_cell_paragraph");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_table_cell_paragraph");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling get_table_cell_paragraph");
    }

    # verify the required parameter 'cell_index' is set
    unless (exists $args{'cell_index'} && defined $args{'cell_index'}) {
      croak("Missing the required parameter 'cell_index' when calling get_table_cell_paragraph");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_table_cell_paragraph");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_index'}) {
        my $_base_variable = "{" . "cellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraph', $response);
    return $_response_object;
}

#
# get_table_cell_paragraphs
#
# Returns table cell paragraphs.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param int $cell_index Table cell index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'cell_index' => {
        data_type => 'int',
        description => 'Table cell index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_table_cell_paragraphs' } = { 
    	summary => 'Returns table cell paragraphs.',
        params => $params,
        returns => 'Paragraphs',
        };
}
# @return Paragraphs
#
sub get_table_cell_paragraphs {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_table_cell_paragraphs");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_table_cell_paragraphs");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_table_cell_paragraphs");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling get_table_cell_paragraphs");
    }

    # verify the required parameter 'cell_index' is set
    unless (exists $args{'cell_index'} && defined $args{'cell_index'}) {
      croak("Missing the required parameter 'cell_index' when calling get_table_cell_paragraphs");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_index'}) {
        my $_base_variable = "{" . "cellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Paragraphs', $response);
    return $_response_object;
}

#
# get_table_cell_portion
#
# Returns table cell portion.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param int $cell_index Table cell index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'cell_index' => {
        data_type => 'int',
        description => 'Table cell index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_table_cell_portion' } = { 
    	summary => 'Returns table cell portion.',
        params => $params,
        returns => 'Portion',
        };
}
# @return Portion
#
sub get_table_cell_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_table_cell_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_table_cell_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_table_cell_portion");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling get_table_cell_portion");
    }

    # verify the required parameter 'cell_index' is set
    unless (exists $args{'cell_index'} && defined $args{'cell_index'}) {
      croak("Missing the required parameter 'cell_index' when calling get_table_cell_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_table_cell_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling get_table_cell_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_index'}) {
        my $_base_variable = "{" . "cellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portion', $response);
    return $_response_object;
}

#
# get_table_cell_portions
#
# Returns table cell portions.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $row_index Row index. (required)
# @param int $cell_index Table cell index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'row_index' => {
        data_type => 'int',
        description => 'Row index.',
        required => '1',
    },
    'cell_index' => {
        data_type => 'int',
        description => 'Table cell index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_table_cell_portions' } = { 
    	summary => 'Returns table cell portions.',
        params => $params,
        returns => 'Portions',
        };
}
# @return Portions
#
sub get_table_cell_portions {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_table_cell_portions");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_table_cell_portions");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling get_table_cell_portions");
    }

    # verify the required parameter 'row_index' is set
    unless (exists $args{'row_index'} && defined $args{'row_index'}) {
      croak("Missing the required parameter 'row_index' when calling get_table_cell_portions");
    }

    # verify the required parameter 'cell_index' is set
    unless (exists $args{'cell_index'} && defined $args{'cell_index'}) {
      croak("Missing the required parameter 'cell_index' when calling get_table_cell_portions");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling get_table_cell_portions");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/rows/{rowIndex}/cells/{cellIndex}/paragraphs/{paragraphIndex}/portions';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'row_index'}) {
        my $_base_variable = "{" . "rowIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'row_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'cell_index'}) {
        my $_base_variable = "{" . "cellIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'cell_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Portions', $response);
    return $_response_object;
}

#
# get_theme
#
# Read slide theme info.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_theme' } = { 
    	summary => 'Read slide theme info.',
        params => $params,
        returns => 'Theme',
        };
}
# @return Theme
#
sub get_theme {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_theme");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling get_theme");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/theme';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Theme', $response);
    return $_response_object;
}

#
# get_vba_module
#
# Get VBA module info.
# 
# @param string $name Document name. (required)
# @param int $module_index The index of the macros module to remove. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'module_index' => {
        data_type => 'int',
        description => 'The index of the macros module to remove.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_vba_module' } = { 
    	summary => 'Get VBA module info.',
        params => $params,
        returns => 'VbaModule',
        };
}
# @return VbaModule
#
sub get_vba_module {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_vba_module");
    }

    # verify the required parameter 'module_index' is set
    unless (exists $args{'module_index'} && defined $args{'module_index'}) {
      croak("Missing the required parameter 'module_index' when calling get_vba_module");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/vbaProject/modules/{moduleIndex}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'module_index'}) {
        my $_base_variable = "{" . "moduleIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'module_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('VbaModule', $response);
    return $_response_object;
}

#
# get_vba_project
#
# Get VBA project info.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_vba_project' } = { 
    	summary => 'Get VBA project info.',
        params => $params,
        returns => 'VbaProject',
        };
}
# @return VbaProject
#
sub get_vba_project {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_vba_project");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/vbaProject';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('VbaProject', $response);
    return $_response_object;
}

#
# get_view_properties
#
# Read presentation view properties.
# 
# @param string $name Document name. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_view_properties' } = { 
    	summary => 'Read presentation view properties.',
        params => $params,
        returns => 'ViewProperties',
        };
}
# @return ViewProperties
#
sub get_view_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling get_view_properties");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/viewProperties';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ViewProperties', $response);
    return $_response_object;
}

#
# highlight_presentation_regex
#
# Highlight all matches of sample in text frame text using specified color.
# 
# @param string $name Document name. (required)
# @param string $regex Regular expression. (required)
# @param string $color Highlighting color. (required)
# @param boolean $ignore_case True to search ignoring char case. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'regex' => {
        data_type => 'string',
        description => 'Regular expression.',
        required => '1',
    },
    'color' => {
        data_type => 'string',
        description => 'Highlighting color.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True to search ignoring char case.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'highlight_presentation_regex' } = { 
    	summary => 'Highlight all matches of sample in text frame text using specified color.',
        params => $params,
        returns => 'DocumentReplaceResult',
        };
}
# @return DocumentReplaceResult
#
sub highlight_presentation_regex {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling highlight_presentation_regex");
    }

    # verify the required parameter 'regex' is set
    unless (exists $args{'regex'} && defined $args{'regex'} && $args{'regex'}) {
      croak("Missing the required parameter 'regex' when calling highlight_presentation_regex");
    }

    # verify the required parameter 'color' is set
    unless (exists $args{'color'} && defined $args{'color'} && $args{'color'}) {
      croak("Missing the required parameter 'color' when calling highlight_presentation_regex");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/highlightRegex';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'regex'} && defined $args{'regex'}) {
        $query_params->{'regex'} = $self->{api_client}->to_query_value($args{'regex'});
    }

    # query params
    if (exists $args{'color'} && defined $args{'color'}) {
        $query_params->{'color'} = $self->{api_client}->to_query_value($args{'color'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentReplaceResult', $response);
    return $_response_object;
}

#
# highlight_presentation_text
#
# Highlight all matches of sample using specified color.
# 
# @param string $name Document name. (required)
# @param string $text Text sample to highlight. (required)
# @param string $color Highlighting color. (required)
# @param boolean $whole_words_only Match only whole words. (optional, default to false)
# @param boolean $ignore_case True to search ignoring char case. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'text' => {
        data_type => 'string',
        description => 'Text sample to highlight.',
        required => '1',
    },
    'color' => {
        data_type => 'string',
        description => 'Highlighting color.',
        required => '1',
    },
    'whole_words_only' => {
        data_type => 'boolean',
        description => 'Match only whole words.',
        required => '0',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True to search ignoring char case.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'highlight_presentation_text' } = { 
    	summary => 'Highlight all matches of sample using specified color.',
        params => $params,
        returns => 'DocumentReplaceResult',
        };
}
# @return DocumentReplaceResult
#
sub highlight_presentation_text {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling highlight_presentation_text");
    }

    # verify the required parameter 'text' is set
    unless (exists $args{'text'} && defined $args{'text'} && $args{'text'}) {
      croak("Missing the required parameter 'text' when calling highlight_presentation_text");
    }

    # verify the required parameter 'color' is set
    unless (exists $args{'color'} && defined $args{'color'} && $args{'color'}) {
      croak("Missing the required parameter 'color' when calling highlight_presentation_text");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/highlightText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'text'} && defined $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if (exists $args{'color'} && defined $args{'color'}) {
        $query_params->{'color'} = $self->{api_client}->to_query_value($args{'color'});
    }

    # query params
    if (exists $args{'whole_words_only'} && defined $args{'whole_words_only'}) {
        $query_params->{'wholeWordsOnly'} = $self->{api_client}->to_boolean_query_value($args{'whole_words_only'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentReplaceResult', $response);
    return $_response_object;
}

#
# highlight_shape_regex
#
# Highlight all matches of sample in text frame text using specified color.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $regex Regular expression. (required)
# @param string $color Highlighting color. (required)
# @param boolean $ignore_case True to search ignoring char case. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'regex' => {
        data_type => 'string',
        description => 'Regular expression.',
        required => '1',
    },
    'color' => {
        data_type => 'string',
        description => 'Highlighting color.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True to search ignoring char case.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'highlight_shape_regex' } = { 
    	summary => 'Highlight all matches of sample in text frame text using specified color.',
        params => $params,
        returns => 'Shape',
        };
}
# @return Shape
#
sub highlight_shape_regex {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling highlight_shape_regex");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling highlight_shape_regex");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling highlight_shape_regex");
    }

    # verify the required parameter 'regex' is set
    unless (exists $args{'regex'} && defined $args{'regex'} && $args{'regex'}) {
      croak("Missing the required parameter 'regex' when calling highlight_shape_regex");
    }

    # verify the required parameter 'color' is set
    unless (exists $args{'color'} && defined $args{'color'} && $args{'color'}) {
      croak("Missing the required parameter 'color' when calling highlight_shape_regex");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/highlightRegex';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'regex'} && defined $args{'regex'}) {
        $query_params->{'regex'} = $self->{api_client}->to_query_value($args{'regex'});
    }

    # query params
    if (exists $args{'color'} && defined $args{'color'}) {
        $query_params->{'color'} = $self->{api_client}->to_query_value($args{'color'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shape', $response);
    return $_response_object;
}

#
# highlight_shape_text
#
# Highlight all matches of sample in text frame text using specified color.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param string $text Text sample to highlight. (required)
# @param string $color Highlighting color. (required)
# @param boolean $whole_words_only Match only whole words. (optional, default to false)
# @param boolean $ignore_case True to search ignoring char case. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'text' => {
        data_type => 'string',
        description => 'Text sample to highlight.',
        required => '1',
    },
    'color' => {
        data_type => 'string',
        description => 'Highlighting color.',
        required => '1',
    },
    'whole_words_only' => {
        data_type => 'boolean',
        description => 'Match only whole words.',
        required => '0',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True to search ignoring char case.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'highlight_shape_text' } = { 
    	summary => 'Highlight all matches of sample in text frame text using specified color.',
        params => $params,
        returns => 'Shape',
        };
}
# @return Shape
#
sub highlight_shape_text {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling highlight_shape_text");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling highlight_shape_text");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling highlight_shape_text");
    }

    # verify the required parameter 'text' is set
    unless (exists $args{'text'} && defined $args{'text'} && $args{'text'}) {
      croak("Missing the required parameter 'text' when calling highlight_shape_text");
    }

    # verify the required parameter 'color' is set
    unless (exists $args{'color'} && defined $args{'color'} && $args{'color'}) {
      croak("Missing the required parameter 'color' when calling highlight_shape_text");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/highlightText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'text'} && defined $args{'text'}) {
        $query_params->{'text'} = $self->{api_client}->to_query_value($args{'text'});
    }

    # query params
    if (exists $args{'color'} && defined $args{'color'}) {
        $query_params->{'color'} = $self->{api_client}->to_query_value($args{'color'});
    }

    # query params
    if (exists $args{'whole_words_only'} && defined $args{'whole_words_only'}) {
        $query_params->{'wholeWordsOnly'} = $self->{api_client}->to_boolean_query_value($args{'whole_words_only'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shape', $response);
    return $_response_object;
}

#
# import_from_html
#
# Create presentation document from html.
# 
# @param string $name Document name. (required)
# @param string $html HTML data. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'html' => {
        data_type => 'string',
        description => 'HTML data.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'import_from_html' } = { 
    	summary => 'Create presentation document from html.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub import_from_html {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling import_from_html");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fromHtml';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'html'} && $args{'html'}) {
        $_body_data = $args{'html'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# import_from_pdf
#
# Create presentation document from pdf or append pdf to an existing presentation.
# 
# @param string $name Document name. (required)
# @param File $pdf PDF data. (required)
# @param PdfImportOptions $options Import options. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'pdf' => {
        data_type => 'File',
        description => 'PDF data.',
        required => '1',
    },
    'options' => {
        data_type => 'PdfImportOptions',
        description => 'Import options.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'import_from_pdf' } = { 
    	summary => 'Create presentation document from pdf or append pdf to an existing presentation.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub import_from_pdf {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling import_from_pdf");
    }

    # verify the required parameter 'pdf' is set
    unless (exists $args{'pdf'} && defined $args{'pdf'} && $args{'pdf'}) {
      croak("Missing the required parameter 'pdf' when calling import_from_pdf");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fromPdf';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'pdf'} && $args{'pdf'}) {
        push(@$files, $args{'pdf'});
    }
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# import_shapes_from_svg
#
# Imports shapes from SVG file.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param File $image SVG image data. (optional)
# @param int $x The X coordinate of the imported group of shapes (0 is default if not specified). (optional)
# @param int $y The Y coordinate of the imported group of shapes (0 is default if not specified). (optional)
# @param int $width The width of the imported group of shapes (default is SVG image width). (optional)
# @param int $height The height of the imported group of shapes (default is SVG image width). (optional)
# @param int[] $shapes Indexes of shapes to import. All shapes are imported if not specified. (optional)
# @param boolean $group If true, the set of shapes will be imported as a one group shape. (optional)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'image' => {
        data_type => 'File',
        description => 'SVG image data.',
        required => '0',
    },
    'x' => {
        data_type => 'int',
        description => 'The X coordinate of the imported group of shapes (0 is default if not specified).',
        required => '0',
    },
    'y' => {
        data_type => 'int',
        description => 'The Y coordinate of the imported group of shapes (0 is default if not specified).',
        required => '0',
    },
    'width' => {
        data_type => 'int',
        description => 'The width of the imported group of shapes (default is SVG image width).',
        required => '0',
    },
    'height' => {
        data_type => 'int',
        description => 'The height of the imported group of shapes (default is SVG image width).',
        required => '0',
    },
    'shapes' => {
        data_type => 'int[]',
        description => 'Indexes of shapes to import. All shapes are imported if not specified.',
        required => '0',
    },
    'group' => {
        data_type => 'boolean',
        description => 'If true, the set of shapes will be imported as a one group shape.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'import_shapes_from_svg' } = { 
    	summary => 'Imports shapes from SVG file.',
        params => $params,
        returns => 'Shapes',
        };
}
# @return Shapes
#
sub import_shapes_from_svg {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling import_shapes_from_svg");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling import_shapes_from_svg");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/fromSvg';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'x'} && defined $args{'x'}) {
        $query_params->{'x'} = $self->{api_client}->to_query_value($args{'x'});
    }

    # query params
    if (exists $args{'y'} && defined $args{'y'}) {
        $query_params->{'y'} = $self->{api_client}->to_query_value($args{'y'});
    }

    # query params
    if (exists $args{'width'} && defined $args{'width'}) {
        $query_params->{'width'} = $self->{api_client}->to_query_value($args{'width'});
    }

    # query params
    if (exists $args{'height'} && defined $args{'height'}) {
        $query_params->{'height'} = $self->{api_client}->to_query_value($args{'height'});
    }

    # query params
    if (exists $args{'shapes'} && defined $args{'shapes'}) {
        $query_params->{'shapes'} = $self->{api_client}->to_query_value($args{'shapes'});
    }

    # query params
    if (exists $args{'group'} && defined $args{'group'}) {
        $query_params->{'group'} = $self->{api_client}->to_boolean_query_value($args{'group'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'image'} && $args{'image'}) {
        push(@$files, $args{'image'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Shapes', $response);
    return $_response_object;
}

#
# merge
#
# Merge the presentation with other presentations specified in the request parameter.
# 
# @param string $name Document name. (required)
# @param PresentationsMergeRequest $request PresentationsMergeRequest with a list of presentations to merge. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'request' => {
        data_type => 'PresentationsMergeRequest',
        description => 'PresentationsMergeRequest with a list of presentations to merge.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'merge' } = { 
    	summary => 'Merge the presentation with other presentations specified in the request parameter.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling merge");
    }

    # verify the required parameter 'request' is set
    unless (exists $args{'request'} && defined $args{'request'} && $args{'request'}) {
      croak("Missing the required parameter 'request' when calling merge");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'request'} && $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# merge_and_save_online
#
# Merges presentations or some of their slides specified in the request parameter. Result will be save in the storage.
# 
# @param string $out_path Path to save result. (required)
# @param ARRAY[string] $files Files to merge (optional)
# @param OrderedMergeRequest $request Merge request. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result.',
        required => '1',
    },
    'files' => {
        data_type => 'ARRAY[string]',
        description => 'Files to merge',
        required => '0',
    },
    'request' => {
        data_type => 'OrderedMergeRequest',
        description => 'Merge request.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'merge_and_save_online' } = { 
    	summary => 'Merges presentations or some of their slides specified in the request parameter. Result will be save in the storage.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub merge_and_save_online {
    my ($self, %args) = @_;

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && defined $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling merge_and_save_online");
    }

    # parse inputs
    my $_resource_path = '/slides/merge';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'files'} && $args{'files'}) {
        my $arg_files = $args{'files'};
        push(@$files, @$arg_files);
    }
    # body params
    if ( exists $args{'request'} && $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# merge_online
#
# Merges presentations or some of their slides specified in the request parameter. Returns result file in the response. 
# 
# @param ARRAY[string] $files Files to merge (optional)
# @param OrderedMergeRequest $request Merge request. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'files' => {
        data_type => 'ARRAY[string]',
        description => 'Files to merge',
        required => '0',
    },
    'request' => {
        data_type => 'OrderedMergeRequest',
        description => 'Merge request.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'merge_online' } = { 
    	summary => 'Merges presentations or some of their slides specified in the request parameter. Returns result file in the response. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub merge_online {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/slides/merge';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'files'} && $args{'files'}) {
        my $arg_files = $args{'files'};
        push(@$files, @$arg_files);
    }
    # body params
    if ( exists $args{'request'} && $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# merge_table_cells
#
# Merge table cells.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param TableCellMergeOptions $table_cell_merge_options Merge settings. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'table_cell_merge_options' => {
        data_type => 'TableCellMergeOptions',
        description => 'Merge settings.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'merge_table_cells' } = { 
    	summary => 'Merge table cells.',
        params => $params,
        returns => 'Table',
        };
}
# @return Table
#
sub merge_table_cells {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling merge_table_cells");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling merge_table_cells");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling merge_table_cells");
    }

    # verify the required parameter 'table_cell_merge_options' is set
    unless (exists $args{'table_cell_merge_options'} && defined $args{'table_cell_merge_options'} && $args{'table_cell_merge_options'}) {
      croak("Missing the required parameter 'table_cell_merge_options' when calling merge_table_cells");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/mergeCells';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'table_cell_merge_options'} && $args{'table_cell_merge_options'}) {
        $_body_data = $args{'table_cell_merge_options'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Table', $response);
    return $_response_object;
}

#
# move_file
#
# Move file
# 
# @param string $src_path Source file path e.g. &#39;/src.ext&#39; (required)
# @param string $dest_path Destination file path e.g. &#39;/dest.ext&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
# @param string $version_id File version ID to move (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source file path e.g. &#39;/src.ext&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination file path e.g. &#39;/dest.ext&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to move',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_file' } = { 
    	summary => 'Move file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub move_file {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'} && defined $args{'src_path'} && $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling move_file");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'} && defined $args{'dest_path'} && $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling move_file");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/file/move/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'dest_path'} && defined $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if (exists $args{'src_storage_name'} && defined $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if (exists $args{'dest_storage_name'} && defined $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# move_folder
#
# Move folder
# 
# @param string $src_path Folder path to move e.g. &#39;/folder&#39; (required)
# @param string $dest_path Destination folder path to move to e.g &#39;/dst&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Folder path to move e.g. &#39;/folder&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination folder path to move to e.g &#39;/dst&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_folder' } = { 
    	summary => 'Move folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub move_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'} && defined $args{'src_path'} && $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling move_folder");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'} && defined $args{'dest_path'} && $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling move_folder");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/folder/move/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'dest_path'} && defined $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if (exists $args{'src_storage_name'} && defined $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if (exists $args{'dest_storage_name'} && defined $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# move_section
#
# Move presentation section to a specified position.
# 
# @param string $name Document name. (required)
# @param int $section_index The position of the section to be reordered. (required)
# @param int $new_position The new position of the reordered section. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'section_index' => {
        data_type => 'int',
        description => 'The position of the section to be reordered.',
        required => '1',
    },
    'new_position' => {
        data_type => 'int',
        description => 'The new position of the reordered section.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_section' } = { 
    	summary => 'Move presentation section to a specified position.',
        params => $params,
        returns => 'Sections',
        };
}
# @return Sections
#
sub move_section {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling move_section");
    }

    # verify the required parameter 'section_index' is set
    unless (exists $args{'section_index'} && defined $args{'section_index'}) {
      croak("Missing the required parameter 'section_index' when calling move_section");
    }

    # verify the required parameter 'new_position' is set
    unless (exists $args{'new_position'} && defined $args{'new_position'}) {
      croak("Missing the required parameter 'new_position' when calling move_section");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/sections/{sectionIndex}/move';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'new_position'} && defined $args{'new_position'}) {
        $query_params->{'newPosition'} = $self->{api_client}->to_query_value($args{'new_position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'section_index'}) {
        my $_base_variable = "{" . "sectionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'section_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Sections', $response);
    return $_response_object;
}

#
# move_slide
#
# Reorder presentation slide position.
# 
# @param string $name Document name. (required)
# @param int $slide_index The position of the slide to be reordered. (required)
# @param int $new_position The new position of the reordered slide. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'The position of the slide to be reordered.',
        required => '1',
    },
    'new_position' => {
        data_type => 'int',
        description => 'The new position of the reordered slide.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_slide' } = { 
    	summary => 'Reorder presentation slide position.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub move_slide {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling move_slide");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling move_slide");
    }

    # verify the required parameter 'new_position' is set
    unless (exists $args{'new_position'} && defined $args{'new_position'}) {
      croak("Missing the required parameter 'new_position' when calling move_slide");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/move';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'new_position'} && defined $args{'new_position'}) {
        $query_params->{'newPosition'} = $self->{api_client}->to_query_value($args{'new_position'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# notes_slide_exists
#
# Get info whether a notes slide exists.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'notes_slide_exists' } = { 
    	summary => 'Get info whether a notes slide exists.',
        params => $params,
        returns => 'EntityExists',
        };
}
# @return EntityExists
#
sub notes_slide_exists {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling notes_slide_exists");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling notes_slide_exists");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/notesSlide/exist';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('EntityExists', $response);
    return $_response_object;
}

#
# notes_slide_exists_online
#
# Get info whether a notes slide exists.
# 
# @param File $document Document data. (required)
# @param int $slide_index Slide index. (required)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'notes_slide_exists_online' } = { 
    	summary => 'Get info whether a notes slide exists.',
        params => $params,
        returns => 'EntityExists',
        };
}
# @return EntityExists
#
sub notes_slide_exists_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling notes_slide_exists_online");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling notes_slide_exists_online");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/notesSlide/exist';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('EntityExists', $response);
    return $_response_object;
}

#
# object_exists
#
# Check if file or folder exists
# 
# @param string $path File or folder path e.g. &#39;/file.ext&#39; or &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File or folder path e.g. &#39;/file.ext&#39; or &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'object_exists' } = { 
    	summary => 'Check if file or folder exists',
        params => $params,
        returns => 'ObjectExist',
        };
}
# @return ObjectExist
#
sub object_exists {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'} && defined $args{'path'} && $args{'path'}) {
      croak("Missing the required parameter 'path' when calling object_exists");
    }

    # parse inputs
    my $_resource_path = '/slides/storage/exist/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'storage_name'} && defined $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if (exists $args{'version_id'} && defined $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ObjectExist', $response);
    return $_response_object;
}

#
# ordered_merge
#
# Merge the presentation with other presentations or some of their slides specified in the request parameter.
# 
# @param string $name Document name. (required)
# @param OrderedMergeRequest $request OrderedMergeRequest with a list of presentations and slide indices to merge. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'request' => {
        data_type => 'OrderedMergeRequest',
        description => 'OrderedMergeRequest with a list of presentations and slide indices to merge.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'ordered_merge' } = { 
    	summary => 'Merge the presentation with other presentations or some of their slides specified in the request parameter.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub ordered_merge {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling ordered_merge");
    }

    # verify the required parameter 'request' is set
    unless (exists $args{'request'} && defined $args{'request'} && $args{'request'}) {
      croak("Missing the required parameter 'request' when calling ordered_merge");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/merge';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'request'} && $args{'request'}) {
        $_body_data = $args{'request'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# pipeline
#
# Performs slides pipeline.
# 
# @param Pipeline $pipeline A Pipeline object. (required)
# @param ARRAY[string] $files Files to upload with the pipeline (optional)
{
    my $params = {
    'pipeline' => {
        data_type => 'Pipeline',
        description => 'A Pipeline object.',
        required => '1',
    },
    'files' => {
        data_type => 'ARRAY[string]',
        description => 'Files to upload with the pipeline',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'pipeline' } = { 
    	summary => 'Performs slides pipeline.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub pipeline {
    my ($self, %args) = @_;

    # verify the required parameter 'pipeline' is set
    unless (exists $args{'pipeline'} && defined $args{'pipeline'} && $args{'pipeline'}) {
      croak("Missing the required parameter 'pipeline' when calling pipeline");
    }

    # parse inputs
    my $_resource_path = '/slides/pipeline';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    my $_body_data;
    my $files = [];
    if ( exists $args{'files'} && $args{'files'}) {
        my $arg_files = $args{'files'};
        push(@$files, @$arg_files);
    }
    # body params
    if ( exists $args{'pipeline'} && $args{'pipeline'}) {
        $_body_data = $args{'pipeline'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# reorder_slides
#
# Reorder presentation slides positions.
# 
# @param string $name Document name. (required)
# @param int[] $old_positions A comma separated array of positions of slides to be reordered. (optional)
# @param int[] $new_positions A comma separated array of new slide positions. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_positions' => {
        data_type => 'int[]',
        description => 'A comma separated array of positions of slides to be reordered.',
        required => '0',
    },
    'new_positions' => {
        data_type => 'int[]',
        description => 'A comma separated array of new slide positions.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'reorder_slides' } = { 
    	summary => 'Reorder presentation slides positions.',
        params => $params,
        returns => 'Slides',
        };
}
# @return Slides
#
sub reorder_slides {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling reorder_slides");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/reorder';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'old_positions'} && defined $args{'old_positions'}) {
        $query_params->{'oldPositions'} = $self->{api_client}->to_query_value($args{'old_positions'});
    }

    # query params
    if (exists $args{'new_positions'} && defined $args{'new_positions'}) {
        $query_params->{'newPositions'} = $self->{api_client}->to_query_value($args{'new_positions'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Slides', $response);
    return $_response_object;
}

#
# replace_font
#
# Replaces specified font and returns presentation fonts info.
# 
# @param string $name Document name. (required)
# @param string $source_font Source font name. (required)
# @param string $target_font Target font name. (required)
# @param boolean $embed Embed target font. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'source_font' => {
        data_type => 'string',
        description => 'Source font name.',
        required => '1',
    },
    'target_font' => {
        data_type => 'string',
        description => 'Target font name.',
        required => '1',
    },
    'embed' => {
        data_type => 'boolean',
        description => 'Embed target font.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_font' } = { 
    	summary => 'Replaces specified font and returns presentation fonts info.',
        params => $params,
        returns => 'FontsData',
        };
}
# @return FontsData
#
sub replace_font {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling replace_font");
    }

    # verify the required parameter 'source_font' is set
    unless (exists $args{'source_font'} && defined $args{'source_font'} && $args{'source_font'}) {
      croak("Missing the required parameter 'source_font' when calling replace_font");
    }

    # verify the required parameter 'target_font' is set
    unless (exists $args{'target_font'} && defined $args{'target_font'} && $args{'target_font'}) {
      croak("Missing the required parameter 'target_font' when calling replace_font");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/fonts/{sourceFont}/replace/{targetFont}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'embed'} && defined $args{'embed'}) {
        $query_params->{'embed'} = $self->{api_client}->to_boolean_query_value($args{'embed'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'source_font'}) {
        my $_base_variable = "{" . "sourceFont" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'source_font'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'target_font'}) {
        my $_base_variable = "{" . "targetFont" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'target_font'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FontsData', $response);
    return $_response_object;
}

#
# replace_font_online
#
# Replaces specified font and returns presentation.
# 
# @param File $document Document data. (required)
# @param string $source_font Source font name. (required)
# @param string $target_font Target font name. (required)
# @param boolean $embed Embed target font. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'source_font' => {
        data_type => 'string',
        description => 'Source font name.',
        required => '1',
    },
    'target_font' => {
        data_type => 'string',
        description => 'Target font name.',
        required => '1',
    },
    'embed' => {
        data_type => 'boolean',
        description => 'Embed target font.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_font_online' } = { 
    	summary => 'Replaces specified font and returns presentation.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub replace_font_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling replace_font_online");
    }

    # verify the required parameter 'source_font' is set
    unless (exists $args{'source_font'} && defined $args{'source_font'} && $args{'source_font'}) {
      croak("Missing the required parameter 'source_font' when calling replace_font_online");
    }

    # verify the required parameter 'target_font' is set
    unless (exists $args{'target_font'} && defined $args{'target_font'} && $args{'target_font'}) {
      croak("Missing the required parameter 'target_font' when calling replace_font_online");
    }

    # parse inputs
    my $_resource_path = '/slides/fonts/{sourceFont}/replace/{targetFont}';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'embed'} && defined $args{'embed'}) {
        $query_params->{'embed'} = $self->{api_client}->to_boolean_query_value($args{'embed'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'source_font'}) {
        my $_base_variable = "{" . "sourceFont" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'source_font'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'target_font'}) {
        my $_base_variable = "{" . "targetFont" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'target_font'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# replace_image
#
# Replaces image by the specified index.
# 
# @param string $name Document name. (required)
# @param int $image_index Image index. (required)
# @param File $image Image data. (required)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'image_index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'image' => {
        data_type => 'File',
        description => 'Image data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_image' } = { 
    	summary => 'Replaces image by the specified index.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub replace_image {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling replace_image");
    }

    # verify the required parameter 'image_index' is set
    unless (exists $args{'image_index'} && defined $args{'image_index'}) {
      croak("Missing the required parameter 'image_index' when calling replace_image");
    }

    # verify the required parameter 'image' is set
    unless (exists $args{'image'} && defined $args{'image'} && $args{'image'}) {
      croak("Missing the required parameter 'image' when calling replace_image");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/images/{imageIndex}/replace';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'image_index'}) {
        my $_base_variable = "{" . "imageIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'image_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'image'} && $args{'image'}) {
        push(@$files, $args{'image'});
    }
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# replace_image_online
#
# Replaces image by the specified index and returns updated document. 
# 
# @param File $document Document data. (required)
# @param int $image_index Image index. (required)
# @param File $image Image data. (required)
# @param string $password Password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'image_index' => {
        data_type => 'int',
        description => 'Image index.',
        required => '1',
    },
    'image' => {
        data_type => 'File',
        description => 'Image data.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_image_online' } = { 
    	summary => 'Replaces image by the specified index and returns updated document. ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub replace_image_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling replace_image_online");
    }

    # verify the required parameter 'image_index' is set
    unless (exists $args{'image_index'} && defined $args{'image_index'}) {
      croak("Missing the required parameter 'image_index' when calling replace_image_online");
    }

    # verify the required parameter 'image' is set
    unless (exists $args{'image'} && defined $args{'image'} && $args{'image'}) {
      croak("Missing the required parameter 'image' when calling replace_image_online");
    }

    # parse inputs
    my $_resource_path = '/slides/images/{imageIndex}/replace';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'image_index'}) {
        my $_base_variable = "{" . "imageIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'image_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    if ( exists $args{'image'} && $args{'image'}) {
        push(@$files, $args{'image'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# replace_presentation_regex
#
# Replace text with a new value using a regex.
# 
# @param string $name Document name. (required)
# @param string $pattern Text value pattern to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'pattern' => {
        data_type => 'string',
        description => 'Text value pattern to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_presentation_regex' } = { 
    	summary => 'Replace text with a new value using a regex.',
        params => $params,
        returns => 'DocumentReplaceResult',
        };
}
# @return DocumentReplaceResult
#
sub replace_presentation_regex {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling replace_presentation_regex");
    }

    # verify the required parameter 'pattern' is set
    unless (exists $args{'pattern'} && defined $args{'pattern'} && $args{'pattern'}) {
      croak("Missing the required parameter 'pattern' when calling replace_presentation_regex");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && defined $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling replace_presentation_regex");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/replaceRegex';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'pattern'} && defined $args{'pattern'}) {
        $query_params->{'pattern'} = $self->{api_client}->to_query_value($args{'pattern'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentReplaceResult', $response);
    return $_response_object;
}

#
# replace_presentation_regex_online
#
# Replace text with a new value using a regex.
# 
# @param File $document Document data. (required)
# @param string $pattern Text regex pattern to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'pattern' => {
        data_type => 'string',
        description => 'Text regex pattern to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_presentation_regex_online' } = { 
    	summary => 'Replace text with a new value using a regex.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub replace_presentation_regex_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling replace_presentation_regex_online");
    }

    # verify the required parameter 'pattern' is set
    unless (exists $args{'pattern'} && defined $args{'pattern'} && $args{'pattern'}) {
      croak("Missing the required parameter 'pattern' when calling replace_presentation_regex_online");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && defined $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling replace_presentation_regex_online");
    }

    # parse inputs
    my $_resource_path = '/slides/replaceRegex';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'pattern'} && defined $args{'pattern'}) {
        $query_params->{'pattern'} = $self->{api_client}->to_query_value($args{'pattern'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# replace_presentation_text
#
# Replace text with a new value.
# 
# @param string $name Document name. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param boolean $whole_words_only True to replace whole words only. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'whole_words_only' => {
        data_type => 'boolean',
        description => 'True to replace whole words only.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_presentation_text' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'DocumentReplaceResult',
        };
}
# @return DocumentReplaceResult
#
sub replace_presentation_text {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling replace_presentation_text");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && defined $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling replace_presentation_text");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && defined $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling replace_presentation_text");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'whole_words_only'} && defined $args{'whole_words_only'}) {
        $query_params->{'wholeWordsOnly'} = $self->{api_client}->to_boolean_query_value($args{'whole_words_only'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DocumentReplaceResult', $response);
    return $_response_object;
}

#
# replace_presentation_text_online
#
# Replace text with a new value.
# 
# @param File $document Document data. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param boolean $whole_words_only True to replace whole words only. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'whole_words_only' => {
        data_type => 'boolean',
        description => 'True to replace whole words only.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_presentation_text_online' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub replace_presentation_text_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling replace_presentation_text_online");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && defined $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling replace_presentation_text_online");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && defined $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling replace_presentation_text_online");
    }

    # parse inputs
    my $_resource_path = '/slides/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'whole_words_only'} && defined $args{'whole_words_only'}) {
        $query_params->{'wholeWordsOnly'} = $self->{api_client}->to_boolean_query_value($args{'whole_words_only'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# replace_slide_text
#
# Replace text with a new value.
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_slide_text' } = { 
    	summary => 'Replace text with a new value.',
        params => $params,
        returns => 'SlideReplaceResult',
        };
}
# @return SlideReplaceResult
#
sub replace_slide_text {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling replace_slide_text");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling replace_slide_text");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && defined $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling replace_slide_text");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && defined $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling replace_slide_text");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SlideReplaceResult', $response);
    return $_response_object;
}

#
# replace_slide_text_online
#
# Replace slide text with a new value.
# 
# @param File $document Document data. (required)
# @param int $slide_index Index of target slide. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param boolean $ignore_case True if character case must be ignored. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Index of target slide.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'ignore_case' => {
        data_type => 'boolean',
        description => 'True if character case must be ignored.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_slide_text_online' } = { 
    	summary => 'Replace slide text with a new value.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub replace_slide_text_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling replace_slide_text_online");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling replace_slide_text_online");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && defined $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling replace_slide_text_online");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && defined $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling replace_slide_text_online");
    }

    # parse inputs
    my $_resource_path = '/slides/slides/{slideIndex}/replaceText';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'ignore_case'} && defined $args{'ignore_case'}) {
        $query_params->{'ignoreCase'} = $self->{api_client}->to_boolean_query_value($args{'ignore_case'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# replace_text_formatting
#
# Finds and replaces text in presentation with given format.
# 
# @param string $name Document name. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param PortionFormat $portion_format Portion format. (optional)
# @param boolean $with_masters Text replacement includes master slides. (optional, default to false)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'portion_format' => {
        data_type => 'PortionFormat',
        description => 'Portion format.',
        required => '0',
    },
    'with_masters' => {
        data_type => 'boolean',
        description => 'Text replacement includes master slides.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_text_formatting' } = { 
    	summary => 'Finds and replaces text in presentation with given format.',
        params => $params,
        returns => 'Document',
        };
}
# @return Document
#
sub replace_text_formatting {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling replace_text_formatting");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && defined $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling replace_text_formatting");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && defined $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling replace_text_formatting");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/replaceTextFormatting';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'with_masters'} && defined $args{'with_masters'}) {
        $query_params->{'withMasters'} = $self->{api_client}->to_boolean_query_value($args{'with_masters'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'portion_format'} && $args{'portion_format'}) {
        $_body_data = $args{'portion_format'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Document', $response);
    return $_response_object;
}

#
# replace_text_formatting_online
#
# Finds and replaces text in presentation with given format.
# 
# @param File $document Document data. (required)
# @param string $old_value Text value to be replaced. (required)
# @param string $new_value Text value to replace with. (required)
# @param PortionFormat $portion_format Portion format. (optional)
# @param boolean $with_masters Text replacement includes master slides. (optional, default to false)
# @param string $password Document password. (optional)
{
    my $params = {
    'document' => {
        data_type => 'File',
        description => 'Document data.',
        required => '1',
    },
    'old_value' => {
        data_type => 'string',
        description => 'Text value to be replaced.',
        required => '1',
    },
    'new_value' => {
        data_type => 'string',
        description => 'Text value to replace with.',
        required => '1',
    },
    'portion_format' => {
        data_type => 'PortionFormat',
        description => 'Portion format.',
        required => '0',
    },
    'with_masters' => {
        data_type => 'boolean',
        description => 'Text replacement includes master slides.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'replace_text_formatting_online' } = { 
    	summary => 'Finds and replaces text in presentation with given format.',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub replace_text_formatting_online {
    my ($self, %args) = @_;

    # verify the required parameter 'document' is set
    unless (exists $args{'document'} && defined $args{'document'} && $args{'document'}) {
      croak("Missing the required parameter 'document' when calling replace_text_formatting_online");
    }

    # verify the required parameter 'old_value' is set
    unless (exists $args{'old_value'} && defined $args{'old_value'} && $args{'old_value'}) {
      croak("Missing the required parameter 'old_value' when calling replace_text_formatting_online");
    }

    # verify the required parameter 'new_value' is set
    unless (exists $args{'new_value'} && defined $args{'new_value'} && $args{'new_value'}) {
      croak("Missing the required parameter 'new_value' when calling replace_text_formatting_online");
    }

    # parse inputs
    my $_resource_path = '/slides/replaceTextFormatting';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if (exists $args{'old_value'} && defined $args{'old_value'}) {
        $query_params->{'oldValue'} = $self->{api_client}->to_query_value($args{'old_value'});
    }

    # query params
    if (exists $args{'new_value'} && defined $args{'new_value'}) {
        $query_params->{'newValue'} = $self->{api_client}->to_query_value($args{'new_value'});
    }

    # query params
    if (exists $args{'with_masters'} && defined $args{'with_masters'}) {
        $query_params->{'withMasters'} = $self->{api_client}->to_boolean_query_value($args{'with_masters'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    my $_body_data;
    my $files = [];
    if ( exists $args{'document'} && $args{'document'}) {
        push(@$files, $args{'document'});
    }
    # body params
    if ( exists $args{'portion_format'} && $args{'portion_format'}) {
        $_body_data = $args{'portion_format'};
    }

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# save_math_portion
#
# Convert Mathematical Text to MathML Format and saves result to the storage
# 
# @param string $name Document name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Shape index. (required)
# @param int $paragraph_index Paragraph index. (required)
# @param int $portion_index Portion index. (required)
# @param string $format Format. (required)
# @param string $out_path Path to save result. (required)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Shape index.',
        required => '1',
    },
    'paragraph_index' => {
        data_type => 'int',
        description => 'Paragraph index.',
        required => '1',
    },
    'portion_index' => {
        data_type => 'int',
        description => 'Portion index.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Path to save result.',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'save_math_portion' } = { 
    	summary => 'Convert Mathematical Text to MathML Format and saves result to the storage',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub save_math_portion {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling save_math_portion");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling save_math_portion");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling save_math_portion");
    }

    # verify the required parameter 'paragraph_index' is set
    unless (exists $args{'paragraph_index'} && defined $args{'paragraph_index'}) {
      croak("Missing the required parameter 'paragraph_index' when calling save_math_portion");
    }

    # verify the required parameter 'portion_index' is set
    unless (exists $args{'portion_index'} && defined $args{'portion_index'}) {
      croak("Missing the required parameter 'portion_index' when calling save_math_portion");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling save_math_portion");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'MathML', 'LaTeX' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && defined $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling save_math_portion");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'shape_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'paragraph_index'}) {
        my $_base_variable = "{" . "paragraphIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'paragraph_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'portion_index'}) {
        my $_base_variable = "{" . "portionIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'portion_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# save_presentation
#
# Save a presentation to a specified format.
# 
# @param string $name Document name. (required)
# @param string $format Export format. (required)
# @param string $out_path Output path. (required)
# @param ExportOptions $options Export options. (optional)
# @param string $password Document password. (optional)
# @param string $folder Document folder. (optional)
# @param string $storage Document storage. (optional)
# @param string $fonts_folder Custom fonts folder. (optional)
# @param int[] $slides The indices of the slides to be saved. If not specified, all slides are saved by default. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Document name.',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Output path.',
        required => '1',
    },
    'options' => {
        data_type => 'ExportOptions',
        description => 'Export options.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Document folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Document storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Custom fonts folder.',
        required => '0',
    },
    'slides' => {
        data_type => 'int[]',
        description => 'The indices of the slides to be saved. If not specified, all slides are saved by default.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'save_presentation' } = { 
    	summary => 'Save a presentation to a specified format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub save_presentation {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling save_presentation");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling save_presentation");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Pdf', 'Xps', 'Tiff', 'Pptx', 'Odp', 'Otp', 'Ppt', 'Pps', 'Ppsx', 'Pptm', 'Ppsm', 'Pot', 'Potx', 'Potm', 'Html', 'Html5', 'Swf', 'Svg', 'Jpeg', 'Png', 'Gif', 'Bmp', 'Fodp', 'Xaml', 'Mpeg4', 'Md', 'Xml' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && defined $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling save_presentation");
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # query params
    if (exists $args{'slides'} && defined $args{'slides'}) {
        $query_params->{'slides'} = $self->{api_client}->to_query_value($args{'slides'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'format'}) {
        my $_base_variable = "{" . "format" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'format'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    my $files = [];
    # body params
    if ( exists $args{'options'} && $args{'options'}) {
        $_body_data = $args{'options'};
    }

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $files);
    return;
}

#
# save_shape
#
# Render shape to specified picture format.
# 
# @param string $name Presentation name. (required)
# @param int $slide_index Slide index. (required)
# @param int $shape_index Index of shape starting from 1 (required)
# @param string $format Export picture format. (required)
# @param string $out_path Output path. (required)
# @param IShapeExportOptions $options export options (optional)
# @param double $scale_x X scale ratio. (optional, default to 0.0)
# @param double $scale_y Y scale ratio. (optional, default to 0.0)
# @param string $bounds Shape thumbnail bounds type. (optional, default to 1)
# @param string $password Document password. (optional)
# @param string $folder Presentation folder. (optional)
# @param string $storage Presentation storage. (optional)
# @param string $fonts_folder Fonts folder. (optional)
# @param string $sub_shape Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2). (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'Presentation name.',
        required => '1',
    },
    'slide_index' => {
        data_type => 'int',
        description => 'Slide index.',
        required => '1',
    },
    'shape_index' => {
        data_type => 'int',
        description => 'Index of shape starting from 1',
        required => '1',
    },
    'format' => {
        data_type => 'string',
        description => 'Export picture format.',
        required => '1',
    },
    'out_path' => {
        data_type => 'string',
        description => 'Output path.',
        required => '1',
    },
    'options' => {
        data_type => 'IShapeExportOptions',
        description => 'export options',
        required => '0',
    },
    'scale_x' => {
        data_type => 'double',
        description => 'X scale ratio.',
        required => '0',
    },
    'scale_y' => {
        data_type => 'double',
        description => 'Y scale ratio.',
        required => '0',
    },
    'bounds' => {
        data_type => 'string',
        description => 'Shape thumbnail bounds type.',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'Document password.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'Presentation folder.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'Presentation storage.',
        required => '0',
    },
    'fonts_folder' => {
        data_type => 'string',
        description => 'Fonts folder.',
        required => '0',
    },
    'sub_shape' => {
        data_type => 'string',
        description => 'Sub-shape path (e.g. \&quot;3\&quot;, \&quot;3/shapes/2).',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'save_shape' } = { 
    	summary => 'Render shape to specified picture format.',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub save_shape {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'} && defined $args{'name'} && $args{'name'}) {
      croak("Missing the required parameter 'name' when calling save_shape");
    }

    # verify the required parameter 'slide_index' is set
    unless (exists $args{'slide_index'} && defined $args{'slide_index'}) {
      croak("Missing the required parameter 'slide_index' when calling save_shape");
    }

    # verify the required parameter 'shape_index' is set
    unless (exists $args{'shape_index'} && defined $args{'shape_index'}) {
      croak("Missing the required parameter 'shape_index' when calling save_shape");
    }

    # verify the required parameter 'format' is set
    unless (exists $args{'format'} && defined $args{'format'} && $args{'format'}) {
      croak("Missing the required parameter 'format' when calling save_shape");
    }

    # verify enum value
    if (!grep(/^$args{'format'}$/i, ( 'Jpeg', 'Png', 'Gif', 'Bmp', 'Tiff', 'Svg' ))) {
      croak("Invalid value for 'format': " . $args{'format'});
    }

    # verify the required parameter 'out_path' is set
    unless (exists $args{'out_path'} && defined $args{'out_path'} && $args{'out_path'}) {
      croak("Missing the required parameter 'out_path' when calling save_shape");
    }

    # verify enum value
    if (exists $args{'bounds'} && $args{'bounds'} && !grep(/^$args{'bounds'}$/i, ( 'Slide', 'Shape', 'Appearance' ))) {
      croak("Invalid value for 'bounds': " . $args{'bounds'});
    }

    # parse inputs
    my $_resource_path = '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/{format}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if (exists $args{'out_path'} && defined $args{'out_path'}) {
        $query_params->{'outPath'} = $self->{api_client}->to_query_value($args{'out_path'});
    }

    # query params
    if (exists $args{'scale_x'} && defined $args{'scale_x'}) {
        $query_params->{'scaleX'} = $self->{api_client}->to_query_value($args{'scale_x'});
    }

    # query params
    if (exists $args{'scale_y'} && defined $args{'scale_y'}) {
        $query_params->{'scaleY'} = $self->{api_client}->to_query_value($args{'scale_y'});
    }

    # query params
    if (exists $args{'bounds'} && defined $args{'bounds'}) {
        $query_params->{'bounds'} = $self->{api_client}->to_query_value($args{'bounds'});
    }

    # query params
    if (exists $args{'folder'} && defined $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if (exists $args{'storage'} && defined $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # query params
    if (exists $args{'fonts_folder'} && defined $args{'fonts_folder'}) {
        $query_params->{'fontsFolder'} = $self->{api_client}->to_query_value($args{'fonts_folder'});
    }

    # query params
    if (exists $args{'sub_shape'} && defined $args{'sub_shape'}) {
        $query_params->{'subShape'} = $self->{api_client}->to_query_value($args{'sub_shape'});
    }

    # header params
    if ( exists $args{'password'}) {
        $header_params->{':password'} = $self->{api_client}->to_header_value($args{'password'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'slide_index'}) {
        my $_base_variable = "{" . "slideIndex" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'slide_index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'shape_index'}) {
        my $_base_variable = "{" . "shapeIndex" . "}";
      