# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue,
email, or any other method with the owners of this repository before making a change. 

Please note we have a code of conduct, please follow it in all your interactions with the project.

## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer when doing a build. Please read README.PATCHING for information on this.
2. Increase the version numbers to the new version that this Pull Request would represent. The versioning scheme we use is similar to [SemVer](http://semver.org/). Backward-incompatible API changes increment major version number. API enhancements increment first significant digit. And small patches increment last two significant digits.
3. As soon as you open the Pull Request you'll see that the CI software like Travis-CI and Codecov get triggered. You may merge the Pull Request in once all checks are complete and your changes are deemed good. You may also install these CI software for your own fork, and open a PR only after you know it is all good.
