#!/usr/bin/perl
use warnings;
use strict;
use Test::More tests => 11;
use AnyEvent::MQTT;

my $timeout = AnyEvent->timer(after => 5, cb => sub { die "timeout\n" });
my ($test) = ($0 =~ m!([^/]+)$!);
my $topic = '/zqk/test';
my @messages;
my $mqtt = AnyEvent::MQTT->new(host => $ENV{ANYEVENT_MQTT_SERVER},
                               on_error => sub {
                                 warn $_[1], "\n"; die "\n" if ($_[0])
                               },
                               client_id => $test,
                               message_log_callback => sub {
                                 my $str = $_[1]->string;
                                 return if ($str =~ /Publish/ && $str !~ /zqk/);
                                 push @messages, $_[0].' '.$str;
                               });
ok(my $cv = $mqtt->connect, 'connect');
ok($cv->recv, '...connected') or BAIL_OUT('simple connect failed');
ok($cv = $mqtt->publish(topic => $topic.'/plus', message => 'just testing',
                        retain => 1),
   'publish');
ok($cv->recv, '...published');

my $received = AnyEvent->condvar;
ok($cv = $mqtt->subscribe(topic => $topic.'/+',
                          callback => sub {
                            $received->send(\@_);
                          }),
   'subscribe');
is($cv->recv, 0, '...subscribed');

my $res = $received->recv;
my ($topic_recv, $message) = @$res;
is($topic_recv, $topic.'/plus', '...topic');
is($message, 'just testing', '...message');

ok($cv = $mqtt->publish(topic => $topic.'/plus', message => '', retain => 1),
   'publish');

ok($cv->recv, '...published');

is_deeply(\@messages,
          [
           q{> Connect/at-most-once MQIsdp/3/}.$test.q{ },
           q{< ConnAck/at-most-once Connection Accepted },
           q{> Publish/at-most-once,retain }.$topic."/plus \n".
             q{  6a 75 73 74 20 74 65 73 74 69 6e 67              just testing},
           q{> Subscribe/at-least-once 1 }.$topic.q{/+/at-most-once },
           q{< SubAck/at-most-once 1/at-most-once },
           q{< Publish/at-most-once,retain }.$topic."/plus \n".
             q{  6a 75 73 74 20 74 65 73 74 69 6e 67              just testing},
           q{> Publish/at-most-once,retain }.$topic."/plus ",
          ], '...message log');
