package Devel::PatchPerl::Hints;
$Devel::PatchPerl::Hints::VERSION = '2.09'; # TRIAL
#ABSTRACT: replacement 'hints' files

use strict;
use warnings;
use MIME::Base64 qw[decode_base64];
use File::Spec;

our @ISA            = qw[Exporter];
our @EXPORT_OK      = qw[hint_file hints];

my %hints = (
'bitrig' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl
ciA8bWlsbGVydEBvcGVuYnNkLm9yZz4KIyBFZGl0ZWQgdG8gYWxsb3cgQ29uZmlndXJlIGNvbW1h
bmQtbGluZSBvdmVycmlkZXMgYnkKIyAgQW5keSBEb3VnaGVydHkgPGRvdWdoZXJhQGxhZmF5ZXR0
ZS5lZHU+CiMKIyBUbyBidWlsZCB3aXRoIGRpc3RyaWJ1dGlvbiBwYXRocywgdXNlOgojCS4vQ29u
ZmlndXJlIC1kZXMgLURvcGVuYnNkX2Rpc3RyaWJ1dGlvbj1kZWZpbmVkCiMKCiMgT3BlbkJTRCBo
YXMgYSBiZXR0ZXIgbWFsbG9jIHRoYW4gcGVybC4uLgp0ZXN0ICIkdXNlbXltYWxsb2MiIHx8IHVz
ZW15bWFsbG9jPSduJwoKIyBDdXJyZW50bHksIHZmb3JrKDIpIGlzIG5vdCBhIHJlYWwgd2luIG92
ZXIgZm9yaygyKS4KdXNldmZvcms9IiR1bmRlZiIKCiMKIyBOb3QgYWxsIHBsYXRmb3JtcyBzdXBw
b3J0IGR5bmFtaWMgbG9hZGluZy4uLgojIEZvciB0aGUgY2FzZSBvZiAiJG9wZW5ic2RfZGlzdHJp
YnV0aW9uIiwgdGhlIGhpbnRzIGZpbGUKIyBuZWVkcyB0byBrbm93IHdoZXRoZXIgd2UgYXJlIHVz
aW5nIGR5bmFtaWMgbG9hZGluZyBzbyB0aGF0CiMgaXQgY2FuIHNldCB0aGUgbGlicGVybCBuYW1l
IGFwcHJvcHJpYXRlbHkuCiMgQWxsb3cgY29tbWFuZCBsaW5lIG92ZXJyaWRlcy4KIwojQVJDSD1g
YXJjaCB8IHNlZCAncy9eT3BlbkJTRC4vLydgCkFSQ0g9YGFyY2ggfCBzZWQgJ3MvXkJpdHJpZy4v
LydgCmNhc2UgIiR7QVJDSH0tJHtvc3ZlcnN9IiBpbgoqKQoJdGVzdCAteiAiJHVzZWRsIiAmJiB1
c2VkbD0kZGVmaW5lCgkjIFdlIHVzZSAtZlBJQyBoZXJlIGJlY2F1c2UgLWZwaWMgaXMgKk5PVCog
ZW5vdWdoIGZvciBzb21lIG9mIHRoZQoJIyBleHRlbnNpb25zIGxpa2UgVGsgb24gc29tZSBPcGVu
QlNEIHBsYXRmb3JtcyAoaWU6IHNwYXJjKQoJY2NjZGxmbGFncz0iLURQSUMgLWZQSUMgJGNjY2Rs
ZmxhZ3MiCgljYXNlICIkb3N2ZXJzIiBpbgoJKikgIyBmcm9tIDMuMSBvbndhcmRzCgkJbGQ9JHtj
YzotY2N9CgkJbGRkbGZsYWdzPSItc2hhcmVkIC1mUElDICRsZGRsZmxhZ3MiCgkJbGlic3dhbnRl
ZD1gZWNobyAkbGlic3dhbnRlZCB8IHNlZCAncy8gZGwgLyAvJ2AKCQk7OwoJZXNhYwoKCSMgV2Ug
bmVlZCB0byBmb3JjZSBsZCB0byBleHBvcnQgc3ltYm9scyBvbiBFTEYgcGxhdGZvcm1zLgoJIyBX
aXRob3V0IHRoaXMsIGRsb3BlbigpIGlzIGNyaXBwbGVkLgoJRUxGPWAke2NjOi1jY30gLWRNIC1F
IC0gPC9kZXYvbnVsbCB8IGdyZXAgX19FTEZfX2AKCXRlc3QgLW4gIiRFTEYiICYmIGxkZmxhZ3M9
Ii1XbCwtRSAkbGRmbGFncyIKCTs7CmVzYWMKCiMgbWFsbG9jIHdyYXAgY2F1c2VzIHByb2JsZW1z
IG9uIG02OGsKaWYgWyBYIiR1c2VtYWxsb2N3cmFwIiA9IFgiIiBdOyB0aGVuCgljYXNlICIke0FS
Q0h9IiBpbgoJKikgICAgdXNlbWFsbG9jd3JhcD0iZGVmaW5lIiA7OwoJZXNhYwpmaQoKIyBPcGVu
QlNEIGRvZXNuJ3QgbmVlZCBsaWJjcnlwdCBidXQgbWFueSBmb2xrcyBrZWVwIGEgc3R1YiBsaWIK
IyBhcm91bmQgZm9yIG9sZCBOZXRCU0QgYmluYXJpZXMuCmxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3
YW50ZWQgfCBzZWQgJ3MvIGNyeXB0IC8gLydgCgojIENvbmZpZ3VyZSBjYW4ndCBmaWd1cmUgdGhp
cyBvdXQgbm9uLWludGVyYWN0aXZlbHkKZF9zdWlkc2FmZT0kZGVmaW5lCgojIGNjIGlzIGdjYyBz
byB3ZSBjYW4gZG8gYmV0dGVyIHRoYW4gLU8KIyBBbGxvdyBhIGNvbW1hbmQtbGluZSBvdmVycmlk
ZSwgc3VjaCBhcyAtRG9wdGltaXplPS1nCmNhc2UgIiR7QVJDSH0tJHtvc3ZlcnN9IiBpbgoqKQog
ICB0ZXN0ICIkb3B0aW1pemUiIHx8IG9wdGltaXplPSctTzInCiAgIDs7CmVzYWMKCiMgVGhpcyBz
Y3JpcHQgVVUvdXNldGhyZWFkcy5jYnUgd2lsbCBnZXQgJ2NhbGxlZC1iYWNrJyBieSBDb25maWd1
cmUgCiMgYWZ0ZXIgaXQgaGFzIHByb21wdGVkIHRoZSB1c2VyIGZvciB3aGV0aGVyIHRvIHVzZSB0
aHJlYWRzLgpjYXQgPiBVVS91c2V0aHJlYWRzLmNidSA8PCdFT0NCVScKY2FzZSAiJHVzZXRocmVh
ZHMiIGluCiRkZWZpbmV8dHJ1ZXxbeVldKikKCSMgYW55IG9wZW5ic2QgdmVyc2lvbiBkZXBlbmRl
bmNpZXMgd2l0aCBwdGhyZWFkcz8KCWNjZmxhZ3M9Ii1wdGhyZWFkICRjY2ZsYWdzIgoJbGRmbGFn
cz0iLXB0aHJlYWQgJGxkZmxhZ3MiCmVzYWMKRU9DQlUKCiMgV2hlbiBidWlsZGluZyBpbiB0aGUg
T3BlbkJTRCB0cmVlIHdlIHVzZSBkaWZmZXJlbnQgcGF0aHMKIyBUaGlzIGlzIG9ubHkgcGFydCBv
ZiB0aGUgc3RvcnksIHRoZSByZXN0IGNvbWVzIGZyb20gY29uZmlnLm92ZXIKY2FzZSAiJG9wZW5i
c2RfZGlzdHJpYnV0aW9uIiBpbgonJ3wkdW5kZWZ8ZmFsc2UpIDs7CiopCgkjIFdlIHB1dCB0aGlu
Z3MgaW4gL3Vzciwgbm90IC91c3IvbG9jYWwKCXByZWZpeD0nL3VzcicKCXByZWZpeGV4cD0nL3Vz
cicKCXN5c21hbj0nL3Vzci9zaGFyZS9tYW4vbWFuMScKCWxpYnB0aD0nL3Vzci9saWInCglnbGli
cHRoPScvdXNyL2xpYicKCSMgTG9jYWwgdGhpbmdzLCBob3dldmVyLCBkbyBnbyBpbiAvdXNyL2xv
Y2FsCglzaXRlcHJlZml4PScvdXNyL2xvY2FsJwoJc2l0ZXByZWZpeGV4cD0nL3Vzci9sb2NhbCcK
CSMgUG9ydHMgaW5zdGFsbHMgbm9uLXN0ZCBsaWJzIGluIC91c3IvbG9jYWwvbGliIHNvIGxvb2sg
dGhlcmUgdG9vCglsb2NpbmNwdGg9Jy91c3IvbG9jYWwvaW5jbHVkZScKCWxvY2xpYnB0aD0nL3Vz
ci9sb2NhbC9saWInCgkjIExpbmsgcGVybCB3aXRoIHNoYXJlZCBsaWJwZXJsCglpZiBbICIkdXNl
ZGwiID0gIiRkZWZpbmUiIC1hIC1yICRzcmMvc2hsaWJfdmVyc2lvbiBdOyB0aGVuCgkJdXNlc2hy
cGxpYj10cnVlCgkJbGlicGVybD1gLiAkc3JjL3NobGliX3ZlcnNpb247IGVjaG8gbGlicGVybC5z
by4ke21ham9yfS4ke21pbm9yfWAKCWZpCgk7Owplc2FjCgojIGVuZAo=',
'cygwin' =>
'IyEgL2Jpbi9zaAojIGN5Z3dpbi5zaCAtIGhpbnRzIGZvciBidWlsZGluZyBwZXJsIHVzaW5nIHRo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',
'darwin' =>
'IyMKIyBEYXJ3aW4gKE1hYyBPUykgaGludHMKIyBXaWxmcmVkbyBTYW5jaGV6IDx3c2FuY2hlekB3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',
'dragonfly' =>
'IyBoaW50cy9kcmFnb25mbHkuc2gKIwojIFRoaXMgZmlsZSBpcyBtb3N0bHkgY29waWVkIGZyb20g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',
'freebsd' =>
'IyBPcmlnaW5hbCBiYXNlZCBvbiBpbmZvIGZyb20KIyBDYXJsIE0uIEZvbmdoZWlzZXIgPGNtZkBp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',
'gnu' =>
'IyBoaW50cy9nbnUuc2gKIyBPcmlnaW5hbGx5IGNvbnRyaWJ1dGVkIGJ5OiAgTWFyayBLZXR0ZW5p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=',
'gnukfreebsd' =>
'IyEgL2Jpbi9zaAoKIyBTdXBwb3J0IGZvciBEZWJpYW4gR05VL2tGcmVlQlNEIChrZnJlZWJzZC1n
bnUpCiMgQSBwb3J0IG9mIHRoZSBEZWJpYW4gR05VIHN5c3RlbSB1c2luZyB0aGUgRnJlZUJTRCBr
ZXJuZWwuCgouIC4vaGludHMvbGludXguc2gKCg==',
'hpux' =>
'IyEvdXNyL2Jpbi9zaAoKIyMjIFNZU1RFTSBBUkNISVRFQ1RVUkUKCiMgRGV0ZXJtaW5lIHRoZSBh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',
'linux' =>
'IyBoaW50cy9saW51eC5zaAojIE9yaWdpbmFsIHZlcnNpb24gYnkgcnNhbmRlcnMKIyBBZGRpdGlv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',
'midnightbsd' =>
'dXNldmZvcms9J3RydWUnCmNhc2UgIiR1c2VteW1hbGxvYyIgaW4KICAgICIiKSB1c2VteW1hbGxv
Yz0nbicKICAgICAgICA7Owplc2FjCmxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3YW50ZWQgfCBzZWQg
J3MvIG1hbGxvYyAvIC8nYAoKb2JqZm9ybWF0PWAvdXNyL2Jpbi9vYmpmb3JtYXRgCmlmIFsgeCRv
Ympmb3JtYXQgPSB4YW91dCBdOyB0aGVuCiAgICBpZiBbIC1lIC91c3IvbGliL2FvdXQgXTsgdGhl
bgogICAgICAgIGxpYnB0aD0iL3Vzci9saWIvYW91dCAvdXNyL2xvY2FsL2xpYiAvdXNyL2xpYiIK
ICAgICAgICBnbGlicHRoPSIvdXNyL2xpYi9hb3V0IC91c3IvbG9jYWwvbGliIC91c3IvbGliIgog
ICAgZmkKICAgIGxkZGxmbGFncz0nLUJzaGFyZWFibGUnCmVsc2UKICAgIGxpYnB0aD0iL3Vzci9s
aWIgL3Vzci9sb2NhbC9saWIiCiAgICBnbGlicHRoPSIvdXNyL2xpYiAvdXNyL2xvY2FsL2xpYiIK
ICAgIGxkZmxhZ3M9Ii1XbCwtRSAiCiAgICBsZGRsZmxhZ3M9Ii1zaGFyZWQgIgpmaQpjY2NkbGZs
YWdzPSctRFBJQyAtZlBJQycKCmNjZmxhZ3M9IiR7Y2NmbGFnc30gLURIQVNfRlBTRVRNQVNLIC1E
SEFTX0ZMT0FUSU5HUE9JTlRfSCIKaWYgL3Vzci9iaW4vZmlsZSAtTCAvdXNyL2xpYi9saWJjLnNv
IHwgL3Vzci9iaW4vZ3JlcCAtdnEgIm5vdCBzdHJpcHBlZCIgOyB0aGVuCiAgICB1c2VubT1mYWxz
ZQpmaQoKc2lnbmFsX3Q9J3ZvaWQnCmRfdm9pZHNpZz0nZGVmaW5lJwoKIyBUaGlzIHNjcmlwdCBV
VS91c2V0aHJlYWRzLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZSAKIyBh
ZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhlIHVzZXIgZm9yIHdoZXRoZXIgdG8gdXNlIHRocmVhZHMu
CmNhdCA+IFVVL3VzZXRocmVhZHMuY2J1IDw8J0VPQ0JVJwpjYXNlICIkdXNldGhyZWFkcyIgaW4K
JGRlZmluZXx0cnVlfFt5WV0qKQoJbGRmbGFncz0iLXB0aHJlYWQgJGxkZmxhZ3MiCglzZXQgYGVj
aG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBjIC8vJ2AKCXNoaWZ0CglsaWJzd2FudGVk
PSIkKiIKCSMgQ29uZmlndXJlIHdpbGwgcHJvYmFibHkgcGljayB0aGUgd3JvbmcgbGliYyB0byB1
c2UgZm9yIG5tIHNjYW4uCgkjIFRoZSBzYWZlc3QgcXVpY2stZml4IGlzIGp1c3QgdG8gbm90IHVz
ZSBubSBhdCBhbGwuLi4KCXVzZW5tPWZhbHNlCgogICAgICAgIHVuc2V0IGxjX3IKCgkjIEV2ZW4g
d2l0aCB0aGUgbWFsbG9jIG11dGV4ZXMgdGhlIFBlcmwgbWFsbG9jIGRvZXMgbm90CgkjIHNlZW0g
dG8gYmUgdGhyZWFkc2FmZSBpbiBNaWRuaWdodEJTRD8KCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4K
CScnKSB1c2VteW1hbGxvYz1uIDs7Cgllc2FjCmVzYWMKRU9DQlUKCiMgbWFsbG9jIHdyYXAgd29y
a3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicnKSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7
CmVzYWMK',
'netbsd' =>
'IyBoaW50cy9uZXRic2Quc2gKIwojIFBsZWFzZSBjaGVjayB3aXRoIHBhY2thZ2VzQG5ldGJzZC5v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',
'openbsd' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'solaris' =>
'IyBoaW50cy9zb2xhcmlzXzIuc2gKIyBDb250cmlidXRpb25zIGJ5IChpbiBhbHBoYWJldGljYWwg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',
);

my %files = (
  'freebsd' => 'freebsd.sh',
  'netbsd'  => 'netbsd.sh',
  'openbsd' => 'openbsd.sh',
  'linux'   => 'linux.sh',
  'dragonfly' => 'dragonfly.sh',
  'darwin' => 'darwin.sh',
  'hpux' => 'hpux.sh',
  'cygwin' => 'cygwin.sh',
  'midnightbsd' => 'midnightbsd.sh',
  'gnukfreebsd' => 'gnukfreebsd.sh',
  'solaris' => 'solaris_2.sh',
  'bitrig' => 'bitrig.sh',
  'gnu' => 'gnu.sh',
);

sub hint_file {
  my $os = shift;
  $os = shift if eval { $os->isa(__PACKAGE__) };
  $os = $^O unless $os;
  return unless defined $hints{ $os };
  my $content = decode_base64( $hints{ $os } );
  return $content unless wantarray;
  return ( $files{ $os }, $content );
}

sub hints {
  return sort keys %hints;
}

qq'nudge nudge wink wink';

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::PatchPerl::Hints - replacement 'hints' files

=head1 VERSION

version 2.09

=head1 SYNOPSIS

  use Devel::PatchPerl::Hints;

  if ( my $content = Devel::PatchPerl::Hints->hint_file() ) {
    chmod 0644, 'hints/netbsd.sh' or die "$!";
    open my $hints, '>', 'hints/netbsd.sh' or die "$!";
    print $hints $content;
    close $hints;
  }

  # Get a list of OS for which we have hints

  my @os = Devel::PatchPerl::Hints->hints();

=head1 DESCRIPTION

Sometimes there is a problem with Perls C<hints> file for a particular
perl port. This module provides fixed C<hints> files encoded using
C<MIME::Base64>.

=head1 FUNCTION

The function is exported, but has to implicitly imported into the
requesting package.

  use Devel::PatchPerl::Hints qw[hint_file];

It may also be called as a class method:

  use Devel::PatchPerl::Hints;

  my $content = Devel::PatchPerl::Hints->hint_file();

=over

=item C<hint_file>

Takes an optional argument which is the OS name ( as would be returned by C<$^O> ).
By default it will use C<$^O>.

In a scalar context, Will return the decoded content of the C<hints> file suitable for writing straight to a
file handle or undef list if there isn't an applicable C<hints> file for the given or derived
OS.

If called in a list context, will return a list, the first item will be the name of the C<hints> file that
will need to be amended, the second item will be a string with the decoded content of the C<hints> file suitable
for writing straight to a file handle. Otherwise an empty list will be returned.

=item C<hints>

Takes no arguments, returns a list of OS names for which there are C<hints> files.

=back

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by Chris Williams and Marcus Holland-Moritz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
