package DigitalRot::Image;
use strict;
use warnings;
use File::Copy;
use Imager;
use Exporter qw(import);

our @EXPORT_OK = qw(rotate);

#feed: input, output, number of full rotations
sub rotate {
    my ( $Input, $Output, $Passes ) = @_;
    my $type = "jpeg";
    copy( "$Input", "$Output" ) or die "Copy failed: $!";

    #while($Passes>0){
    for my $j ( 1 .. $Passes ) {
        my $img = Imager->new;
        $img->read( file => $Output, type => "jpeg" )
          or die "Cannot read $Input: ", $img->errstr;
        for my $i ( 1 .. 4 ) {
            print "$j,$i\n";
            $img->read( file => $Output, type => "jpeg" )
              or die "Cannot read $Input: ", $img->errstr;
            $img = $img->rotate( degrees => 90 );
            $img->write( file => $Output, jpegquality => 90, type => "jpeg" )
              or die "Cannot write: ", $img->errstr;
        }
    }
}

1;
