package Finance::GeniusTrader::Signals::Indicators::RSIDown;

# Copyright 2000-2002 Raphal Hertzog, Fabien Fulhaber
# This file is distributed under the terms of the General Public License
# version 2 or (at your option) any later version.

use strict;
use vars qw(@ISA @NAMES);

use Finance::GeniusTrader::Signals;
use Finance::GeniusTrader::Prices;
use Finance::GeniusTrader::Indicators::RSI;

@ISA = qw(Finance::GeniusTrader::Signals);
@NAMES = ("RSIDown[#1,#2]");

=head1 Finance::GeniusTrader::Signals::Indicators::RSIDown

Signal when we cross down a limit on the RSI. Limit is 70 by default.

=cut
sub new {
    my $type = shift;
    my $class = ref($type) || $type;
    my $args = shift;

    my $self = { "args" => defined($args) ? $args : [70, 14] };
    $self->{'args'}[1] = 14 if (! defined($self->{'args'}[1]));
    
    return manage_object(\@NAMES, $self, $class, $self->{'args'}, "");
}

sub initialize {
    my ($self) = @_;
    
    $self->{'rsi'} = Finance::GeniusTrader::Indicators::RSI->new([ $self->{'args'}[1] ]);

    $self->add_indicator_dependency($self->{'rsi'}, 2);
}

sub detect {
    my ($self, $calc, $i) = @_;
    my $indic = $calc->indicators;
    my $limit = $self->{'args'}[0];
    my $rsiname = $self->{'rsi'}->get_name;
    my $name = $self->get_name;

    return if ($calc->signals->is_available($name, $i));
    return if (! $self->check_dependencies($calc, $i));
    
    # Test if we have crossed the 70 limit
    if ( # RSI of $i-1 >= 70
	 $indic->get($rsiname, $i - 1) >= $limit &&

	 # RSI of $i < 70
	 $indic->get($rsiname, $i) < $limit
       )
    {
	$calc->signals->set($name, $i, 1);
    } else {
	$calc->signals->set($name, $i, 0);
    }
}

1;
