package App::Manoc::DB::ResultSet::VlanRange;
#ABSTRACT: ResultSet class for VlanRange

use strict;
use warnings;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';


sub get_overlap_ranges {
    my ( $self, $lan_segment, $start, $end ) = @_;

    my $lan_segment_id = ref($lan_segment) ? $lan_segment->id : $lan_segment;

    my $conditions = {
        -or => [
            {
                start => { '<=' => $start },
                end   => { '>=' => $start },
            },
            {
                start => { '<=' => $end },
                end   => { '>=' => $end },
            },
        ],
        lan_segment_id => $lan_segment_id,
    };

    return
        wantarray ? $self->search($conditions)->all :
        $self->search_rs($conditions);
}


sub manoc_search {
    my ( $self, $query, $result ) = @_;

    my $query_type = $query->query_type;

    return unless $query_type eq 'inventory';

    my $pattern = $query->sql_pattern;

    my $rs = $self->search( { name => { '-like' => $pattern } }, { order_by => 'id' } );

    while ( my $e = $rs->next ) {

        my $item = App::Manoc::DB::Search::Result::VlanRange->new(
            {
                name  => $e->name,
                match => $e->name,
            }
        );
        $result->add_item($item);
    }
}


1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::VlanRange - ResultSet class for VlanRange

=head1 VERSION

version 2.99.3

=head1 METHODS

=head2 get_overlap_ranges( $lan_segment, $start, $end )

Return all the VlanRange which are overlap the given internal.

=head2 manoc_search(  $query, $result)

Support for Manoc search feature

=head1 SEE ALSO

L<DBIx::Class::ResultSet>

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
